/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.util.Pair;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.jaxb.ipc.IdMapType;
import ds.jaxb.ipc.Message;
import java.util.logging.Level;

public class IdMapClosure
extends MessageClosure {
    public IdMapClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getInfo() == null) {
            return false;
        }
        return message.getInfo().getIdMap() != null;
    }

    protected void handleMessage(Message message) {
        IdMapType idMapType = message.getInfo().getIdMap();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved id map");
        }
        TaskId taskId = this.createTaskId(idMapType.getCmdId());
        int n = idMapType.getTmpId();
        Task task = this.live.getMainSystem().registerId(n, taskId);
        if (task == null || !(task instanceof MutableTask)) {
            this.live.getMainSystem().logEvent(Level.WARNING, String.format("Id map received for unknown task:\r\n\tTmpId: %d == Id: %d", idMapType.getTmpId(), idMapType.getCmdId()));
            return;
        }
        MutableTask mutableTask = (MutableTask)task;
        mutableTask.setId(taskId);
        Pair<IdCallback, Object> pair = this.live.extractCallback(n);
        if (pair == null) {
            this.live.getMainSystem().logEvent(Level.WARNING, String.format("Id map received for unknown task:\r\n\tTmpId: %d == Id: %d", idMapType.getTmpId(), idMapType.getCmdId()));
            return;
        }
        IdCallback idCallback = (IdCallback)pair.getFirst();
        Object object = pair.getSecond();
        if (idCallback != null) {
            idCallback.idAcquired(taskId, object);
        }
    }
}

