/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commanddispatcher.live;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.task.MutableTask;
import ddb.dsz.core.task.TaskId;
import ds.core.commanddispatcher.LiveCommandDispatcher;
import ds.core.commanddispatcher.live.MessageClosure;
import ds.core.commandevents.CommandEventImpl;
import ds.jaxb.ipc.Message;
import ds.jaxb.ipc.StartPromptType;
import java.util.logging.Level;

public class StartPromptClosure
extends MessageClosure {
    public StartPromptClosure(LiveCommandDispatcher liveCommandDispatcher) {
        super(liveCommandDispatcher);
    }

    protected boolean evaluateMessage(Message message) {
        if (message.getReq() == null) {
            return false;
        }
        StartPromptType startPromptType = message.getReq().getStartPrompt();
        return startPromptType != null;
    }

    protected void handleMessage(Message message) {
        StartPromptType startPromptType = message.getReq().getStartPrompt();
        if (this.live.getMainSystem().isDebugMode()) {
            this.live.getMainSystem().logEvent(Level.FINEST, "Recieved start prompt");
        }
        int n = message.getReq().getReqId();
        TaskId taskId = this.createTaskId(startPromptType.getCmdId());
        MutableTask mutableTask = this.getTaskById(taskId);
        if (mutableTask == null) {
            this.live.getMainSystem().logEvent(Level.SEVERE, "Received prompt request for unknown command");
            this.live.handleUnknownTaskPrompt(message);
            return;
        }
        mutableTask.setInPromptMode(true);
        TaskId taskId2 = mutableTask.getParentId();
        String string = mutableTask.getCommandName();
        String string2 = startPromptType.getValue();
        CommandEventImpl commandEventImpl = new CommandEventImpl((Object)this, CommandEvent.CommandEventType.START_PROMPT, string, string2, taskId, taskId2, mutableTask.getTargetId(), n);
        commandEventImpl.setCurrentOperation(true);
        commandEventImpl.setTargetAddress(mutableTask.getTargetId());
        this.live.publishEvent(commandEventImpl);
    }
}

