/*
 * Decompiled with CFR 0.152.
 */
package ds.core.commandevents;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.CommandEventDemultiplexor;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.task.Task;
import ddb.util.UtilityConstants;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandEventDemultiplexorImpl
extends CommandEventDemultiplexor {
    private boolean caresAboutLocal;
    private boolean caresAboutRepeat;
    private ReadWriteLock LOCK = UtilityConstants.createReadWriteLock();
    final Map<String, Collection<CommandEventListener>> handlers = new HashMap<String, Collection<CommandEventListener>>();
    final Collection<CommandEventListener> allHandlers = new HashSet<CommandEventListener>();
    final Collection<CommandEventListener> defaultHandlers = new HashSet<CommandEventListener>();

    private CommandEventListener generate(CommandEventListener commandEventListener) {
        return commandEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandEventListenerDefault(CommandEventListener commandEventListener) {
        this.LOCK.writeLock().lock();
        try {
            this.defaultHandlers.add(commandEventListener);
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandEventListenerAll(CommandEventListener commandEventListener) {
        this.LOCK.writeLock().lock();
        try {
            this.allHandlers.add(this.generate(commandEventListener));
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandEventListenerDefault(CommandEventListener commandEventListener) {
        this.LOCK.writeLock().lock();
        try {
            for (CommandEventListener commandEventListener2 : this.defaultHandlers) {
                if (!commandEventListener2.equals(commandEventListener)) continue;
                this.defaultHandlers.remove(commandEventListener2);
                return;
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandEventListenerAll(CommandEventListener commandEventListener) {
        this.LOCK.writeLock().lock();
        try {
            for (CommandEventListener commandEventListener2 : this.allHandlers) {
                if (!commandEventListener2.equals(commandEventListener)) continue;
                this.allHandlers.remove(commandEventListener2);
                return;
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandEventListener(String string, CommandEventListener commandEventListener) {
        if (string == null) {
            return;
        }
        this.LOCK.writeLock().lock();
        try {
            Collection<CommandEventListener> collection = this.handlers.get(string);
            if (collection == null) {
                collection = new HashSet<CommandEventListener>();
                this.handlers.put(string, collection);
            }
            for (CommandEventListener commandEventListener2 : collection) {
                if (!commandEventListener2.equals(commandEventListener)) continue;
                return;
            }
            collection.add(this.generate(commandEventListener));
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandEventListener(String string, CommandEventListener commandEventListener) {
        if (string == null) {
            return;
        }
        this.LOCK.writeLock().lock();
        try {
            Collection<CommandEventListener> collection = this.handlers.get(string);
            if (collection == null) {
                return;
            }
            for (CommandEventListener commandEventListener2 : collection) {
                if (!commandEventListener2.equals(commandEventListener)) continue;
                collection.remove(commandEventListener2);
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommandEventListener(CommandEventListener commandEventListener) {
        this.LOCK.writeLock().lock();
        try {
            this.removeCommandEventListener(null, commandEventListener);
            for (String string : this.handlers.keySet()) {
                this.removeCommandEventListener(string, commandEventListener);
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<CommandEventListener> getHandlers(String string) {
        HashSet<CommandEventListener> hashSet = new HashSet<CommandEventListener>();
        this.LOCK.readLock().lock();
        try {
            hashSet.addAll(this.allHandlers);
            Collection<CommandEventListener> collection = this.handlers.get(string);
            if (collection == null || collection.size() == 0) {
                collection = this.defaultHandlers;
            }
            hashSet.addAll(collection);
        }
        finally {
            this.LOCK.readLock().unlock();
        }
        return hashSet;
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        for (CommandEventListener commandEventListener : this.getHandlers(commandEvent.getTargetAddress())) {
            try {
                commandEventListener.commandEventReceived(commandEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean handlesPromptsForTask(Task task, int n) {
        for (CommandEventListener commandEventListener : this.getHandlers(task.getTargetId())) {
            try {
                if (!commandEventListener.handlesPromptsForTask(task, n)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean caresAboutLocalEvents() {
        return this.caresAboutLocal;
    }

    public boolean caresAboutRepeatedEvents() {
        return this.caresAboutRepeat;
    }

    public Comparator<CommandEvent> getComparator() {
        return null;
    }

    public void setCaresAboutLocal(boolean bl) {
        this.caresAboutLocal = bl;
    }

    public void setCaresAboutRepeat(boolean bl) {
        this.caresAboutRepeat = bl;
    }

    public void stop() {
    }

    public void addCommandEventListener(CommandEventListener commandEventListener) {
        this.addCommandEventListenerAll(commandEventListener);
    }
}

