/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.peer;

import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ds.core.DSConstants;
import ds.core.controller.MutableCoreController;
import ds.gui.PluginWorkbench;
import ds.jaxb.external.RemoteMessage;
import ds.plugin.PluginContainer;
import ds.plugin.peer.PeerSocketHandler;
import ds.plugin.peer.PeerWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Peer
extends PluginContainer {
    PeerWorkbench myWorkbench;
    protected MutableCoreController mcc;
    protected JPanel mainPanel;

    public Peer() {
        super.setUserClosable(false);
    }

    public boolean ShowButtons() {
        return false;
    }

    @Override
    protected final int init3() {
        if (this.core instanceof MutableCoreController) {
            this.mcc = (MutableCoreController)MutableCoreController.class.cast(this.core);
            this.mcc.registerPeer(this);
        }
        this.myWorkbench = new PeerWorkbench(this, this.core, DSConstants.SUB_TAB_ALIGNMENT);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.designTop(), "North");
        this.mainPanel.add((Component)((Object)this.myWorkbench), "Center");
        super.setDisplay((JComponent)this.mainPanel);
        return this.init4();
    }

    protected int init4() {
        return 0;
    }

    @Override
    public PluginWorkbench getChildWorkbench() {
        return this.myWorkbench;
    }

    protected abstract JComponent designTop();

    public abstract PeerTransferStatus sendMessage(String var1, PeerTag var2);

    public void receivedMessage(RemoteMessage remoteMessage, PeerTag peerTag) {
        this.mcc.fireReceivedMessage(remoteMessage.getMessage(), peerTag);
    }

    public void connectionUpdated(PeerSocketHandler peerSocketHandler) {
    }

    public void connectionStopping(PeerTag peerTag) {
        this.mcc.firePeerDisconnected(peerTag);
    }

    @Override
    public boolean allowNewInstance(Class<?> clazz) {
        if (!super.allowNewInstance(clazz)) {
            return false;
        }
        if (!this.myWorkbench.allowNewInstance(clazz)) {
            return false;
        }
        return !Peer.class.isAssignableFrom(clazz);
    }
}

