/*
 * Decompiled with CFR 0.152.
 */
package ds.plugin.peer;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.peer.PeerTransferStatus;
import ds.plugin.peer.Peer;
import ds.plugin.peer.PeerSocketHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;

@DszLogo(value="images/kwallet2.png")
@DszName(value="Peer")
@DszDescription(value="Handles communication between this computer and a Peer")
public class PeerServer
extends Peer {
    ServerSocket server;
    List<PeerSocketHandler> remoteConnections = new Vector<PeerSocketHandler>();
    int serverPort = 0;
    JPanel listeningOn = new JPanel(new GridLayout(2, 3));
    JLabel connectionInfo = new JLabel("");
    Closure closure = ClosureUtils.nopClosure();
    final Object connectionLock = new Object();
    DefaultListModel dlm = new DefaultListModel();
    JList connections = new JList(this.dlm);
    boolean sentPort = false;
    Runnable sendPing = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = PeerServer.this.connectionLock;
            synchronized (object) {
                for (int i = 0; i < PeerServer.this.remoteConnections.size(); ++i) {
                    if (PeerTransferStatus.SENT.equals((Object)PeerServer.this.remoteConnections.get(i).sendPing())) continue;
                    PeerServer.this.remoteConnections.remove(i);
                    --i;
                }
            }
            PeerServer.this.core.schedule((Runnable)this, 15L, TimeUnit.SECONDS);
        }
    };

    public int init4() {
        this.connections.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof PeerSocketHandler) {
                    ((JLabel)JLabel.class.cast(component)).setText(((PeerSocketHandler)PeerSocketHandler.class.cast(object)).toString());
                }
                return component;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.connections);
        this.core.submit(this.sendPing);
        try {
            this.server = new ServerSocket();
            this.server.bind(null, 5);
            this.serverPort = this.server.getLocalPort();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!inetAddress.getHostAddress().matches("\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}")) continue;
                    JLabel jLabel = new JLabel(String.format("%s:%s", inetAddress.getHostAddress(), this.serverPort));
                    this.listeningOn.add(jLabel);
                }
            }
            this.core.newThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket socket = PeerServer.this.server.accept();
                                Object object = PeerServer.this.connectionLock;
                                synchronized (object) {
                                    final PeerSocketHandler peerSocketHandler = new PeerSocketHandler(PeerServer.this.core, socket, PeerServer.this);
                                    peerSocketHandler.begin("Live Peer");
                                    PeerServer.this.mcc.firePeerConnected(peerSocketHandler);
                                    PeerServer.this.remoteConnections.add(peerSocketHandler);
                                    EventQueue.invokeLater(new Runnable(){

                                        public void run() {
                                            PeerServer.this.dlm.addElement(peerSocketHandler);
                                        }
                                    });
                                }
                            }
                        }
                        catch (Exception exception) {
                            PeerServer.this.core.logEvent(Level.SEVERE, exception.getMessage(), (Throwable)exception);
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }
        catch (Exception exception) {
            this.core.logEvent(Level.SEVERE, PeerServer.class.getSimpleName(), "Unable to start server", (Throwable)exception);
            return -1;
        }
        return 0;
    }

    protected JComponent designTop() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.listeningOn.setBorder(BorderFactory.createTitledBorder("Listening On:"));
        jPanel.add((Component)this.listeningOn, "Center");
        jPanel.add((Component)this.connectionInfo, "East");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerTransferStatus sendMessage(String string, PeerTag peerTag) {
        if (peerTag == null) {
            Object object = this.connectionLock;
            synchronized (object) {
                int n = 0;
                for (int i = 0; i < this.remoteConnections.size(); ++i) {
                    if (PeerTransferStatus.SENT.equals((Object)this.remoteConnections.get(i).sendMessage(string))) {
                        ++n;
                        continue;
                    }
                    this.remoteConnections.remove(i);
                    --i;
                }
                if (n > 0) {
                    return PeerTransferStatus.SENT;
                }
                return PeerTransferStatus.DISCONNECTED;
            }
        }
        int n = this.remoteConnections.indexOf(peerTag);
        if (n == -1) {
            return PeerTransferStatus.DESTINATION_NOT_FOUND;
        }
        return this.remoteConnections.get(n).sendMessage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionStopping(final PeerTag peerTag) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (peerTag instanceof PeerSocketHandler) {
                this.remoteConnections.remove((PeerSocketHandler)peerTag);
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PeerServer.this.dlm.removeElement(peerTag);
                }
            });
        }
        super.connectionStopping(peerTag);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        super.commandEventReceived(commandEvent);
        if (!this.sentPort) {
            this.sentPort = true;
            this.core.setCommandEnvironmentVariable("Network_Server_Port", String.format("%d", this.serverPort));
        }
    }
}

