/*
 * Decompiled with CFR 0.152.
 */
package ds.proxy;

import ddb.dsz.annotations.DszQueuableMethod;
import ddb.util.UtilityConstants;
import ddb.util.proxy.DszProxyHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueuedInvocationHandler<O>
extends DszProxyHandler<O>
implements InvocationHandler,
Runnable {
    final ExecutorService exec;
    Logger log;

    public static <O> O newInstance(O o) {
        return QueuedInvocationHandler.newInstance(o, new Class[0]);
    }

    public static <O> O newInstance(O o, Logger logger) {
        return QueuedInvocationHandler.newInstance(o, logger, new Class[0]);
    }

    public static <O> O newInstance(O o, Class<?> ... classArray) {
        return QueuedInvocationHandler.newInstance(o, Logger.getLogger("dsz.core"), classArray);
    }

    public static <O> O newInstance(O o, Logger logger, Class<?> ... classArray) {
        return (O)DszProxyHandler.newInstance(o, new QueuedInvocationHandler<O>(o, logger), (Class[])classArray);
    }

    public QueuedInvocationHandler(O o, Logger logger) {
        super(o);
        this.log = logger;
        this.exec = UtilityConstants.createSingleThreadExecutorService((String)String.format("QueuedInvocationHandler: %s", o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            if (method.getAnnotation(DszQueuableMethod.class) == null) return method.invoke(this.object, objectArray);
            this.exec.submit(new QueuedObject(this.object, method, objectArray));
            return null;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.log.log(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException.getTargetException());
            return null;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    @Override
    public void run() {
    }

    public void stop() {
        this.exec.shutdown();
    }

    class QueuedObject
    implements Runnable {
        Object obj;
        Method m;
        Object[] args;

        public QueuedObject(Object object, Method method, Object[] objectArray) {
            this.obj = object;
            this.m = method;
            this.args = objectArray;
        }

        public void run() {
            try {
                this.m.invoke(this.obj, this.args);
            }
            catch (InvocationTargetException invocationTargetException) {
                QueuedInvocationHandler.this.log.log(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                QueuedInvocationHandler.this.log.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }
}

