/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.data.ErrorEvent;
import ddb.dsz.core.data.TransformEvent;

class DataTransformsErrorEvent
implements ErrorEvent {
    ErrorEvent.ErrorEventType type;
    ErrorEvent.ErrorLevel level;
    String msg;
    int line;

    public DataTransformsErrorEvent(ErrorEvent.ErrorEventType errorEventType, ErrorEvent.ErrorLevel errorLevel, int n, String string) {
        this.type = errorEventType;
        this.level = errorLevel;
        this.msg = string;
        this.line = n;
    }

    public TransformEvent.TransformEventType getType() {
        return TransformEvent.TransformEventType.ERROR;
    }

    public int getLine() {
        return this.line;
    }

    public ErrorEvent.ErrorLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.msg;
    }

    public ErrorEvent.ErrorEventType getErrorType() {
        return this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case STORAGE: {
                stringBuilder.append("Storage - ");
                break;
            }
            case TRANSFORM: {
                stringBuilder.append("Transform - ");
                break;
            }
            case DOCUMENTBUILDER: {
                stringBuilder.append("DocumentBuilder - ");
                break;
            }
            case NODOCUMENTS: {
                stringBuilder.append("No Documents - ");
            }
        }
        switch (this.level) {
            case ERROR: {
                stringBuilder.append("Error");
                break;
            }
            case FATAL: {
                stringBuilder.append("Fatal Error");
                break;
            }
            case WARNING: {
                stringBuilder.append("Warning");
            }
        }
        stringBuilder.append(String.format("(%d): %s", this.line, this.msg));
        return stringBuilder.toString();
    }
}

