/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ds.core.DSConstants;
import ds.core.impl.task.TaskStateAccess;
import ds.util.datatransforms.TaskClosure;
import java.io.Reader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.Closure;

public class ReadXmlClosure
extends TaskClosure
implements Closure {
    private static final ScheduledExecutorService READER = Executors.newScheduledThreadPool(1, DSConstants.namedFactory("ReadXmlClosure"));
    final Closure handleData;

    public ReadXmlClosure(CoreController coreController, Task task, Closure closure, Closure closure2) {
        super(closure2);
        this.handleData = closure;
    }

    public void execute(Object object) {
        if (object == null || !(object instanceof TaskDataAccess)) {
            return;
        }
        if (object instanceof TaskStateAccess) {
            return;
        }
        TaskDataAccess taskDataAccess = (TaskDataAccess)object;
        if (taskDataAccess.isGenerated()) {
            return;
        }
        READER.submit(new ReadFile(taskDataAccess));
    }

    class ReadFile
    implements Runnable {
        final TaskDataAccess tda;
        long progress;

        public ReadFile(TaskDataAccess taskDataAccess) {
            this.tda = taskDataAccess;
            this.progress = 0L;
        }

        public void run() {
            boolean bl = !this.tda.getTask().isAlive();
            long l = 5L;
            if (this.progress < this.tda.getSize()) {
                Reader reader = this.tda.getReader();
                if (reader == null) {
                    this.progress = this.tda.getSize();
                } else {
                    char[] cArray = new char[8096];
                    try {
                        int n;
                        reader.skip(this.progress);
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((n = reader.read(cArray)) > 0) {
                            stringBuilder.append(cArray, 0, n);
                            this.progress += (long)n;
                            l = 0L;
                        }
                        if (stringBuilder.length() > 0) {
                            ReadXmlClosure.this.handleData.execute((Object)stringBuilder.toString());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (!bl) {
                READER.schedule(this, l, TimeUnit.SECONDS);
            }
        }
    }
}

