/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.task.TaskDataAccess;
import ddb.util.XmlCache;
import ds.util.datatransforms.DataTransformerImpl2;
import ds.util.datatransforms.URIResolverImpl;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class TaskClosure {
    Closure handleError = ClosureUtils.nopClosure();
    protected final List<DataTransformerImpl2> transformers = new Vector<DataTransformerImpl2>();
    private Reference<TransformerFactory> TransformerFactoryRef = new WeakReference<Object>(null);
    private Reference<DocumentBuilder> DocBuilder = new WeakReference<Object>(null);

    protected TaskClosure(Closure closure) {
        if (closure != null) {
            this.handleError = closure;
        }
    }

    protected synchronized DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = this.DocBuilder.get();
        if (documentBuilder != null) {
            return documentBuilder;
        }
        documentBuilder = XmlCache.getBuilder();
        this.DocBuilder = new SoftReference<DocumentBuilder>(documentBuilder);
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
                TaskClosure.this.handleError.execute((Object)sAXParseException);
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                TaskClosure.this.handleError.execute((Object)sAXParseException);
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                TaskClosure.this.handleError.execute((Object)sAXParseException);
            }
        });
        return documentBuilder;
    }

    protected synchronized TransformerFactory getTransformerFactory() {
        TransformerFactory transformerFactory = this.TransformerFactoryRef.get();
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(new ErrorListener(){

                public void warning(TransformerException transformerException) throws TransformerException {
                    TaskClosure.this.handleError.execute((Object)transformerException);
                }

                public void error(TransformerException transformerException) throws TransformerException {
                    TaskClosure.this.handleError.execute((Object)transformerException);
                }

                public void fatalError(TransformerException transformerException) throws TransformerException {
                    TaskClosure.this.handleError.execute((Object)transformerException);
                }
            });
            try {
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.FALSE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.TransformerFactoryRef = new SoftReference<TransformerFactory>(transformerFactory);
        }
        return transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTransformer(DataTransformerImpl2 dataTransformerImpl2) {
        List<DataTransformerImpl2> list = this.transformers;
        synchronized (list) {
            this.transformers.add(dataTransformerImpl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTransformer(DataTransformerImpl2 dataTransformerImpl2) {
        List<DataTransformerImpl2> list = this.transformers;
        synchronized (list) {
            this.transformers.remove(dataTransformerImpl2);
        }
    }

    protected Transformer createTransformer(String string, String string2, String[] stringArray) {
        return this.createTransformer(new File(string), string2, stringArray);
    }

    protected Transformer createTransformer(File file, String string, String[] stringArray) {
        if (file == null || !file.exists()) {
            return null;
        }
        TransformerFactory transformerFactory = this.getTransformerFactory();
        if (transformerFactory == null) {
            return null;
        }
        try {
            transformerFactory.setURIResolver(new URIResolverImpl(file.getParentFile(), string, stringArray));
            return transformerFactory.newTransformer(new StreamSource(file));
        }
        catch (Exception exception) {
            this.handleError(exception);
            return null;
        }
    }

    protected void handleError(Exception exception) {
        if (this.handleError != null) {
            this.handleError.execute((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeue(TaskDataAccess taskDataAccess) {
        Vector<DataTransformerImpl2> vector = new Vector<DataTransformerImpl2>();
        List<DataTransformerImpl2> list = this.transformers;
        synchronized (list) {
            vector.addAll(this.transformers);
        }
        for (DataTransformerImpl2 dataTransformerImpl2 : this.transformers) {
            dataTransformerImpl2.requeue(taskDataAccess);
        }
    }
}

