/*
 * Decompiled with CFR 0.152.
 */
package ds.util.datatransforms;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.data.DataEvent;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ds.util.datatransforms.CommandMetaDataClosure;
import ds.util.datatransforms.DataTransformsDataEvent;
import ds.util.datatransforms.DataType;
import ds.util.datatransforms.transformers.ObjectValueImpl;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.collections.Closure;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VariableTaskClosure
extends CommandMetaDataClosure {
    protected Collection<TaskId> knownChildren = new HashSet<TaskId>();
    protected Reference<Transformer> transformerRef = new WeakReference<Object>(null);
    protected final String taskName;
    protected final String resourceDirectory;

    protected VariableTaskClosure(CoreController coreController, Task task, Closure closure, Closure closure2) {
        super(coreController, task, closure, closure2);
        this.taskName = task.getCommandName().toLowerCase();
        this.resourceDirectory = task.getResourceDirectory();
    }

    protected VariableTaskClosure(CoreController coreController, String string, String string2, Closure closure, Closure closure2) {
        super(coreController, string, string2, closure, closure2);
        this.taskName = string;
        this.resourceDirectory = string2;
    }

    private synchronized Transformer getTransformer() {
        Transformer transformer = this.transformerRef.get();
        if (transformer == null) {
            String string;
            String string2 = String.format("%s_storage.xsl", this.taskName.toLowerCase());
            if (super.getTask() != null) {
                string2 = super.getTask().getStorageTransform();
            }
            if ((transformer = this.createTransformer(string = String.format("%s/%s/Commands/Storage/%s", this.core.getResourceDirectory(), this.resourceDirectory, string2), this.core.getResourceDirectory(), this.core.getResourcePackages())) == null) {
                this.core.logEvent(Level.INFO, String.format("Unable to create transformer with input '%s'", string));
            }
            this.transformerRef = new SoftReference<Transformer>(transformer);
        }
        return transformer;
    }

    protected void handleNode(Node node, TaskDataAccess taskDataAccess) {
        Transformer transformer = this.getTransformer();
        if (transformer == null || this.handleData == null) {
            return;
        }
        final DataTransformsDataEvent dataTransformsDataEvent = new DataTransformsDataEvent(DataEvent.DataEventType.DATA, null, taskDataAccess.getTask().getId());
        final String string = VariableTaskClosure.getLpTimestamp(node);
        final String string2 = VariableTaskClosure.getDataTimestamp(node);
        dataTransformsDataEvent.setTimestamp(string);
        ObjectValueImpl.AddData(dataTransformsDataEvent.getData(), DataType.INTEGER, "Ordinal", taskDataAccess.getOrdinal());
        ObjectValueImpl.AddData(dataTransformsDataEvent.getData(), DataType.INTEGER, "Size", taskDataAccess.getTask().getNextOrdinal());
        try {
            transformer.transform(new DOMSource(node), new SAXResult(new DefaultHandler(){
                Stack<ObjectValueImpl> objects = new Stack();
                StringBuilder sb = new StringBuilder();
                String dataName;

                public void startElement(String string5, String string22, String string3, Attributes attributes) throws SAXException {
                    this.sb.setLength(0);
                    String string4 = attributes.getValue("name");
                    if (string4 == null) {
                        // empty if block
                    }
                    if (DataType.OBJECT.isElement(string3)) {
                        ObjectValueImpl objectValueImpl = new ObjectValueImpl();
                        if (this.objects.isEmpty()) {
                            dataTransformsDataEvent.addObject(string4, objectValueImpl);
                        } else {
                            this.objects.peek().addValue(DataType.OBJECT, string4, objectValueImpl);
                        }
                        this.objects.push(objectValueImpl);
                        if (this.objects.size() == 1) {
                            objectValueImpl.addValue(DataType.STRING, "gui_timestamp", string);
                            objectValueImpl.addValue(DataType.STRING, "gui_LpTimestamp", string);
                            objectValueImpl.addValue(DataType.STRING, "gui_DataTimestamp", string2);
                        }
                    } else {
                        this.dataName = string4;
                    }
                }

                public void endElement(String string4, String string22, String string3) throws SAXException {
                    if (!this.objects.isEmpty()) {
                        DataType dataType = DataType.getTypeForName(string3);
                        if (dataType == DataType.OBJECT) {
                            this.objects.pop();
                            return;
                        }
                        if (dataType != null) {
                            try {
                                this.objects.peek().addValue(dataType, this.dataName, this.sb.toString());
                            }
                            catch (Exception exception) {
                                VariableTaskClosure.this.core.logEvent(Level.WARNING, exception.getMessage());
                            }
                        }
                    }
                }

                public void characters(char[] cArray, int n, int n2) throws SAXException {
                    this.sb.append(cArray, n, n2);
                }
            }));
            this.handleData.execute((Object)dataTransformsDataEvent);
            transformer.reset();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static final String getLpTimestamp(Node node) {
        try {
            return node.getAttributes().getNamedItem("lptimestamp").getTextContent();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final String getDataTimestamp(Node node) {
        try {
            return node.getAttributes().getNamedItem("dataTimestamp").getTextContent();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

