/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.verifier;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.annotations.DszUserStartable;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskState;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.verifier.OptionalHidingPredicate;
import ddb.dsz.plugin.verifier.StateRenderer;
import ddb.dsz.plugin.verifier.TaskStateRenderer;
import ddb.dsz.plugin.verifier.VerifierColumn;
import ddb.dsz.plugin.verifier.VerifierModel2;
import ddb.dsz.plugin.verifier.VerifierState;
import ddb.imagemanager.ImageManager;
import ddb.util.checkedtablemodel.CheckableFilterList;
import ddb.util.checkedtablemodel.CheckedFilterUpdater;
import ddb.util.checkedtablemodel.FilterWatcher;
import ddb.util.predicate.MustMatchOnePredicate;
import ddb.util.tablefilter.FilteredTableModel;
import ddb.util.tablefilter.sample.ColumnHidingModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AllPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/gkrellm2.png")
@DszName(value="Log Verifier")
@DszDescription(value="Verifies that the XML logs are in the proper format")
@DszUserStartable(value=true)
public class Verifier
extends NoHostAbstractPlugin {
    VerifierModel2 model;
    OptionalHidingPredicate success = new OptionalHidingPredicate((Object)VerifierState.VerifySuccess);
    OptionalHidingPredicate failure = new OptionalHidingPredicate((Object)VerifierState.VerifyFailure);
    OptionalHidingPredicate noLog = new OptionalHidingPredicate((Object)VerifierState.NoLog, false);
    final JCheckBox suspendVerification = new JCheckBox("Suspend Verification");
    MustMatchOnePredicate visibleGuidsPredicate = new MustMatchOnePredicate();
    ColumnHidingModel hider = new ColumnHidingModel(VerifierColumn.class);
    FilteredTableModel filteredModel;
    FilterWatcher guidWatcher = new FilterWatcher(){

        public void predicateChanged() {
            Verifier.this.filteredModel.filterChanged();
        }
    };
    CheckedFilterUpdater<Operation> guidSelected = new CheckedFilterUpdater<Operation>(this.visibleGuidsPredicate, this.guidWatcher){

        public void selected(Operation operation, boolean bl) {
            super.selected((Object)operation, bl);
            if (Verifier.this.visibleGuidsPredicate.getCount() == 1) {
                Verifier.this.hider.hide((Enum)VerifierColumn.OP);
            } else if (Verifier.this.hider.show((Enum)VerifierColumn.OP)) {
                Verifier.this.hider.moveColumnBefore((Enum)VerifierColumn.OP, (Enum)VerifierColumn.ID);
            }
        }
    };
    CheckableFilterList<Operation> visibleGuids = new CheckableFilterList("Visible Operations", this.guidSelected, (Comparator)new Comparator<Operation>(){

        @Override
        public int compare(Operation operation, Operation operation2) {
            if (operation == operation2) {
                return 0;
            }
            if (operation == null) {
                return 1;
            }
            return operation.compareTo((Object)operation2);
        }
    });
    private JTable table;
    final JTextArea verifierOutput = new JTextArea();
    int selectedRow = -1;
    JButton reverify = new JButton("Reverify");

    public Verifier() {
        super.setCareAboutLocalEvents(true);
        super.setCanClose(true);
        super.setUserClosable(true);
    }

    protected boolean parseArgument2(String string, String string2) {
        if (string.equals("-maxDefault")) {
            try {
                this.model.setMaximumLength(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                this.core.logEvent(Level.WARNING, String.format("Invalid format of parameter %s=%s", string, string2), (Throwable)numberFormatException);
            }
        }
        return false;
    }

    protected int init2() {
        this.core.logEvent(Level.FINE, "Initializing Log Verifier");
        this.model = new VerifierModel2(this, this.core.getTaskList(), this.core);
        this.filteredModel = new FilteredTableModel((TableModel)this.model);
        this.filteredModel.addFilter(AllPredicate.getInstance((Predicate[])new Predicate[]{this.success, this.failure, this.noLog}), new Enum[]{VerifierColumn.VERIFY_STATUS});
        this.filteredModel.addFilter((Predicate)this.visibleGuidsPredicate, new Enum[]{VerifierColumn.GUID});
        this.table = new JTable();
        this.table.setColumnModel((TableColumnModel)this.hider);
        this.table.setModel((TableModel)this.filteredModel);
        this.hider.applyToTable(this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.table.setDefaultRenderer(VerifierState.class, (TableCellRenderer)((Object)new StateRenderer()));
        this.table.setDefaultRenderer(TaskState.class, (TableCellRenderer)((Object)new TaskStateRenderer(this.core)));
        this.table.setSelectionMode(0);
        JPanel jPanel = this.layoutFilterPanel();
        this.verifierOutput.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.verifierOutput);
        final JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                jSplitPane.removeComponentListener(this);
                jSplitPane.setDividerLocation(0.6);
                jSplitPane.setDividerLocation(1.0);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = Verifier.this.table.getSelectedRow();
                Verifier.this.selectedRow = Verifier.this.filteredModel.translateViewLocationToModelRow(n, 0);
                if (Verifier.this.selectedRow == -1) {
                    return;
                }
                Verifier.this.setOutput(Verifier.this.selectedRow);
                if (Verifier.this.verifierOutput.getText().length() > 0) {
                    if ((double)jSplitPane.getDividerLocation() >= (double)jSplitPane.getMaximumDividerLocation() * 0.8) {
                        if (jSplitPane.getLastDividerLocation() >= jSplitPane.getMaximumDividerLocation()) {
                            jSplitPane.setDividerLocation(0.8);
                        } else {
                            jSplitPane.setDividerLocation(jSplitPane.getLastDividerLocation());
                        }
                    }
                } else if (jSplitPane.getDividerLocation() <= jSplitPane.getMaximumDividerLocation()) {
                    jSplitPane.setLastDividerLocation(jSplitPane.getDividerLocation());
                    jSplitPane.setDividerLocation(1.0);
                }
            }
        });
        this.filteredModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() <= Verifier.this.selectedRow && tableModelEvent.getLastRow() >= Verifier.this.selectedRow) {
                    Verifier.this.setOutput(Verifier.this.selectedRow);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
            }

            private void maybeDoPopup(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    return;
                }
                final int n = Verifier.this.filteredModel.translateViewLocationToModelRow(mouseEvent.getY() / Verifier.this.table.getRowHeight(), 0);
                if (n < 0 || n > Verifier.this.model.getRowCount()) {
                    return;
                }
                Object object = Verifier.this.model.getValueAt(n, VerifierColumn.VERIFY_STATUS.ordinal());
                if (!(object instanceof VerifierState)) {
                    return;
                }
                VerifierState verifierState = (VerifierState)((Object)VerifierState.class.cast(object));
                if (!verifierState.canBeVerified()) {
                    // empty if block
                }
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Reverify");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Verifier.this.model.reverify(n);
                    }
                });
                jPopupMenu.show(Verifier.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        jPanel2.add((Component)jSplitPane, "Center");
        super.setDisplay((JComponent)jPanel2);
        this.setColumnWidth(VerifierColumn.TASK_STATUS, "", true, true);
        this.setColumnWidth(VerifierColumn.ID, "0000000", false, true);
        this.setColumnWidth(VerifierColumn.OP, "000", true, true);
        this.hider.hide((Enum)VerifierColumn.GUID);
        this.hider.hide((Enum)VerifierColumn.COMMAND);
        this.hider.hide((Enum)VerifierColumn.OP);
        this.hider.hide((Enum)VerifierColumn.OUTPUT);
        return 0;
    }

    public void setOutput(int n) {
        String string;
        String string2 = (String)this.model.getValueAt(n, VerifierColumn.OUTPUT);
        if (string2.equals(string = this.verifierOutput.getText())) {
            return;
        }
        this.verifierOutput.setText(string2);
        this.verifierOutput.setCaretPosition(0);
    }

    public void fini2() {
        this.model.clear();
    }

    protected void commandInfo(CommandEvent commandEvent) {
        boolean bl;
        Task task = this.core.getTaskById(commandEvent.getId());
        this.model.addTask(task);
        String string = String.format("%d: %s", this.visibleGuids.getRowCount(), task.getId().getOperation());
        boolean bl2 = bl = this.visibleGuids.getRowCount() == 0;
        if (this.visibleGuids.addElement(string, (Object)task.getId().getOperation(), bl) && bl) {
            this.visibleGuidsPredicate.add((Object)task.getId().getOperation());
            this.filteredModel.filterChanged();
        }
    }

    protected void commandEnded(CommandEvent commandEvent) {
        Task task = this.core.getTaskById(commandEvent.getId());
        this.model.addTask(task);
    }

    public JPanel layoutFilterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        final JCheckBox jCheckBox = new JCheckBox("Successes");
        final JCheckBox jCheckBox2 = new JCheckBox("Failures");
        final JCheckBox jCheckBox3 = new JCheckBox("Commands without logs");
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1));
        jPanel4.add(this.suspendVerification);
        jPanel4.add(this.reverify);
        jPanel.add((Component)jPanel4, "South");
        jPanel2.add(jCheckBox);
        jPanel2.add(jCheckBox2);
        jPanel2.add(jCheckBox3);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Show:"));
        jCheckBox.setSelected(true);
        jCheckBox2.setSelected(true);
        jCheckBox3.setSelected(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Verifier.this.success.setShow(jCheckBox.isSelected());
                Verifier.this.filteredModel.filterChanged();
            }
        });
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Verifier.this.failure.setShow(jCheckBox2.isSelected());
                Verifier.this.filteredModel.filterChanged();
            }
        });
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Verifier.this.noLog.setShow(jCheckBox3.isSelected());
                Verifier.this.filteredModel.filterChanged();
            }
        });
        this.reverify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorker<Object, Void> swingWorker = new SwingWorker<Object, Void>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        for (int i = 0; i < Verifier.this.model.getRowCount(); ++i) {
                            Object object = Verifier.this.model.getValueAt(i, VerifierColumn.VERIFY_STATUS.ordinal());
                            if (!(object instanceof VerifierState)) continue;
                            VerifierState verifierState = (VerifierState)((Object)VerifierState.class.cast(object));
                            Verifier.this.model.reverify(i);
                        }
                        return null;
                    }
                };
                swingWorker.execute();
            }
        });
        jPanel3.add((Component)this.visibleGuids);
        jPanel.setPreferredSize(new Dimension(375, 0));
        return jPanel;
    }

    private void setColumnWidth(Enum<?> enum_, String string, boolean bl, boolean bl2) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(enum_.ordinal());
        JLabel jLabel = new JLabel(string);
        if (bl) {
            jLabel.setIcon(ImageManager.getIcon((String)super.getLogo(), (Dimension)this.core.getLabelImageSize()));
        }
        tableColumn.setPreferredWidth(jLabel.getPreferredSize().width + 10);
        if (bl2) {
            tableColumn.setMaxWidth(jLabel.getPreferredSize().width + 15);
            tableColumn.setMinWidth(jLabel.getPreferredSize().width + 5);
        }
    }

    boolean isSuspended() {
        return this.suspendVerification.isSelected();
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz;
        Class<?> clazz2 = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz3 = clazz = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz3.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

