/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.verifier;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.plugin.verifier.VerificationDelegate;
import ddb.dsz.plugin.verifier.Verifier;
import ddb.dsz.plugin.verifier.VerifierColumn;
import ddb.dsz.plugin.verifier.VerifierState;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.GeneralUtilities;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierModel
extends AbstractEnumeratedTableModel<VerifierColumn>
implements TableModel {
    final ScheduledExecutorService exec;
    List<TaskEntry> entries;
    CoreController core;
    List<Operation> guids;
    boolean stopped = false;
    int maximumLength = 10000000;
    Set<Task> handledTasks = new HashSet<Task>();
    Verifier verifier;

    public void setMaximumLength(int n) {
        if (n >= 0) {
            this.maximumLength = n;
        }
    }

    public VerifierModel(Verifier verifier, Collection<Task> collection, CoreController coreController) {
        super(VerifierColumn.class);
        this.exec = Executors.newScheduledThreadPool(10, GeneralUtilities.createThreadFactory((String)this.getClass().getSimpleName()));
        this.verifier = verifier;
        this.entries = new Vector<TaskEntry>();
        this.core = coreController;
        this.guids = new Vector<Operation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) {
        if (this.stopped) {
            return;
        }
        if (!this.handledTasks.add(task)) {
            return;
        }
        int n = -1;
        VerifierModel verifierModel = this;
        synchronized (verifierModel) {
            if (this.stopped) {
                return;
            }
            n = this.entries.size();
            TaskEntry taskEntry = new TaskEntry(task, n);
            this.entries.add(n, taskEntry);
        }
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsInserted((AbstractEnumeratedTableModel)this, n, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverify(int n) {
        if (this.stopped) {
            return;
        }
        VerifierModel verifierModel = this;
        synchronized (verifierModel) {
            TaskEntry taskEntry = this.entries.get(n);
            taskEntry.reverify();
        }
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)this, n, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        VerifierModel verifierModel = this;
        synchronized (verifierModel) {
            for (TaskEntry taskEntry : this.entries) {
                taskEntry.stop();
            }
            this.entries.clear();
            this.stopped = true;
        }
        this.exec.shutdownNow();
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
    }

    public Class<?> getColumnClass(VerifierColumn verifierColumn) {
        return verifierColumn.getClazz();
    }

    public String getColumnName(VerifierColumn verifierColumn) {
        return verifierColumn.getName();
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, VerifierColumn verifierColumn) {
        if (n < 0 || n >= this.entries.size()) {
            return null;
        }
        TaskEntry taskEntry = this.entries.get(n);
        VerifierModel verifierModel = this;
        synchronized (verifierModel) {
            switch (verifierColumn) {
                case ID: {
                    return taskEntry.task.getId().getId();
                }
                case COMMAND: {
                    return taskEntry.task.getCommandName();
                }
                case FULLCOMMAND: {
                    return taskEntry.task.getTypedCommand();
                }
                case TASK_STATUS: {
                    return taskEntry.task.getState();
                }
                case VERIFY_STATUS: {
                    return taskEntry.getState();
                }
                case GUID: {
                    return taskEntry.task.getId().getOperation();
                }
                case OP: {
                    return taskEntry.task.getId().getOperation();
                }
                case OUTPUT: {
                    return taskEntry.getOutput();
                }
            }
        }
        return null;
    }

    class TaskFileEntry
    implements Runnable {
        TaskDataAccess data;
        VerifierState state;
        String output;
        TaskEntry parent;

        public TaskFileEntry(TaskDataAccess taskDataAccess, TaskEntry taskEntry) {
            this.data = taskDataAccess;
            this.parent = taskEntry;
            this.state = VerifierState.NotVerified;
            this.output = "";
        }

        public void run() {
            if (!this.parent.hasEntry(this)) {
                return;
            }
            if (VerifierModel.this.verifier.isSuspended()) {
                try {
                    VerifierModel.this.exec.schedule(this, 1L, TimeUnit.MINUTES);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            this.state = VerifierState.Verifying;
            this.output = "";
            VerificationDelegate verificationDelegate = new VerificationDelegate(this.parent.task, this.data, VerifierModel.this.core);
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)VerifierModel.this, this.parent.index, this.parent.index));
            verificationDelegate.verify();
            if (verificationDelegate.isValid()) {
                this.state = VerifierState.VerifySuccess;
            } else {
                this.state = VerifierState.VerifyFailure;
                this.output = verificationDelegate.getDetails();
            }
            this.parent.setState(this.state, this);
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)VerifierModel.this, this.parent.index, this.parent.index));
        }
    }

    class TaskEntry
    implements Observer {
        Task task;
        Set<TaskFileEntry> files;
        int index;
        VerifierState defaultState;

        public TaskEntry(Task task, int n) {
            this.task = task;
            this.files = new HashSet<TaskFileEntry>();
            this.index = n;
            this.defaultState = VerifierState.NotVerified;
            task.subscribe((Observer)this, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable observable, Object object) {
            EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)VerifierModel.this, this.index, this.index));
            if (!(object instanceof TaskDataAccess)) {
                return;
            }
            TaskDataAccess taskDataAccess = (TaskDataAccess)object;
            if (taskDataAccess.getType() == TaskDataAccess.DataType.LOG) {
                return;
            }
            TaskFileEntry taskFileEntry = null;
            if (taskDataAccess.getType() == TaskDataAccess.DataType.DATA) {
                taskFileEntry = new TaskFileEntry(taskDataAccess, this);
            } else if (!(taskDataAccess.getType() != TaskDataAccess.DataType.STATE && taskDataAccess.getType() != TaskDataAccess.DataType.TASKING || this.task.isAlive())) {
                taskFileEntry = new TaskFileEntry(this.task.getTaskingAccess(), this);
            }
            if (taskFileEntry != null) {
                TaskEntry taskEntry = this;
                synchronized (taskEntry) {
                    this.files.add(taskFileEntry);
                }
                VerifierModel.this.exec.schedule(taskFileEntry, 10L, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reverify() {
            if (this.task == null) {
                return;
            }
            this.task.unsubscribe((Observer)this);
            TaskEntry taskEntry = this;
            synchronized (taskEntry) {
                this.files.clear();
                this.defaultState = VerifierState.NotVerified;
            }
            this.task.subscribe((Observer)this, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(VerifierState verifierState, TaskFileEntry taskFileEntry) {
            if (this.task == null) {
                return;
            }
            if (VerifierState.VerifySuccess == verifierState) {
                TaskEntry taskEntry = this;
                synchronized (taskEntry) {
                    this.defaultState = VerifierState.VerifySuccess;
                    this.files.remove(taskFileEntry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerifierState getState() {
            if (this.task == null) {
                return VerifierState.NoLog;
            }
            TaskEntry taskEntry = this;
            synchronized (taskEntry) {
                if (this.files.size() == 0) {
                    if (this.task.isAlive()) {
                        return VerifierState.NotVerified;
                    }
                    if (this.task.hasTaskingInformation()) {
                        return this.defaultState;
                    }
                    return VerifierState.NoLog;
                }
                VerifierState verifierState = VerifierState.VerifySuccess;
                for (TaskFileEntry taskFileEntry : this.files) {
                    switch (taskFileEntry.state) {
                        case NoLog: {
                            return VerifierState.NoLog;
                        }
                        case NotVerified: {
                            if (verifierState != VerifierState.VerifySuccess) break;
                            verifierState = VerifierState.NotVerified;
                            break;
                        }
                        case Verifying: {
                            verifierState = VerifierState.Verifying;
                            break;
                        }
                        case VerifyFailure: {
                            return VerifierState.VerifyFailure;
                        }
                    }
                }
                return verifierState;
            }
        }

        public synchronized void stop() {
            this.task.unsubscribe((Observer)this);
            this.files.clear();
            this.task = null;
        }

        public synchronized boolean hasEntry(TaskFileEntry taskFileEntry) {
            return this.files.contains(taskFileEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOutput() {
            if (this.task == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            TaskEntry taskEntry = this;
            synchronized (taskEntry) {
                for (TaskFileEntry taskFileEntry : this.files) {
                    if (taskFileEntry.output == null || taskFileEntry.output.length() == 0) continue;
                    stringBuilder.append(String.format("%s\n", taskFileEntry.output));
                }
            }
            return stringBuilder.toString();
        }
    }
}

