/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.verifier;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.plugin.verifier.VerificationDelegate;
import ddb.dsz.plugin.verifier.Verifier;
import ddb.dsz.plugin.verifier.VerifierColumn;
import ddb.dsz.plugin.verifier.VerifierState;
import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.GeneralUtilities;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierModel2
extends AbstractEnumeratedTableModel<VerifierColumn>
implements TableModel {
    private static final Comparator<TaskEntry> TaskCompare = new Comparator<TaskEntry>(){

        @Override
        public int compare(TaskEntry taskEntry, TaskEntry taskEntry2) {
            if (taskEntry == taskEntry2) {
                return 0;
            }
            if (taskEntry != null && taskEntry2 == null) {
                return -1;
            }
            if (taskEntry == null) {
                return 1;
            }
            return taskEntry.task.getId().compareTo(taskEntry2.task.getId());
        }
    };
    final ScheduledExecutorService exec;
    final List<TaskEntry> entries;
    final CoreController core;
    boolean stopped = false;
    int maximumLength = 10000000;
    Verifier verifier;
    private final Set<Integer> PENDING_CHANGES = new TreeSet<Integer>();
    private boolean bScheduled = false;
    private boolean bRunAgain = false;
    private final Runnable ANNOUNCE_CHANGES = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Collection collection = null;
                Set set = VerifierModel2.this.PENDING_CHANGES;
                synchronized (set) {
                    block29: {
                        if (VerifierModel2.this.PENDING_CHANGES.size() != 0) break block29;
                        return;
                    }
                    collection = new Vector(VerifierModel2.this.PENDING_CHANGES);
                    VerifierModel2.this.PENDING_CHANGES.clear();
                    VerifierModel2.this.bRunAgain = false;
                }
                if (collection.size() == 0) {
                    return;
                }
                int n = -1;
                int n2 = -1;
                for (Integer n3 : collection) {
                    if (n3 == null) continue;
                    if (n == -1) {
                        n = n3;
                    }
                    if (n2 == -1) {
                        n2 = n3;
                        continue;
                    }
                    if (n2 + 1 != n3) {
                        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)VerifierModel2.this, n, n2));
                        n = n2 = n3.intValue();
                        continue;
                    }
                    n2 = n3;
                }
                if (n != -1 && n2 != -1) {
                    EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableRowsUpdated((AbstractEnumeratedTableModel)VerifierModel2.this, n, n2));
                }
            }
            finally {
                Set set = VerifierModel2.this.PENDING_CHANGES;
                synchronized (set) {
                    if (VerifierModel2.this.bRunAgain) {
                        VerifierModel2.this.core.schedule(VerifierModel2.this.ANNOUNCE_CHANGES, 100L, TimeUnit.MILLISECONDS);
                    } else {
                        VerifierModel2.this.bScheduled = false;
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void QueueChanges(int n) {
        Set<Integer> set = this.PENDING_CHANGES;
        synchronized (set) {
            this.PENDING_CHANGES.add(n);
            if (!this.bScheduled) {
                this.bScheduled = true;
                this.core.schedule(this.ANNOUNCE_CHANGES, 100L, TimeUnit.MILLISECONDS);
            } else {
                this.bRunAgain = true;
            }
        }
    }

    public void setMaximumLength(int n) {
        if (n >= 0) {
            this.maximumLength = n;
        }
    }

    public VerifierModel2(Verifier verifier, Collection<Task> collection, CoreController coreController) {
        super(VerifierColumn.class);
        this.exec = Executors.newScheduledThreadPool(10, GeneralUtilities.createThreadFactory((String)this.getClass().getSimpleName()));
        this.verifier = verifier;
        this.entries = new Vector<TaskEntry>();
        this.core = coreController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task) {
        int n;
        if (this.stopped) {
            return;
        }
        TaskEntry taskEntry = new TaskEntry(task, false);
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            n = Collections.binarySearch(this.entries, taskEntry, TaskCompare);
            if (n >= 0) {
                return;
            }
            taskEntry = new TaskEntry(task, true);
            ++n;
            n = 0 - n;
            this.entries.add(n, taskEntry);
        }
        this.QueueChanges(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverify(int n) {
        if (this.stopped) {
            return;
        }
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            if (n < 0 || n >= this.entries.size()) {
                return;
            }
            TaskEntry taskEntry = this.entries.get(n);
            if (taskEntry == null) {
                return;
            }
            taskEntry.delete();
            TaskEntry taskEntry2 = new TaskEntry(taskEntry.task, true);
            this.entries.set(n, taskEntry2);
        }
        this.QueueChanges(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TaskUpdated(Task task) {
        int n;
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            TaskEntry taskEntry = new TaskEntry(task, false);
            n = Collections.binarySearch(this.entries, taskEntry, TaskCompare);
            if (n < 0 || n >= this.entries.size()) {
                return;
            }
        }
        this.QueueChanges(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            for (TaskEntry taskEntry : this.entries) {
                taskEntry.task.unsubscribe((Observer)taskEntry);
            }
            this.entries.clear();
            this.stopped = true;
        }
        this.exec.shutdownNow();
        EventQueue.invokeLater((Runnable)new AbstractEnumeratedTableModel.FireTableDataChanged((AbstractEnumeratedTableModel)this));
    }

    public Class<?> getColumnClass(VerifierColumn verifierColumn) {
        return verifierColumn.getClazz();
    }

    public String getColumnName(VerifierColumn verifierColumn) {
        return verifierColumn.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, VerifierColumn verifierColumn) {
        if (n < 0 || n >= this.entries.size()) {
            return null;
        }
        TaskEntry taskEntry = null;
        List<TaskEntry> list = this.entries;
        synchronized (list) {
            taskEntry = this.entries.get(n);
        }
        switch (verifierColumn) {
            case ID: {
                return taskEntry.task.getId().getId();
            }
            case COMMAND: {
                return taskEntry.task.getCommandName();
            }
            case FULLCOMMAND: {
                return taskEntry.task.getTypedCommand();
            }
            case TASK_STATUS: {
                return taskEntry.task.getState();
            }
            case VERIFY_STATUS: {
                return taskEntry.getState();
            }
            case GUID: {
                return taskEntry.task.getId().getOperation();
            }
            case OP: {
                return taskEntry.task.getId().getOperation();
            }
            case OUTPUT: {
                return taskEntry.getOutput();
            }
        }
        return null;
    }

    private class TaskFileCheck
    implements Runnable {
        final TaskEntry entry;
        final TaskDataAccess access;
        boolean firstTry = true;

        public TaskFileCheck(TaskEntry taskEntry, TaskDataAccess taskDataAccess) {
            this.entry = taskEntry;
            this.access = taskDataAccess;
        }

        public void run() {
            if (this.entry.bDeleted) {
                return;
            }
            if (VerifierModel2.this.verifier.isSuspended()) {
                try {
                    VerifierModel2.this.exec.schedule(this, 1L, TimeUnit.MINUTES);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            VerificationDelegate verificationDelegate = new VerificationDelegate(this.entry.task, this.access, VerifierModel2.this.core);
            verificationDelegate.verify();
            if (verificationDelegate.isValid()) {
                this.entry.addSuccessfullyVerified();
            } else {
                if (this.firstTry && verificationDelegate.shouldRepeat()) {
                    this.firstTry = false;
                    VerifierModel2.this.exec.schedule(this, 10L, TimeUnit.SECONDS);
                    return;
                }
                this.entry.addFailure(verificationDelegate.getDetails());
            }
            if (!this.entry.bDeleted) {
                VerifierModel2.this.TaskUpdated(this.entry.task);
            }
        }
    }

    private class TaskEntry
    implements Observer {
        final Task task;
        private boolean bFailure = false;
        private int fileCount = 0;
        private int fileVerified = 0;
        private List<String> outputs = new ArrayList<String>();
        private boolean bDeleted = false;
        private boolean bTasking = false;

        public TaskEntry(Task task, boolean bl) {
            this.task = task;
            if (bl) {
                this.task.subscribe((Observer)this, true);
            } else {
                this.bDeleted = true;
            }
        }

        public void delete() {
            this.bDeleted = true;
        }

        public boolean isDeleted() {
            return this.bDeleted;
        }

        public void update(Observable observable, Object object) {
            if (object == null || !(object instanceof TaskDataAccess)) {
                return;
            }
            TaskDataAccess taskDataAccess = (TaskDataAccess)object;
            TaskFileCheck taskFileCheck = null;
            if (taskDataAccess.getType() == TaskDataAccess.DataType.DATA) {
                this.addFile();
                taskFileCheck = new TaskFileCheck(this, taskDataAccess);
            } else if (!(this.bTasking || taskDataAccess.getType() != TaskDataAccess.DataType.STATE && taskDataAccess.getType() != TaskDataAccess.DataType.TASKING || taskDataAccess.getTask().isAlive())) {
                this.bTasking = true;
                this.addFile();
                taskFileCheck = new TaskFileCheck(this, taskDataAccess.getTask().getTaskingAccess());
            }
            if (taskFileCheck != null) {
                VerifierModel2.this.exec.submit(taskFileCheck);
            }
        }

        public synchronized String getOutput() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.outputs) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        public synchronized VerifierState getState() {
            if (this.fileCount == 0 && this.task.isAlive()) {
                return VerifierState.NotVerified;
            }
            if (this.bFailure) {
                return VerifierState.VerifyFailure;
            }
            if (this.fileCount == this.fileVerified && !this.task.isAlive()) {
                return VerifierState.VerifySuccess;
            }
            return VerifierState.Verifying;
        }

        synchronized void addFile() {
            ++this.fileCount;
        }

        synchronized void addSuccessfullyVerified() {
            ++this.fileVerified;
        }

        synchronized void addFailure(String string) {
            this.bFailure = true;
            if (this.outputs.isEmpty()) {
                this.outputs.add(string);
            }
        }
    }
}

