/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.core.task;

import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.TaskDataAccess;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.core.task.TaskState;
import ddb.util.Guid;
import java.io.Reader;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Task {
    public static final Comparator<Task> TaskComparator = new Comparator<Task>(){

        @Override
        public int compare(Task task, Task task2) {
            if (task == task2) {
                return 0;
            }
            if (task == null || task.getId() == null) {
                return 1;
            }
            if (task2 == null) {
                return -1;
            }
            if (task.getId() == task2.getId()) {
                return 0;
            }
            return task.getId().compareTo(task2.getId());
        }
    };

    public Task getParentTask();

    public TaskId getParentId();

    public List<String> getArguments();

    public List<String> getPrefixes();

    public String getCommandName();

    public TaskId getId();

    public Guid getTaskId();

    public int getTempId();

    public String getDataName();

    public String getGuiFlagValue(String var1);

    public long getCreationTime();

    public TaskState getState();

    public String getStateString();

    public String getTypedCommand();

    public boolean getInternallyGenerated();

    public String getDisplayTransform();

    public String getStorageTransform();

    public String getTargetId();

    public String getResultString();

    public boolean isInPromptMode();

    public Calendar getCreated();

    public String getResourceDirectory();

    public HostInfo getHost();

    public HostInfo getProspectiveHost();

    public int getDataCount();

    public Reader getTaskingInformation();

    public boolean hasTaskingInformation();

    public Reader getDataInformation(int var1);

    public TaskDataAccess getDataAccess(int var1);

    public TaskDataAccess getTaskLogAccess();

    public TaskDataAccess getTaskingAccess();

    public Reader getTaskLog();

    public void subscribe(Observer var1, boolean var2);

    public void unsubscribe(Observer var1);

    public boolean isReadyForParsing();

    public String getFullCommandLine();

    public int getNextOrdinal();

    public boolean isAlive();
}

