/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.multitarget;

import ddb.detach.TabbableStatus;
import ddb.detach.Workbench;
import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.command.CommandEventDemultiplexor;
import ddb.dsz.core.command.CommandEventListener;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.multitarget.MultipleTargetWorkbench;
import ddb.dsz.plugin.multitarget.SingleTargetInterface;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;

public abstract class MultipleTargetPlugin
extends NoHostAbstractPlugin {
    protected boolean notifyOnNewHost = false;
    protected final CommandEventDemultiplexor demulti = CommandEventDemultiplexor.newInstance();
    protected final Collection<SingleTargetInterface> children = new HashSet<SingleTargetInterface>();
    protected final MultipleTargetWorkbench tabWorkbench = this.generateWorkbench();

    protected MultipleTargetPlugin() {
        this.tabWorkbench.addPropertyChangeListener("WORKBENCH_CONTENTS_CHANGED", this.contentsChanged);
        this.tabWorkbench.addPropertyChangeListener("WORKBENCH_CONTENTS_CHANGED_REQUEST_FOCUS", this.contentsChangedRequestFocus);
    }

    protected final int init2() {
        if (this.demulti == null) {
            return -1;
        }
        this.demulti.addCommandEventListenerDefault(new CommandEventListener(){
            final Predicate unique = PredicateUtils.uniquePredicate();

            @Override
            public void commandEventReceived(final CommandEvent commandEvent) {
                if (commandEvent.getTargetAddress() == null) {
                    return;
                }
                switch (commandEvent.getType()) {
                    case STARTED: 
                    case ENDED: 
                    case OUTPUT: 
                    case INFO: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                final HostInfo hostInfo = MultipleTargetPlugin.this.core.getHostById(commandEvent.getTargetAddress());
                if (hostInfo == null) {
                    return;
                }
                final LocalHostState localHostState = MultipleTargetPlugin.this.getLocalHostState();
                if (localHostState == LocalHostState.IGNORE && hostInfo.isLocal()) {
                    return;
                }
                if (!this.unique.evaluate((Object)hostInfo)) {
                    return;
                }
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            SingleTargetInterface singleTargetInterface = MultipleTargetPlugin.this.newHost(hostInfo);
                            if (singleTargetInterface == null) {
                                return;
                            }
                            MultipleTargetPlugin.this.children.add(singleTargetInterface);
                            MultipleTargetPlugin.this.demulti.addCommandEventListener(hostInfo.getId(), singleTargetInterface);
                            singleTargetInterface.commandEventReceived(commandEvent);
                            MultipleTargetPlugin.this.tabWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{singleTargetInterface});
                            if (localHostState == LocalHostState.HIDE && hostInfo.isLocal()) {
                                MultipleTargetPlugin.this.tabWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.HIDETAB, new Object[]{singleTargetInterface});
                            }
                            if (!hostInfo.isLocal() && MultipleTargetPlugin.this.notifyOnNewHost) {
                                MultipleTargetPlugin.this.fireContentsChanged();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            @Override
            public boolean handlesPromptsForTask(Task task, int n) {
                return false;
            }

            @Override
            public boolean caresAboutLocalEvents() {
                return false;
            }

            @Override
            public boolean caresAboutRepeatedEvents() {
                return false;
            }

            @Override
            public Comparator<CommandEvent> getComparator() {
                return null;
            }
        });
        return this.init3();
    }

    protected abstract int init3();

    public final void commandEventReceived(CommandEvent commandEvent) {
        this.demulti.commandEventReceived(commandEvent);
    }

    public void close() {
        this.demulti.stop();
        for (SingleTargetInterface singleTargetInterface : this.children) {
            singleTargetInterface.close();
            singleTargetInterface.fini();
            this.workbench.enqueAction((Enum)Workbench.WorkbenchAction.REMOVETAB, new Object[]{singleTargetInterface});
        }
        super.close();
    }

    protected final void fini2() {
        this.fini3();
    }

    protected final boolean parseArgument2(String string, String string2) {
        return this.parseArgument3(string, string2);
    }

    protected boolean parseArgument3(String string, String string2) {
        return false;
    }

    protected void fini3() {
    }

    protected final SingleTargetInterface newHostWrapper(HostInfo hostInfo) {
        SingleTargetInterface singleTargetInterface = this.newHost(hostInfo);
        return singleTargetInterface;
    }

    protected abstract SingleTargetInterface newHost(HostInfo var1);

    protected void destroy(SingleTargetInterface singleTargetInterface) {
    }

    protected MultipleTargetWorkbench generateWorkbench() {
        return new MultipleTargetWorkbench(this);
    }

    protected abstract LocalHostState getLocalHostState();

    public abstract String newItemName();

    public void newItem(HostInfo hostInfo) {
        SingleTargetInterface singleTargetInterface = this.newHost(hostInfo);
        this.children.add(singleTargetInterface);
        this.demulti.addCommandEventListener(hostInfo.getId(), singleTargetInterface);
        this.tabWorkbench.enqueAction((Enum)Workbench.WorkbenchAction.ADDNEWTAB, new Object[]{singleTargetInterface});
    }

    CoreController getCoreController() {
        return this.core;
    }

    public TabbableStatus getStatus() {
        return this.tabWorkbench.getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocalHostState {
        IGNORE,
        HIDE,
        SHOW;

    }
}

