/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.multitarget;

import ddb.detach.Workbench;
import ddb.detach.WorkbenchPopupMenu;
import ddb.dsz.Icons;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.plugin.multitarget.MultipleTargetPlugin;
import ddb.dsz.plugin.multitarget.MultipleTargetWorkbench;
import ddb.imagemanager.ImageManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MultipleTargetPopupMenu
extends WorkbenchPopupMenu {
    public MultipleTargetPopupMenu(MultipleTargetWorkbench multipleTargetWorkbench, MultipleTargetPlugin multipleTargetPlugin) {
        super((Workbench)multipleTargetWorkbench);
        this.init(multipleTargetPlugin, multipleTargetPlugin.getCoreController());
    }

    public MultipleTargetPopupMenu(MultipleTargetWorkbench multipleTargetWorkbench, MultipleTargetPlugin multipleTargetPlugin, CoreController coreController) {
        super((Workbench)multipleTargetWorkbench);
        this.init(multipleTargetPlugin, coreController);
    }

    private void init(final MultipleTargetPlugin multipleTargetPlugin, CoreController coreController) {
        List<HostInfo> list = coreController.getHosts();
        boolean bl = false;
        JMenu jMenu = new JMenu(multipleTargetPlugin.newItemName());
        for (final HostInfo hostInfo : list) {
            if (hostInfo.isLocal()) {
                // empty if block
            }
            bl = true;
            JMenuItem jMenuItem = new JMenuItem(hostInfo.getId());
            if (hostInfo.isLocal()) {
                jMenuItem.setIcon(ImageManager.getIcon((String)Icons.LOCAL_HOST.getIcon(), (Dimension)coreController.getLabelImageSize()));
            } else {
                jMenuItem.setIcon(ImageManager.getIcon((String)Icons.REMOTE_HOST.getIcon(), (Dimension)coreController.getLabelImageSize()));
            }
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    multipleTargetPlugin.newItem(hostInfo);
                }
            });
            jMenu.add(jMenuItem);
        }
        if (bl) {
            this.add(jMenu);
        }
    }
}

