/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.terminal;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.command.GuiCommand;
import ddb.dsz.core.command.IdCallback;
import ddb.dsz.core.connection.ConnectionChangeEvent;
import ddb.dsz.core.connection.events.DisconnectEvent;
import ddb.dsz.core.connection.events.NewHostEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.library.console.BuiltinHandler;
import ddb.dsz.library.console.Console;
import ddb.dsz.library.console.ConsoleOutputPane;
import ddb.dsz.library.console.ParsedCommandLine;
import ddb.dsz.library.console.builtins.BuiltinCommand;
import ddb.dsz.library.console.builtins.BuiltinHandlerAdapter;
import ddb.dsz.plugin.Plugin;
import ddb.dsz.plugin.terminal.TerminalCompletionAction;
import ddb.dsz.plugin.terminal.builtins.ListTargetHandler;
import ddb.dsz.plugin.terminal.builtins.NewTerm;
import ddb.dsz.plugin.terminal.builtins.NotifyHandler;
import ddb.dsz.plugin.terminal.builtins.QuitDanderspritz;
import ddb.dsz.plugin.terminal.builtins.ResetStatus;
import ddb.dsz.plugin.terminal.builtins.SetStatusBuiltin;
import ddb.dsz.plugin.terminal.builtins.SetTabTitle;
import ddb.dsz.plugin.terminal.builtins.SetWindowTitle;
import ddb.dsz.plugin.terminal.builtins.TargetHandler;
import ddb.imagemanager.ImageManager;
import ddb.util.FileManips;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=false)
@DszLogo(value="images/terminal.png")
@DszName(value="Terminal")
@DszDescription(value="A command console")
public class Terminal
extends Console
implements Plugin,
IdCallback,
FocusListener,
InternalCommandHandler {
    private static final Object HISTORYLOCK = new Object();
    private static final String HISTORYFILE = "Term.History";
    private static OutputStreamWriter fw = null;
    private static Pattern DETACH_LOCATION_SIZE = Pattern.compile("(\\d+)x(\\d+)@(\\d+),(\\d+)");
    private static Pattern DETACH_SIZE = Pattern.compile("(\\d+)x(\\d+)");
    private static Pattern DETACH_LOCATION = Pattern.compile("(\\d+),(\\d+)");
    Set<String> terminalSuffix = new HashSet<String>();
    private CompleteBehavior onComplete = CompleteBehavior.Continue;
    private boolean canRunCommands = false;
    private boolean stealFocus = false;
    private Queue<String> pendingCommands = new LinkedList<String>();
    private Runnable executePending = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (!Terminal.this.canRunCommands || Terminal.this.currentTasks.size() > 0) {
                    Terminal.this.core.schedule((Runnable)this, 100L, TimeUnit.MILLISECONDS);
                    return;
                }
                String string = (String)Terminal.this.pendingCommands.poll();
                if (string == null) {
                    return;
                }
                Terminal.this.setWaitingForSyncResponse(true);
                Terminal.this.setStatus(string);
                Terminal.this.setWorkingState(Console.ConsoleState.BUSY);
                try {
                    Terminal.this.core.startCommand(String.format("%s%s", Terminal.this.getPrefix(), string), (IdCallback)Terminal.this, (Object)Terminal.this, Terminal.this.target);
                }
                catch (DispatcherException dispatcherException) {
                    Terminal.this.setWaitingForSyncResponse(false);
                    Terminal.this.setCurrentSynchTask(null);
                    Terminal.this.setWorkingState(Console.ConsoleState.IDLE);
                    Terminal.this.core.logEvent(Level.INFO, dispatcherException.getMessage(), (Throwable)dispatcherException);
                    Terminal.this.appendOutputMessage("*\n* Command Failed To Start\n*\n\n", ConsoleOutputPane.OutputLevel.ERROR);
                }
            }
            if (Terminal.this.stealFocus) {
                Terminal.this.stealFocus = false;
                Terminal.this.core.StealFocus((Plugin)Terminal.this);
            }
        }
    };
    NewTerm newTerminalHandler = new NewTerm(this);
    private String specificStatus = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getHistoryItems(CoreController coreController) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(String.format("%s/%s", coreController.getLogDirectory(), HISTORYFILE));
        if (!file.exists() || !file.isFile()) {
            return arrayList;
        }
        Object object = HISTORYLOCK;
        synchronized (object) {
            try {
                LineNumberReader lineNumberReader = new LineNumberReader(FileManips.createFileReader((File)file));
                String string = "";
                while (string != null) {
                    if (string.length() > 0) {
                        arrayList.add(string);
                    }
                    string = lineNumberReader.readLine();
                }
                lineNumberReader.close();
            }
            catch (Exception exception) {
                coreController.logEvent(Level.INFO, "Could not load history", (Throwable)exception);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addItemToHistory(String string, CoreController coreController) {
        Object object = HISTORYLOCK;
        synchronized (object) {
            if (fw == null) {
                try {
                    fw = FileManips.createFileWriter((File)new File(coreController.getLogDirectory(), HISTORYFILE), (boolean)true);
                }
                catch (Exception exception) {
                    coreController.logEvent(Level.WARNING, "Unable to open history file", (Throwable)exception);
                    return;
                }
            }
            try {
                fw.write(String.format("%s\r\n", string));
                fw.flush();
            }
            catch (Exception exception) {
                coreController.logEvent(Level.WARNING, "Unable to save history item", (Throwable)exception);
            }
        }
    }

    protected int init3() {
        this.setGuiCommandPredicate(new Predicate(){

            public boolean evaluate(Object object) {
                if (!(object instanceof GuiCommand)) {
                    return false;
                }
                GuiCommand guiCommand = (GuiCommand)GuiCommand.class.cast(object);
                if (guiCommand.getId() != null) {
                    Task task = Terminal.this.core.getTaskById(guiCommand.getId());
                    if (task == null) {
                        return false;
                    }
                    if (!Terminal.this.currentTasks.contains(task)) {
                        return false;
                    }
                }
                for (String string : Terminal.this.builtinCommands.keySet()) {
                    if (!guiCommand.getGuiCommand().toLowerCase().startsWith(String.format(".%s", string))) continue;
                    return true;
                }
                return false;
            }
        });
        List<String> list = Terminal.getHistoryItems(this.core);
        for (String string : list) {
            this.addHistoryItem(string);
        }
        this.core.submit(this.executePending);
        if (this.getTarget() == null) {
            for (String string : this.core.getHosts()) {
                if (!string.isLocal() || !this.onComplete.equals((Object)CompleteBehavior.Continue)) continue;
                this.setHost((HostInfo)string);
                break;
            }
        }
        this.status.setStatusIcon((Icon)ImageManager.getIcon((String)super.getLogo(), (Dimension)this.core.getLabelImageSize()));
        this.status.notifyObservers();
        if (this.stealFocus) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Terminal.this.core.StealFocus((Plugin)Terminal.this);
                }
            });
        }
        this.canRunCommands = true;
        return 0;
    }

    protected boolean parseArgument3(String string, String string2) {
        if (string.equalsIgnoreCase("-cmd") && string2 != null) {
            this.pendingCommands.offer(string2);
            this.core.submit(this.executePending);
            return true;
        }
        if (string.equalsIgnoreCase(InternalCommandHandler.CLOSE_ON_COMPLETE)) {
            this.onComplete = CompleteBehavior.Exit;
            return true;
        }
        if (string.equalsIgnoreCase(InternalCommandHandler.DISABLE_ON_COMPLETE)) {
            this.onComplete = CompleteBehavior.Disable;
            return true;
        }
        if (string.equalsIgnoreCase(InternalCommandHandler.FOCUS_ON_START)) {
            this.stealFocus = true;
            return true;
        }
        if (string.equalsIgnoreCase("-special") && string2 != null) {
            this.terminalSuffix.add(string2);
            return true;
        }
        if (string.equalsIgnoreCase("-detach") && string2 != null) {
            Matcher matcher = DETACH_LOCATION_SIZE.matcher(string2);
            final Dimension dimension = new Dimension(450, 200);
            final Point point = new Point(0, 0);
            if (matcher.matches()) {
                try {
                    dimension.width = Integer.parseInt(matcher.group(1));
                    dimension.height = Integer.parseInt(matcher.group(2));
                    point.x = Integer.parseInt(matcher.group(3));
                    point.y = Integer.parseInt(matcher.group(4));
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            this.core.submit(new Runnable(){

                public void run() {
                    Terminal.this.core.detachPlugin((Plugin)Terminal.this, dimension, point);
                }
            });
            return true;
        }
        if (string.equalsIgnoreCase("-dst") && string2 != null) {
            this.setTarget(string2);
            return true;
        }
        if (string.equalsIgnoreCase("-name") && string2 != null) {
            this.setName(string2);
            return true;
        }
        return false;
    }

    public String getHistory() {
        return "Terminal/history.xml";
    }

    public Terminal() {
        super.setName("Terminal");
        super.setCareAboutLocalEvents(true);
        this.setupBuiltinCommands();
    }

    public boolean startCommand(final String string) {
        this.core.submit(new Runnable(){

            public void run() {
                if (CoreController.OperationState.Inactive.equals((Object)Terminal.this.core.getOperationState())) {
                    Terminal.this.appendOutputMessage("*\n* Cannot start command\n* Operation has concluded\n*\n\n", ConsoleOutputPane.OutputLevel.ERROR);
                    return;
                }
                Terminal.addItemToHistory(string, Terminal.this.core);
                Terminal.this.setWaitingForSyncResponse(true);
                Terminal.this.setStatus(string);
                Terminal.this.setWorkingState(Console.ConsoleState.BUSY);
                Terminal.this.outputPane.setPaused(false);
                try {
                    Terminal.this.core.startCommand(String.format("%s%s", Terminal.this.getPrefix(), string), (IdCallback)Terminal.this, (Object)Terminal.this, Terminal.this.target);
                }
                catch (DispatcherException dispatcherException) {
                    Terminal.this.setWaitingForSyncResponse(false);
                    Terminal.this.setCurrentSynchTask(null);
                    Terminal.this.setWorkingState(Console.ConsoleState.IDLE);
                    Terminal.this.core.logEvent(Level.INFO, dispatcherException.getMessage(), (Throwable)dispatcherException);
                    Terminal.this.appendOutputMessage("*\n* Command Failed To Start\n*\n\n", ConsoleOutputPane.OutputLevel.ERROR);
                }
            }
        });
        return true;
    }

    protected String getConsoleLogName() {
        return "Terminal-screen";
    }

    protected void setupCommandLineSpecificActionMaps() {
        super.setupCommandLineSpecificActionMaps();
        ActionMap actionMap = this.commandLine.getActionMap();
        actionMap.put("complete", (Action)((Object)new TerminalCompletionAction(this, this.commandSet)));
        actionMap.put("background command", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Terminal.this.onComplete.equals((Object)CompleteBehavior.Continue)) {
                    Terminal.this.backgroundCommand();
                }
            }
        });
        actionMap.put("foreground command", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Terminal.this.onComplete.equals((Object)CompleteBehavior.Continue)) {
                    Terminal.this.foregroundLast();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backgroundCommand() {
        if (!this.isWaitingForSyncResponse()) {
            return;
        }
        if (this.isInPromptMode()) {
            this.core.showPrompt((Task)this.currentTasks.peek(), this.pendingReqId, this.promptMessageLabel.getText());
            EventQueue.invokeLater(this.stopPromptMode);
        }
        try {
            Stack stack = this.currentTasks;
            synchronized (stack) {
                Object object;
                Task task = (Task)this.currentTasks.peek();
                if (task != null) {
                    object = new Vector();
                    object.add("background");
                    try {
                        this.core.addPrefixesToTask(task.getId(), (List)object);
                    }
                    catch (DispatcherException dispatcherException) {
                        this.core.logEvent(Level.SEVERE, "Unable to background a command", (Throwable)dispatcherException);
                    }
                }
                object = task.getCommandName();
                this.appendOutputMessage(String.format("\n[Background send to command %d: %s]\n", task.getId().getId(), object), ConsoleOutputPane.OutputLevel.BOLD);
            }
        }
        catch (EmptyStackException emptyStackException) {
            return;
        }
    }

    public JComponent getDefaultElement() {
        return this.commandLine;
    }

    public boolean runInternalCommand(List<String> list, TaskId taskId, InternalCommandCallback internalCommandCallback) {
        String[] stringArray;
        if (super.runInternalCommand(list, taskId, internalCommandCallback)) {
            return true;
        }
        if (list.size() == 0) {
            this.core.logEvent(Level.INFO, "Command not handled because it is empty");
            return false;
        }
        Task task = this.core.getTaskById(taskId);
        if (!this.currentTasks.contains(task)) {
            this.core.logEvent(Level.INFO, "Command not handled because it is not one of mine");
            return false;
        }
        if (list.get(0).equalsIgnoreCase(".newterm")) {
            this.newTerminal(list.subList(1, list.size()));
            return true;
        }
        if (list.get(0).toLowerCase().startsWith(".newterm") && (stringArray = list.get(0).split(" +", 2)).length == 2) {
            this.newTerminalHandler.executeBuiltinCommand(stringArray[0], stringArray[1]);
            return true;
        }
        for (String string : this.builtinCommands.keySet()) {
            try {
                if (!list.get(0).toLowerCase().startsWith(String.format(".%s", string.toLowerCase()))) continue;
                String string2 = list.get(0);
                String string3 = null;
                String[] stringArray2 = list.get(0).split(" +", 2);
                if (stringArray2.length == 2) {
                    string2 = stringArray2[0];
                    string3 = stringArray2[1];
                }
                this.core.logEvent(Level.INFO, "New Terminal Command:  " + list);
                ((BuiltinCommand)this.builtinCommands.get(string)).getHandler().executeBuiltinCommand(string2, string3);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.core.logEvent(Level.INFO, "Command not handled because it is not recognized");
        return false;
    }

    protected void handleGuiCommand(GuiCommand guiCommand) {
        super.commandGui(guiCommand);
        String string = guiCommand.getGuiCommand();
        for (String string2 : this.builtinCommands.keySet()) {
            try {
                if (!string.toLowerCase().startsWith(String.format(".%s", string2.toLowerCase()))) continue;
                String string3 = string;
                String string4 = null;
                String[] stringArray = string.split(" +", 2);
                if (stringArray.length == 2) {
                    string3 = stringArray[0];
                    string4 = stringArray[1];
                }
                this.core.logEvent(Level.INFO, "New Terminal Command:  " + guiCommand);
                this.core.sendGuiCommandResponse(guiCommand.getReqId(), ((BuiltinCommand)this.builtinCommands.get(string2)).getHandler().executeBuiltinCommand(string3, string4));
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.core.sendGuiCommandResponse(guiCommand.getReqId(), false);
        this.core.logEvent(Level.INFO, "Command not handled because it is not recognized");
    }

    public boolean runInternalCommand(List<String> list, InternalCommandCallback internalCommandCallback) {
        if (super.runInternalCommand(list, internalCommandCallback)) {
            return true;
        }
        try {
            for (String string : this.terminalSuffix) {
                if (!list.get(0).equalsIgnoreCase(String.format("terminal-%s", string))) continue;
                Vector<String> vector = new Vector<String>();
                for (String string2 : list.subList(1, list.size())) {
                    if (string2.startsWith("-")) {
                        vector.add(string2);
                        continue;
                    }
                    vector.add(String.format("-cmd=%s", string2));
                }
                vector.add(InternalCommandHandler.FOCUS_ON_START);
                return this.core.startNewPlugin(Class.forName("ddb.dsz.plugin.terminal.Terminal"), "Term", vector, false, true);
            }
        }
        catch (Throwable throwable) {
            this.core.logEvent(Level.SEVERE, "Unable to create new terminal", throwable);
        }
        if (this.currentTasks.size() > 0) {
            return false;
        }
        if (list.size() < 2) {
            return false;
        }
        if (!this.onComplete.equals((Object)CompleteBehavior.Continue)) {
            return false;
        }
        if (this.target != null && !this.target.isLocal()) {
            for (String string : list) {
                if (!string.equalsIgnoreCase(InternalCommandHandler.LOCAL_ONLY)) continue;
                return false;
            }
        }
        if (list.get(0).equalsIgnoreCase("terminal")) {
            this.execute(list.subList(1, list.size()));
            return true;
        }
        if (list.get(0).equalsIgnoreCase("terminal-focus")) {
            this.execute(list.subList(1, list.size()));
            this.core.StealFocus((Plugin)this);
            return true;
        }
        return false;
    }

    private void execute(List<String> list) {
        for (String string : list) {
            if (string.startsWith("/")) continue;
            this.pendingCommands.offer(string);
            this.core.submit(this.executePending);
        }
    }

    protected void evalutateWaitingForSyncTask() {
        super.evalutateWaitingForSyncTask();
        if (this.currentTasks.size() == 0) {
            this.setStatusTextClear();
            if (this.pendingCommands.size() == 0) {
                if (this.onComplete.equals((Object)CompleteBehavior.Disable)) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Terminal.this.commandLine.setEnabled(false);
                            Terminal.this.southPanel.setVisible(false);
                        }
                    });
                }
                if (this.onComplete.equals((Object)CompleteBehavior.Exit)) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Terminal.this.core.closePlugin((Plugin)Terminal.this);
                        }
                    });
                }
            }
            this.core.submit(this.executePending);
        }
    }

    protected void setStatusTextClear() {
        if (this.target == null || this.target.isConnected()) {
            this.setStatus("");
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            this.setStatus(String.format("<html>Disconnected from <b>%s</b> at <b>%s</b>", this.target.getId(), simpleDateFormat.format(this.target.getModifiedTime().getTime())));
        }
    }

    protected void setupBuiltinCommands() {
        super.setupBuiltinCommands();
        this.addBuiltinCommand("dst", new TargetHandler(this), "Usage: dst [CP ID]\n");
        this.addBuiltinCommand("listdestinations", new ListTargetHandler(this), "Usage: listdestinations\n");
        this.addBuiltinCommand("notify", new NotifyHandler(this), "Usage: notify [id]\n");
        this.addBuiltinCommand("newterm", this.newTerminalHandler, "Usage:  newterm [parameters]\n\t[-cmd=x]\n\t\tStart the window with the given command.  Use \"\" to delimit the command.\n\t[-focus]\n\t\tFocus on the window immediately\n\t[-close]\n\t\tClose the window when the command is complete\n\t[-disable]\n\t\tDisable the window so that no further commands can be run\n\t[-name=x]\n\t\tName the window\n\t[-dst=x]\n\t\tSpecify the default destination of the window\n\t[-detach[=WxH@X,Y]]\n\t\tSpecify a window of WxH pixel at location X,Y.\n\t\tSize and location are optional\n\t[-location=X,Y]\n\t\tSpecify that the window should be at X,Y\n\t[-size=WxH]\n\t\tSpecify that the window should be WxH pixels in size\n");
        this.addBuiltinCommand("setStatus", new SetStatusBuiltin(this), "Usage: setstatus <status>\n");
        this.addBuiltinCommand("resetStatus", new ResetStatus(this), "Usage: resetstatus\n");
        this.addBuiltinCommand("settabtitle", new SetTabTitle(this), "Usage: settabtitle <title>\n");
        this.addBuiltinCommand("setwindowtitle", new SetWindowTitle(this), "Usage: setwindowtitle <title>\n");
        this.addBuiltinCommand("quit", new QuitDanderspritz(this), "Usage:  quit\n");
    }

    private void addBuiltinCommand(String string, BuiltinHandlerAdapter builtinHandlerAdapter, String string2) {
        BuiltinCommand builtinCommand = new BuiltinCommand(string);
        builtinCommand.setHandler((BuiltinHandler)builtinHandlerAdapter);
        builtinCommand.setHelpStatement(string2);
        this.builtinCommands.put(builtinCommand.getName(), builtinCommand);
    }

    public boolean setTarget(String string) {
        HostInfo hostInfo;
        if (string == null) {
            string = "127.0.0.1";
        }
        if ((hostInfo = this.core.getHostById(string)) == null) {
            this.appendOutputMessage(String.format("Unable to find host with id '%s'.\n", string), ConsoleOutputPane.OutputLevel.WARNING);
            return false;
        }
        this.setHost(hostInfo);
        this.setStatusTextClear();
        return true;
    }

    public boolean notify(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.appendOutputMessage(String.format("Unable to command id '%s'.\n", string), ConsoleOutputPane.OutputLevel.WARNING);
            return false;
        }
        Task task = this.core.getRunningTaskById(TaskId.GenerateTaskId((int)n, (Operation)this.core.getOperation()));
        if (task == null) {
            this.appendOutputMessage(String.format("Unable to find running command id '%d'.\n", n), ConsoleOutputPane.OutputLevel.WARNING);
            return false;
        }
        String string2 = task.getCommandName();
        if (this.core.internalCommand(null, new String[]{"notify", string})) {
            this.appendOutputMessage(String.format("\n[Notification set on command %d]\n", n, string2), ConsoleOutputPane.OutputLevel.BOLD);
            return true;
        }
        this.appendOutputMessage(String.format("Unable to set notify on command id '%d'.\n", n), ConsoleOutputPane.OutputLevel.WARNING);
        return false;
    }

    public boolean resetStatus() {
        this.specificStatus = null;
        this.setStatus("");
        return false;
    }

    public boolean lockStatus(String string) {
        this.specificStatus = string;
        this.setStatus(string);
        return false;
    }

    protected void setStatus(String string) {
        String string2 = this.specificStatus;
        if (string2 != null) {
            string = string2;
        }
        super.setStatus(string);
    }

    public boolean newTerminal(List<String> list) {
        String string = "Term";
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Dimension dimension = new Dimension(640, 480);
        Point point = new Point(0, 0);
        HostInfo hostInfo = this.target;
        String string2 = null;
        for (String string3 : list) {
            Matcher matcher;
            String[] stringArray = string3.split("=", 2);
            String string4 = null;
            String string5 = null;
            if (stringArray.length > 0) {
                string4 = stringArray[0];
            }
            if (stringArray.length > 1) {
                string5 = stringArray[1];
            }
            if (string4 == null) continue;
            if (string4.equalsIgnoreCase("-cmd") && string5 != null) {
                vector2.add(string5);
                continue;
            }
            if (string4.equalsIgnoreCase("-focus")) {
                bl2 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("-close")) {
                bl4 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("-disable")) {
                bl5 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("-name") && string5 != null) {
                bl = true;
                string = string5;
                continue;
            }
            if (string4.equalsIgnoreCase("-dst") && string5 != null) {
                hostInfo = this.core.getHostById(string5);
                continue;
            }
            if (string4.equalsIgnoreCase("-detach")) {
                bl3 = true;
                if (string5 == null || !(matcher = DETACH_LOCATION_SIZE.matcher(string5)).matches()) continue;
                try {
                    dimension.width = Integer.parseInt(matcher.group(1));
                    dimension.height = Integer.parseInt(matcher.group(2));
                    point.x = Integer.parseInt(matcher.group(3));
                    point.y = Integer.parseInt(matcher.group(4));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string4.equalsIgnoreCase("-location") && string5 != null) {
                bl3 = true;
                matcher = DETACH_LOCATION.matcher(string5);
                if (!matcher.matches()) continue;
                try {
                    point.x = Integer.parseInt(matcher.group(1));
                    point.y = Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string4.equalsIgnoreCase("-size") && string5 != null) {
                bl3 = true;
                matcher = DETACH_SIZE.matcher(string5);
                if (!matcher.matches()) continue;
                try {
                    dimension.width = Integer.parseInt(matcher.group(1));
                    dimension.height = Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string4.equalsIgnoreCase("-theme") && string5 != null) {
                string2 = string5;
                continue;
            }
            this.appendOutputMessage(String.format("Argument not recognized:  %s\n", string3), ConsoleOutputPane.OutputLevel.ERROR);
            return false;
        }
        vector.add(String.format("-dst=%s", hostInfo.getId()));
        if (bl) {
            vector.add(String.format("-name=%s", string));
        }
        if (bl3) {
            vector.add(String.format("-detach=%dx%d@%d,%d", dimension.width, dimension.height, point.x, point.y));
        }
        if (bl2) {
            vector.add(InternalCommandHandler.FOCUS_ON_START);
        }
        if (bl4) {
            vector.add(InternalCommandHandler.CLOSE_ON_COMPLETE);
        }
        if (bl5) {
            vector.add(InternalCommandHandler.DISABLE_ON_COMPLETE);
        }
        if (string2 != null) {
            vector.add(String.format("-theme=%s", string2));
        }
        for (String string3 : this.terminalSuffix) {
            vector.add(String.format("-special=%s", string3));
        }
        for (String string3 : vector2) {
            vector.add(String.format("-cmd=%s", string3));
        }
        return this.core.startNewPlugin(Terminal.class, string, vector, false, true);
    }

    public void quitDanderspritz() {
        this.core.requestShutdown();
    }

    public void listTargets() {
        List list = this.core.getHosts();
        if (list.size() == 0) {
            this.appendOutputMessage("No hosts known.\r\n", ConsoleOutputPane.OutputLevel.WARNING);
        }
        this.appendOutputMessage("    Host ID         Arch        OS      Version    Implant\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        this.appendOutputMessage("---------------  ---------- ---------- ---------- ----------\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        for (HostInfo hostInfo : list) {
            if (!hostInfo.isConnected()) continue;
            this.appendOutputMessage(String.format("%15s  %10s %10s %10s %10s\n", hostInfo.getId(), hostInfo.getArch(), hostInfo.getPlatform(), hostInfo.getVersion(), hostInfo.getImplantType()), ConsoleOutputPane.OutputLevel.DEFAULT);
        }
        this.appendOutputMessage("---------------  ---------- ---------- ---------- ----------\n", ConsoleOutputPane.OutputLevel.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(ConnectionChangeEvent connectionChangeEvent) {
        super.connectionChanged(connectionChangeEvent);
        if (connectionChangeEvent instanceof NewHostEvent) {
            this.canRunCommands = true;
            if (!this.onComplete.equals((Object)CompleteBehavior.Continue)) {
                return;
            }
            NewHostEvent newHostEvent = (NewHostEvent)NewHostEvent.class.cast(connectionChangeEvent);
            if (this.target == null) {
                this.setHost(newHostEvent.getHost());
                return;
            }
            TaskId taskId = newHostEvent.getHost().getTask();
            Stack stack = this.currentTasks;
            synchronized (stack) {
                if (this.currentTasks.empty()) {
                    this.setStatusTextClear();
                    return;
                }
                for (Task task : this.currentTasks) {
                    if (!task.getId().equals((Object)taskId)) continue;
                    this.setHost(newHostEvent.getHost());
                    return;
                }
            }
        } else if (connectionChangeEvent instanceof DisconnectEvent) {
            DisconnectEvent disconnectEvent = (DisconnectEvent)connectionChangeEvent;
            if (this.target == null) {
                return;
            }
            if (!this.target.sameHost(disconnectEvent.getHost())) {
                return;
            }
            this.setStatusTextClear();
        }
    }

    public void requestHelpStatement(ParsedCommandLine parsedCommandLine, String string) {
        HostInfo hostInfo = this.target;
        if (string != null) {
            hostInfo = this.core.getHostById(string);
        }
        super.requestHelpStatement(parsedCommandLine, hostInfo);
    }

    protected void setHost(HostInfo hostInfo) {
        super.setHost(hostInfo);
        this.setStatusTextClear();
        if (hostInfo == null || hostInfo.getHostname() == null || this.workbench != null) {
            // empty if block
        }
        if (hostInfo != null && hostInfo.getHostname() != null) {
            super.setName(hostInfo.getHostname());
        }
    }

    public void setName(String string) {
        super.setName(string);
    }

    public boolean setWindowTitle(String string) {
        this.core.setTitle(string);
        return true;
    }

    public String getTargetForPrefix(String string) {
        List list = this.core.getHosts();
        string = string.toLowerCase();
        int n = 0;
        while (n < list.size()) {
            if (!((HostInfo)list.get(n)).isConnected() || !((HostInfo)list.get(n)).getId().toLowerCase().startsWith(string)) {
                list.remove(n);
                continue;
            }
            ++n;
        }
        if (list.size() == 1) {
            return ((HostInfo)list.get(0)).getId();
        }
        if (list.size() == 0) {
            this.appendOutputMessage("No hosts matched.\r\n", ConsoleOutputPane.OutputLevel.WARNING);
            this.appendOutputMessage("List of all hosts:\r\n", ConsoleOutputPane.OutputLevel.DEFAULT);
            list = this.core.getHosts();
        } else {
            this.appendOutputMessage("Possible hosts:\r\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        }
        this.appendOutputMessage("    Host ID         Arch        OS      Version    Implant\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        this.appendOutputMessage("---------------  ---------- ---------- ---------- ----------\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        for (HostInfo hostInfo : list) {
            if (!hostInfo.isConnected()) continue;
            this.appendOutputMessage(String.format("%15s", hostInfo.getId()), ConsoleOutputPane.OutputLevel.NOTICE);
            this.appendOutputMessage(String.format("  %10s %10s %10s %10s\n", hostInfo.getArch(), hostInfo.getPlatform(), hostInfo.getVersion(), hostInfo.getImplantType()), ConsoleOutputPane.OutputLevel.DEFAULT);
        }
        this.appendOutputMessage("---------------  ---------- ---------- ---------- ----------\n", ConsoleOutputPane.OutputLevel.DEFAULT);
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompleteBehavior {
        Continue,
        Disable,
        Exit;

    }
}

