/*
 * Decompiled with CFR 0.152.
 */
package ddb.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UtilityConstants {
    private static final Map<String, ThreadFactory> NameMap = new HashMap<String, ThreadFactory>();

    public static Lock createLock() {
        return UtilityConstants.createLock(false);
    }

    public static Lock createLock(boolean bl) {
        if (bl) {
            return new ReentrantLock(true);
        }
        return new ReentrantLock();
    }

    public static ReadWriteLock createReadWriteLock() {
        return UtilityConstants.createReadWriteLock(false);
    }

    public static ReadWriteLock createReadWriteLock(boolean bl) {
        if (bl) {
            return new ReentrantReadWriteLock(true);
        }
        return new ReentrantReadWriteLock();
    }

    public static ThreadFactory createThreadFactory() {
        return UtilityConstants.createThreadFactory("UtilityConstants");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadFactory createThreadFactory(final String string) {
        Map<String, ThreadFactory> map = NameMap;
        synchronized (map) {
            ThreadFactory threadFactory = NameMap.get(string);
            if (threadFactory == null) {
                threadFactory = new ThreadFactory(){
                    int count = 0;

                    public Thread newThread(Runnable runnable) {
                        Thread thread = new Thread(runnable, String.format("%s %d", string, ++this.count));
                        thread.setPriority(1);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                NameMap.put(string, threadFactory);
            }
            return threadFactory;
        }
    }

    public static ExecutorService createExecutorService() {
        return UtilityConstants.createExecutorService("UtilityConstants");
    }

    public static ExecutorService createExecutorService(String string) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 50, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), UtilityConstants.createThreadFactory(string));
        return threadPoolExecutor;
    }

    public static ScheduledExecutorService createScheduledExecutorService() {
        return UtilityConstants.createScheduledExecutorService("UtilityConstants");
    }

    public static ScheduledExecutorService createScheduledExecutorService(String string) {
        return UtilityConstants.createScheduledExecutorService(1, string);
    }

    public static ScheduledExecutorService createScheduledExecutorService(ThreadFactory threadFactory) {
        return UtilityConstants.createScheduledExecutorService(1, threadFactory);
    }

    public static ScheduledExecutorService createScheduledExecutorService(int n, ThreadFactory threadFactory) {
        return Executors.newScheduledThreadPool(n, threadFactory);
    }

    public static ScheduledExecutorService createScheduledExecutorService(int n, String string) {
        return Executors.newScheduledThreadPool(n, UtilityConstants.createThreadFactory(string));
    }

    public static ExecutorService createSingleThreadExecutorService() {
        return UtilityConstants.createSingleThreadExecutorService("UtilityConstants");
    }

    public static ExecutorService createSingleThreadExecutorService(String string) {
        return Executors.newSingleThreadExecutor(UtilityConstants.createThreadFactory(string));
    }

    public static <O> O ShallowCopy(O o, O o2, Class<?> clazz) {
        if (o == null || o2 == null || clazz == null) {
            return o;
        }
        for (Field field : clazz.getDeclaredFields()) {
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(o, field.get(o2));
            }
            catch (Exception exception) {
                Logger.getLogger("dsz.core").log(Level.SEVERE, null, exception);
            }
            field.setAccessible(bl);
        }
        return o;
    }

    public static <E> JAXBElement<E> createRootElement(String string, E e) {
        if (string == null || e == null) {
            return null;
        }
        return new JAXBElement(new QName(string), e.getClass(), e);
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz;
        Class<?> clazz2 = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz3 = clazz = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz3.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

