/*
 * Decompiled with CFR 0.152.
 */
package ddb.util.checkedtablemodel;

import ddb.util.AbstractEnumeratedTableModel;
import ddb.util.checkedtablemodel.CheckedTableColumns;
import ddb.util.checkedtablemodel.CheckedTableSelection;
import ddb.util.checkedtablemodel.DataEntry;
import java.awt.Font;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedTableModel<T>
extends AbstractEnumeratedTableModel<CheckedTableColumns> {
    List<DataEntry<T>> data = new Vector<DataEntry<T>>();
    final Comparator<T> comp;
    CheckedTableSelection<T> selection = null;
    Font defaultFont = null;
    private final Comparator<DataEntry<T>> DataObjectComp = new Comparator<DataEntry<T>>(){

        @Override
        public int compare(DataEntry<T> dataEntry, DataEntry<T> dataEntry2) {
            if (dataEntry == dataEntry2) {
                return 0;
            }
            if (dataEntry == null) {
                return 1;
            }
            if (dataEntry2 == null) {
                return -1;
            }
            return CheckedTableModel.this.comp.compare(dataEntry.getTag(), dataEntry2.getTag());
        }
    };

    public CheckedTableModel(CheckedTableSelection<T> checkedTableSelection, Comparator<T> comparator) {
        super(CheckedTableColumns.class);
        if (comparator == null) {
            throw new NullPointerException("Comparator<Object> cannot be null");
        }
        this.selection = checkedTableSelection;
        this.comp = comparator;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int n, CheckedTableColumns checkedTableColumns) {
        switch (checkedTableColumns) {
            case SELECTION: {
                return this.data.get(n).isSelected();
            }
            case CAPTION: {
                return this.data.get(n).getCaption();
            }
            case TAG: {
                return this.data.get(n).getTag();
            }
            case OBJECT: {
                return this.data.get(n);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, CheckedTableColumns checkedTableColumns) {
        return checkedTableColumns.equals((Object)CheckedTableColumns.SELECTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, CheckedTableColumns checkedTableColumns) {
        T t;
        if (!CheckedTableColumns.SELECTION.equals((Object)checkedTableColumns)) {
            return;
        }
        CheckedTableModel checkedTableModel = this;
        synchronized (checkedTableModel) {
            if (this.data.get(n).isSelected().equals(object)) {
                return;
            }
            t = this.data.get(n).getTag();
            this.data.get(n).setSelected((Boolean)Boolean.class.cast(object));
        }
        this.fireTableCellUpdated(n, checkedTableColumns);
        this.selection.selected(t, (Boolean)Boolean.class.cast(object));
    }

    @Override
    public Class<?> getColumnClass(CheckedTableColumns checkedTableColumns) {
        switch (checkedTableColumns) {
            case SELECTION: {
                return Boolean.class;
            }
            case CAPTION: {
                return String.class;
            }
            case TAG: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(CheckedTableColumns checkedTableColumns) {
        switch (checkedTableColumns) {
            case SELECTION: {
                return checkedTableColumns.name();
            }
        }
        return "";
    }

    private int getIndex(T t) {
        return Collections.binarySearch(this.data, new DataEntry<T>(false, "", "", t), this.DataObjectComp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T t) {
        CheckedTableModel checkedTableModel = this;
        synchronized (checkedTableModel) {
            return this.getIndex(t) >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteElement(T t) {
        if (t == null) {
            return;
        }
        int n = -1;
        CheckedTableModel checkedTableModel = this;
        synchronized (checkedTableModel) {
            n = this.getIndex(t);
            if (n < 0) {
                return;
            }
            this.data.remove(n);
        }
        if (n != -1) {
            this.fireTableRowsDeleted(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addElement(String string, String string2, T t, boolean bl) {
        if (t == null) {
            return false;
        }
        int n = -1;
        CheckedTableModel checkedTableModel = this;
        synchronized (checkedTableModel) {
            n = this.getIndex(t);
            if (n >= 0) {
                return false;
            }
            ++n;
            n = -n;
            DataEntry<T> dataEntry = new DataEntry<T>(bl, string, string2, t);
            this.data.add(n, dataEntry);
        }
        this.fireTableRowsInserted(n, n);
        return true;
    }

    public void hide(Object object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, CheckedTableColumns.TAG) != object) continue;
            this.setValueAt((Object)Boolean.FALSE, i, CheckedTableColumns.SELECTION.ordinal());
        }
    }

    public void showOnly(Object object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, CheckedTableColumns.TAG) == object) {
                this.setValueAt((Object)Boolean.TRUE, i, CheckedTableColumns.SELECTION.ordinal());
                continue;
            }
            this.setValueAt((Object)Boolean.FALSE, i, CheckedTableColumns.SELECTION.ordinal());
        }
    }

    public void showAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt((Object)Boolean.TRUE, i, CheckedTableColumns.SELECTION.ordinal());
        }
    }

    public void hideAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt((Object)Boolean.FALSE, i, CheckedTableColumns.SELECTION.ordinal());
        }
    }
}

