/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb;

import ddb.bcb.BreadcrumbBarCallBack;
import ddb.bcb.BreadcrumbBarEvent;
import ddb.bcb.BreadcrumbBarListener;
import ddb.bcb.BreadcrumbItem;
import ddb.bcb.BreadcrumbItemChoices;
import ddb.bcb.BreadcrumbStack;
import ddb.bcb.ui.BasicBreadcrumbBarUI;
import ddb.bcb.ui.BreadcrumbBarUI;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbBar
extends JComponent {
    public static final String TAG_BCB = "bcbmemory";
    public static final String TAG_PATH = "bcbpath";
    public static final String TAG_ITEM = "bcbitem";
    public static final String TAG_COMPONENT = "bcbcomponent";
    private static final long serialVersionUID = 3258407339731400502L;
    protected BreadcrumbStack stack;
    protected Icon icon;
    protected String separator;
    protected JButton okButton;
    protected BreadcrumbBarCallBack callback = null;
    protected Color underlineColor = null;
    protected Color boxColor = null;
    private List<BreadcrumbBarListener> listeners = null;
    private boolean noEvent = false;
    private MouseListener popupListener = null;
    private List<BreadcrumbItem[]> memory = null;
    private int currentMemoryIndex = -1;
    private static final String uiClassID = "BreadcrumbBarUI";

    public void setPopupListener(MouseListener mouseListener) {
        this.popupListener = mouseListener;
    }

    public MouseListener getPopupListener() {
        return this.popupListener;
    }

    public void addListener(BreadcrumbBarListener breadcrumbBarListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BreadcrumbBarListener>();
        }
        if (!this.listeners.contains(breadcrumbBarListener)) {
            this.listeners.add(breadcrumbBarListener);
        }
    }

    public void removeListener(BreadcrumbBarListener breadcrumbBarListener) {
        if (this.listeners != null) {
            this.listeners.remove(breadcrumbBarListener);
        }
    }

    public void fireBreadcrumbBarEvent(BreadcrumbBarEvent breadcrumbBarEvent) {
        if (this.noEvent || this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).breadcrumbBarEvent(breadcrumbBarEvent);
        }
    }

    public BreadcrumbBar() {
        this(null, null, null, null);
    }

    public BreadcrumbBar(Icon icon, String string, JButton jButton, BreadcrumbBarCallBack breadcrumbBarCallBack) {
        this.icon = icon;
        this.stack = new BreadcrumbStack();
        this.separator = string;
        this.okButton = jButton;
        this.callback = breadcrumbBarCallBack;
        this.updateUI();
    }

    public BreadcrumbBar(Icon icon, String string, BreadcrumbBarCallBack breadcrumbBarCallBack) {
        this(icon, string, null, breadcrumbBarCallBack);
    }

    public BreadcrumbBar(String string, JButton jButton, BreadcrumbBarCallBack breadcrumbBarCallBack) {
        this(null, string, jButton, breadcrumbBarCallBack);
    }

    public BreadcrumbBar(String string, BreadcrumbBarCallBack breadcrumbBarCallBack) {
        this(null, string, null, breadcrumbBarCallBack);
    }

    public void setUnderlineColor(Color color) {
        this.underlineColor = color;
    }

    public void setBoxColor(Color color) {
        this.boxColor = color;
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setPath(BreadcrumbItem[] breadcrumbItemArray) {
        BreadcrumbItem[] breadcrumbItemArray2 = this.getPath();
        this.stack.clear();
        this.noEvent = true;
        BreadcrumbItemChoices breadcrumbItemChoices = null;
        breadcrumbItemChoices = this.callback.getChoices(null);
        this.pushChoices(breadcrumbItemChoices, false);
        for (int i = 0; breadcrumbItemArray != null && i < breadcrumbItemArray.length; ++i) {
            BreadcrumbItem breadcrumbItem = breadcrumbItemArray[i];
            this.pushChoice(breadcrumbItem, false);
            BreadcrumbItem[] breadcrumbItemArray3 = new BreadcrumbItem[i + 1];
            System.arraycopy(breadcrumbItemArray, 0, breadcrumbItemArray3, 0, i + 1);
            breadcrumbItemChoices = this.callback.getChoices(breadcrumbItemArray3);
            if (breadcrumbItemChoices == null && i + 1 < breadcrumbItemArray.length) {
                breadcrumbItemChoices = new BreadcrumbItemChoices(new BreadcrumbItem[]{breadcrumbItem});
            }
            if (breadcrumbItemChoices == null) continue;
            this.pushChoices(breadcrumbItemChoices, false);
        }
        this.getUI().updateComponents();
        this.noEvent = false;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 0, breadcrumbItemArray2, breadcrumbItemArray));
    }

    public BreadcrumbItem[] getPath() {
        return this.getPath(-1);
    }

    public BreadcrumbItem[] getPath(int n) {
        assert (n <= this.stack.size());
        Vector<BreadcrumbItem> vector = new Vector<BreadcrumbItem>();
        BreadcrumbItem[] breadcrumbItemArray = this.stack.listIterator(0);
        while (breadcrumbItemArray.hasNext()) {
            Object e = breadcrumbItemArray.next();
            if (e instanceof BreadcrumbItem) {
                vector.add((BreadcrumbItem)e);
            }
            if (this.stack.indexOf(e) != n) continue;
            break;
        }
        breadcrumbItemArray = new BreadcrumbItem[vector.size()];
        int n2 = 0;
        while (!vector.isEmpty()) {
            breadcrumbItemArray[n2++] = (BreadcrumbItem)vector.remove(0);
        }
        return breadcrumbItemArray;
    }

    public BreadcrumbItem getLastItem() {
        if (this.stack.isEmpty()) {
            return null;
        }
        Object e = this.stack.get(this.stack.size() - 1);
        if (e instanceof BreadcrumbItem) {
            return (BreadcrumbItem)e;
        }
        return null;
    }

    public BreadcrumbItem getItem(int n) {
        if (this.stack.isEmpty()) {
            return null;
        }
        if (n < 0 || n >= this.stack.size()) {
            return null;
        }
        Object e = this.stack.get(n);
        if (e instanceof BreadcrumbItem) {
            return (BreadcrumbItem)e;
        }
        return null;
    }

    public String getRootedPath() {
        return this.getRootedPath(-1);
    }

    public String getRootedPath(int n) {
        assert (n <= this.stack.size());
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.stack.listIterator(0);
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e instanceof BreadcrumbItemChoices) {
                stringBuffer.append(this.separator);
            } else if (e instanceof BreadcrumbItem) {
                stringBuffer.append(((BreadcrumbItem)e).getName());
            }
            if (this.stack.indexOf(e) != n) continue;
            break;
        }
        return stringBuffer.toString();
    }

    public Object pushChoices(BreadcrumbItemChoices breadcrumbItemChoices) {
        return this.pushChoices(breadcrumbItemChoices, true);
    }

    public Object pushChoices(BreadcrumbItemChoices breadcrumbItemChoices, boolean bl) {
        if (breadcrumbItemChoices == null) {
            return null;
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
        if (this.stack.size() % 2 == 1) {
            this.stack.pop();
        }
        breadcrumbItemChoices.setIndex(this.stack.size());
        Object object = this.stack.push(breadcrumbItemChoices);
        if (bl) {
            this.getUI().updateComponents();
        }
        return object;
    }

    public Object setChoices(int n, BreadcrumbItemChoices breadcrumbItemChoices, boolean bl) {
        if (breadcrumbItemChoices == null) {
            return null;
        }
        if (n > this.stack.size() || n % 2 == 1) {
            return null;
        }
        breadcrumbItemChoices.setIndex(n);
        this.stack.set(n, breadcrumbItemChoices);
        if (bl) {
            this.getUI().updateComponents();
        }
        return breadcrumbItemChoices;
    }

    public static BreadcrumbItemChoices makeChoices(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        BreadcrumbItem[] breadcrumbItemArray = new BreadcrumbItem[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            breadcrumbItemArray[i] = new BreadcrumbItem(new String[]{stringArray[i]});
        }
        return new BreadcrumbItemChoices(breadcrumbItemArray);
    }

    public static BreadcrumbItemChoices makeChoices(Vector<String> vector) {
        if (vector == null) {
            return null;
        }
        BreadcrumbItem[] breadcrumbItemArray = new BreadcrumbItem[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            breadcrumbItemArray[i] = new BreadcrumbItem(new String[]{vector.get(i)});
        }
        return new BreadcrumbItemChoices(breadcrumbItemArray);
    }

    public Object pushChoice(BreadcrumbItem breadcrumbItem) {
        return this.pushChoice(breadcrumbItem, true);
    }

    public Object pushChoice(BreadcrumbItem breadcrumbItem, boolean bl) {
        assert (breadcrumbItem != null);
        if (this.okButton != null) {
            this.okButton.setEnabled(true);
        }
        BreadcrumbItem[] breadcrumbItemArray = this.getPath();
        if (!this.stack.isEmpty() && this.stack.size() % 2 == 0) {
            this.stack.pop();
        }
        breadcrumbItem.setIndex(this.stack.size());
        Object object = this.stack.push(breadcrumbItem);
        if (bl) {
            this.getUI().updateComponents();
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 0, breadcrumbItemArray, this.getPath()));
        return object;
    }

    public Object pop() {
        if (this.stack.size() <= 1 && this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        return this.stack.pop();
    }

    public int getItemCount() {
        return this.stack.size();
    }

    @Override
    public String toString() {
        return Arrays.asList(this.getPath()).toString();
    }

    public void previous() {
        if (!this.hasPrevious()) {
            return;
        }
        this.setPath(this.memory.get(--this.currentMemoryIndex));
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void next() {
        if (!this.hasNext()) {
            return;
        }
        this.setPath(this.memory.get(++this.currentMemoryIndex));
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void setMemoryIndex(int n) {
        if (this.memory != null && n >= 0 && n < this.memory.size()) {
            this.currentMemoryIndex = n;
            this.setPath(this.memory.get(this.currentMemoryIndex));
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public List<BreadcrumbItem[]> getMemory() {
        return Collections.unmodifiableList(this.memory);
    }

    public int getMemoryIndex() {
        return this.currentMemoryIndex;
    }

    public boolean hasNext() {
        return this.memory != null && this.memory.size() > this.currentMemoryIndex + 1;
    }

    public boolean hasPrevious() {
        return this.memory != null && this.currentMemoryIndex > 0;
    }

    public void addPathToMemory(BreadcrumbItem[] breadcrumbItemArray) {
        if (this.memory == null) {
            this.memory = new ArrayList<BreadcrumbItem[]>();
        }
        if (this.currentMemoryIndex != this.memory.size()) {
            // empty if block
        }
        this.memory.add(breadcrumbItemArray);
        ++this.currentMemoryIndex;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public void addCurrentPathToMemory() {
        this.addPathToMemory(this.getPath());
    }

    public void clearMemory() {
        if (this.memory != null) {
            this.memory.clear();
        }
        this.currentMemoryIndex = -1;
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    private static void putOpenTag(PrintWriter printWriter, String string, boolean bl) {
        printWriter.write("<" + string + ">");
        if (bl) {
            printWriter.write(System.getProperty("line.separator"));
        }
    }

    private static void putCloseTag(PrintWriter printWriter, String string, boolean bl) {
        printWriter.write("</" + string + ">");
        if (bl) {
            printWriter.write(System.getProperty("line.separator"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMemory(OutputStream outputStream) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(outputStream);
            BreadcrumbBar.putOpenTag(printWriter, TAG_BCB, true);
            if (this.memory != null) {
                for (BreadcrumbItem[] breadcrumbItemArray : this.memory) {
                    printWriter.write("\t");
                    BreadcrumbBar.putOpenTag(printWriter, TAG_PATH, true);
                    for (BreadcrumbItem breadcrumbItem : breadcrumbItemArray) {
                        printWriter.write("\t\t");
                        BreadcrumbBar.putOpenTag(printWriter, TAG_ITEM, true);
                        for (String string : breadcrumbItem.getValue()) {
                            printWriter.write("\t\t\t");
                            BreadcrumbBar.putOpenTag(printWriter, TAG_COMPONENT, false);
                            printWriter.write(string);
                            BreadcrumbBar.putCloseTag(printWriter, TAG_COMPONENT, true);
                        }
                        printWriter.write("\t\t");
                        BreadcrumbBar.putCloseTag(printWriter, TAG_ITEM, true);
                    }
                    printWriter.write("\t");
                    BreadcrumbBar.putCloseTag(printWriter, TAG_PATH, true);
                }
            }
            BreadcrumbBar.putCloseTag(printWriter, TAG_BCB, true);
            printWriter.write(System.getProperty("line.separator"));
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public void loadMemory(InputStream inputStream) {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            DefaultHandler defaultHandler = new DefaultHandler(){
                List<BreadcrumbItem> currPath;
                List<String> currComponents;
                String currValue;

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    this.currValue = null;
                    if (BreadcrumbBar.TAG_PATH.equals(string3)) {
                        this.currPath = new LinkedList<BreadcrumbItem>();
                        return;
                    }
                    if (BreadcrumbBar.TAG_ITEM.equals(string3)) {
                        this.currComponents = new LinkedList<String>();
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (BreadcrumbBar.TAG_PATH.equals(string3)) {
                        BreadcrumbBar.this.memory.add(this.currPath.toArray(new BreadcrumbItem[0]));
                        return;
                    }
                    if (BreadcrumbBar.TAG_ITEM.equals(string3)) {
                        BreadcrumbItem breadcrumbItem = new BreadcrumbItem(this.currComponents.toArray(new String[0]));
                        BreadcrumbBar.this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(BreadcrumbBar.this, 2, null, breadcrumbItem));
                        this.currPath.add(breadcrumbItem);
                        return;
                    }
                    if (BreadcrumbBar.TAG_COMPONENT.equals(string3)) {
                        this.currComponents.add(this.currValue);
                        return;
                    }
                }

                public void characters(char[] cArray, int n, int n2) throws SAXException {
                    String string = new String(cArray, n, n2);
                    this.currValue = this.currValue == null ? string : this.currValue + string;
                }
            };
            sAXParser.parse(inputStream, defaultHandler);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        this.fireBreadcrumbBarEvent(new BreadcrumbBarEvent(this, 1, null, null));
    }

    public BreadcrumbBarCallBack getCallback() {
        return this.callback;
    }

    public void setUI(BreadcrumbBarUI breadcrumbBarUI) {
        super.setUI(breadcrumbBarUI);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BreadcrumbBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbBarUI());
        }
    }

    @Override
    public BreadcrumbBarUI getUI() {
        return (BreadcrumbBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public BreadcrumbStack getStack() {
        return this.stack;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public static interface BreadcrumbBarElement {
        public String getText();

        public int getIndex();
    }
}

