/*
 * Decompiled with CFR 0.152.
 */
package ddb.bcb.ui;

import ddb.bcb.BreadcrumbBar;
import ddb.bcb.ui.BreadcrumbBarUI;
import ddb.bcb.ui.BreadcrumbParticle;
import ddb.bcb.ui.ChoicesSelector;
import ddb.bcb.ui.ChoicesSelectorUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;

public class BasicChoicesSelectorUI
extends ChoicesSelectorUI {
    protected ChoicesSelector choicesSelector;
    protected FocusListener baseFocusListener;
    protected MouseListener baseMouseListener;
    protected KeyListener baseKeyListener;
    protected PopupMenuListener basePopupMenuListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicChoicesSelectorUI();
    }

    public void installUI(JComponent jComponent) {
        this.choicesSelector = (ChoicesSelector)jComponent;
        this.installDefaults(this.choicesSelector);
        this.installComponents(this.choicesSelector);
        this.installListeners(this.choicesSelector);
        jComponent.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.setLayout(null);
        this.uninstallListeners((ChoicesSelector)jComponent);
        this.uninstallComponents((ChoicesSelector)jComponent);
        this.uninstallDefaults((ChoicesSelector)jComponent);
        this.choicesSelector = null;
    }

    protected void installDefaults(ChoicesSelector choicesSelector) {
        choicesSelector.setFont(choicesSelector.getOwnerBar().getFont());
        choicesSelector.setCursor(Cursor.getPredefinedCursor(12));
        choicesSelector.setFocusable(true);
        choicesSelector.setOpaque(false);
        choicesSelector.setForeground(choicesSelector.getOwnerBar().getForeground());
    }

    protected void installComponents(ChoicesSelector choicesSelector) {
    }

    protected void installListeners(final ChoicesSelector choicesSelector) {
        this.baseFocusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                choicesSelector.getModel().setArmed(true);
                choicesSelector.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                choicesSelector.getModel().setArmed(false);
                choicesSelector.repaint();
            }
        };
        choicesSelector.addFocusListener(this.baseFocusListener);
        this.baseMouseListener = new MouseAdapter(){

            private boolean showPopup(ChoicesSelector choicesSelector2) {
                return choicesSelector2.getOwnerBar().getUI().popup(choicesSelector.getIndex());
            }

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl;
                choicesSelector.getModel().setPressed(true);
                choicesSelector.getModel().setSelected(true);
                choicesSelector.repaint();
                BreadcrumbBar breadcrumbBar = choicesSelector.getOwnerBar();
                int n = breadcrumbBar.getUI().getPopupInitiatorIndex();
                if (n < 0 && !(bl = this.showPopup(choicesSelector))) {
                    choicesSelector.getModel().setSelected(false);
                    choicesSelector.repaint();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                choicesSelector.getModel().setRollover(true);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                choicesSelector.getOwnerBar().repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BreadcrumbBar breadcrumbBar = choicesSelector.getOwnerBar();
                        int n = breadcrumbBar.getUI().getPopupInitiatorIndex();
                        if (n >= 0 && choicesSelector.getIndex() != n) {
                            breadcrumbBar.getUI().hidePopup();
                            choicesSelector.getModel().setSelected(true);
                            BasicChoicesSelectorUI.this.synchronizeWithParticle();
                            if (!this.showPopup(choicesSelector)) {
                                choicesSelector.getModel().setSelected(false);
                                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                            }
                        }
                    }
                });
            }

            public void mouseExited(MouseEvent mouseEvent) {
                choicesSelector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                choicesSelector.getOwnerBar().repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                choicesSelector.getModel().setPressed(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                choicesSelector.getOwnerBar().repaint();
            }
        };
        choicesSelector.addMouseListener(this.baseMouseListener);
        this.baseKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (choicesSelector.getModel().isArmed() && keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                    choicesSelector.getModel().setSelected(true);
                    choicesSelector.repaint();
                    if (!choicesSelector.getOwnerBar().getUI().popup(choicesSelector.getIndex())) {
                        choicesSelector.getModel().setSelected(false);
                        choicesSelector.repaint();
                    }
                }
            }
        };
        choicesSelector.addKeyListener(this.baseKeyListener);
        this.basePopupMenuListener = new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                choicesSelector.getModel().setSelected(false);
                choicesSelector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                choicesSelector.getModel().setSelected(false);
                choicesSelector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        };
        choicesSelector.getOwnerBar().getUI().getPopup().addPopupMenuListener(this.basePopupMenuListener);
    }

    protected void uninstallDefaults(ChoicesSelector choicesSelector) {
    }

    protected void uninstallComponents(ChoicesSelector choicesSelector) {
    }

    protected void uninstallListeners(ChoicesSelector choicesSelector) {
        choicesSelector.removeKeyListener(this.baseKeyListener);
        this.baseKeyListener = null;
        choicesSelector.removeMouseListener(this.baseMouseListener);
        this.baseMouseListener = null;
        choicesSelector.removeFocusListener(this.baseFocusListener);
        this.baseFocusListener = null;
        choicesSelector.getOwnerBar().getUI().getPopup().removePopupMenuListener(this.basePopupMenuListener);
        this.basePopupMenuListener = null;
    }

    protected BreadcrumbParticle synchronizeWithParticle() {
        BreadcrumbBar breadcrumbBar = this.choicesSelector.getOwnerBar();
        BreadcrumbBarUI breadcrumbBarUI = breadcrumbBar.getUI();
        BreadcrumbParticle breadcrumbParticle = breadcrumbBarUI.getParticle(this.choicesSelector.getIndex());
        if (breadcrumbParticle != null) {
            breadcrumbParticle.getModel().setArmed(this.choicesSelector.getModel().isArmed());
            breadcrumbParticle.getModel().setSelected(this.choicesSelector.getModel().isSelected());
            breadcrumbParticle.getModel().setRollover(this.choicesSelector.getModel().isRollover());
            this.choicesSelector.getOwnerBar().repaint();
        }
        return breadcrumbParticle;
    }

    protected LayoutManager createLayoutManager() {
        return new ChoicesSelectorLayout();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BreadcrumbBar breadcrumbBar = this.choicesSelector.getOwnerBar();
        BreadcrumbBarUI breadcrumbBarUI = breadcrumbBar.getUI();
        BreadcrumbParticle breadcrumbParticle = breadcrumbBarUI.getParticle(this.choicesSelector.getIndex());
        this.paintBackground(graphics2D, jComponent, breadcrumbParticle);
        this.paintForeground(graphics2D, jComponent);
        graphics2D.dispose();
    }

    protected void paintBackground(Graphics2D graphics2D, JComponent jComponent, BreadcrumbParticle breadcrumbParticle) {
        boolean bl;
        ChoicesSelector choicesSelector = (ChoicesSelector)jComponent;
        boolean bl2 = bl = choicesSelector.getModel().isArmed() || choicesSelector.getModel().isRollover() || choicesSelector.getModel().isSelected() || choicesSelector.getModel().isPressed();
        if (!bl) {
            return;
        }
        int n = jComponent.getWidth();
        Color color = this.choicesSelector.getOwnerBar().getBoxColor();
        if (color == null) {
            color = this.choicesSelector.getForeground();
        }
        graphics2D.setColor(color);
        graphics2D.drawRect(0, 0, n - 2, n - 1);
    }

    protected void paintForeground(Graphics2D graphics2D, JComponent jComponent) {
        ChoicesSelector choicesSelector = (ChoicesSelector)jComponent;
        if (choicesSelector.getModel().isSelected() || choicesSelector.getModel().isPressed()) {
            this.paintPressedState(graphics2D, jComponent);
        } else {
            this.paintRegularState(graphics2D, jComponent);
        }
    }

    protected void paintRegularState(Graphics2D graphics2D, JComponent jComponent) {
        int n = jComponent.getWidth();
        graphics2D.setColor(this.choicesSelector.getForeground());
        graphics2D.fillPolygon(new int[]{3 * n / 8, 5 * n / 8, 3 * n / 8}, new int[]{n / 4, n / 2, 3 * n / 4}, 3);
    }

    protected void paintPressedState(Graphics2D graphics2D, JComponent jComponent) {
        int n = jComponent.getWidth();
        graphics2D.rotate(1.5707963267948966, n / 2, n / 2);
        graphics2D.setColor(this.choicesSelector.getForeground());
        graphics2D.fillPolygon(new int[]{3 * n / 8, 5 * n / 8, 3 * n / 8}, new int[]{n / 4, n / 2, 3 * n / 4}, 3);
    }

    protected class ChoicesSelectorLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(15, 16);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
        }
    }
}

