/*
 * Decompiled with CFR 0.152.
 */
package ddb.console;

import ddb.console.ColorTheme;
import ddb.console.TextPanel;
import ddb.detach.TabbableOption;
import ddb.imagemanager.ImageManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionPane
extends TabbableOption {
    private static OptionPane instance = null;
    private static final String THEME_DIR = "\\Gui\\Config\\Console\\themes\\";
    private final Set<String> directories = new HashSet<String>();
    private TextPanel panel = new TextPanel();

    public static final synchronized OptionPane getInstance() {
        if (instance == null) {
            instance = new OptionPane();
            instance.setName("Text");
            instance.setShortDescription("The current text settings");
        }
        return instance;
    }

    @Override
    public JComponent getDisplay() {
        return this.panel;
    }

    private OptionPane() {
    }

    public ColorTheme getSharedTheme() {
        return this.panel.currentTheme;
    }

    public void addDirectory(String string) {
        this.addDirectories(Collections.singletonList(string));
    }

    public void addDirectories(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.addDirectories(Arrays.asList(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirectories(Collection<String> collection) {
        Collection<String> collection2 = collection;
        synchronized (collection2) {
            for (String string : collection) {
                this.directories.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColorTheme> getAllThemes() {
        Vector<ColorTheme> vector = new Vector<ColorTheme>();
        vector.add(this.panel.currentTheme);
        ArrayList<String> arrayList = new ArrayList<String>(this.directories.size());
        Set<String> set = this.directories;
        synchronized (set) {
            arrayList.addAll(this.directories);
        }
        for (String string : arrayList) {
            try {
                File[] fileArray;
                File file = new File(string, THEME_DIR);
                if (!file.exists() || (fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".xml");
                    }
                })) == null) continue;
                for (File file2 : fileArray) {
                    try {
                        Properties properties = new Properties();
                        properties.loadFromXML(new FileInputStream(file2));
                        ColorTheme colorTheme = new ColorTheme(properties);
                        vector.add(colorTheme);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public ColorTheme displayThemeSelectionDialog(ColorTheme colorTheme) {
        List<ColorTheme> list = this.getAllThemes();
        Object object = JOptionPane.showInputDialog(this.getDisplay(), "Choose a theme", "Console Color Theme Selector", 3, ImageManager.getIcon(this.getLogo(), ImageManager.SIZE22), list.toArray(new ColorTheme[list.size()]), colorTheme.getName());
        return (ColorTheme)object;
    }
}

