/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.detach.Tabbable;
import ddb.detach.Workbench;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class AbstractDetachMenu
extends JPopupMenu {
    protected Workbench workbench;

    public AbstractDetachMenu(final Workbench workbench) {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        Iterator iterator;
        Serializable serializable;
        JMenu jMenu;
        this.workbench = workbench;
        if (this.allowTabRotate()) {
            jMenu = new JMenu("Align Tabs");
            serializable = new JCheckBoxMenuItem("Top", workbench.getTabPlacement() == 1);
            iterator = new JCheckBoxMenuItem("Bottom", workbench.getTabPlacement() == 3);
            JCheckBoxMenuItem object2 = new JCheckBoxMenuItem("Right", workbench.getTabPlacement() == 4);
            jCheckBoxMenuItem = new JCheckBoxMenuItem("Left", workbench.getTabPlacement() == 2);
            jMenu.add((JMenuItem)serializable);
            jMenu.add(object2);
            jMenu.add(jCheckBoxMenuItem);
            jMenu.add((JMenuItem)((Object)iterator));
            ((AbstractButton)serializable).addActionListener(new RotatePlacement(1));
            object2.addActionListener(new RotatePlacement(4));
            jCheckBoxMenuItem.addActionListener(new RotatePlacement(2));
            ((AbstractButton)((Object)iterator)).addActionListener(new RotatePlacement(3));
            this.add(jMenu);
            JMenu jMenu2 = new JMenu("Tab Policy");
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Scrolling", workbench.getTabLayoutPolicy() == 1);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Wrapping", workbench.getTabLayoutPolicy() == 0);
            jMenu2.add(jCheckBoxMenuItem2);
            jMenu2.add(jCheckBoxMenuItem3);
            jCheckBoxMenuItem2.addActionListener(new TabPolicy(1));
            jCheckBoxMenuItem3.addActionListener(new TabPolicy(0));
            this.add(jMenu2);
        }
        if (this.allowVisibleMenu()) {
            jMenu = new JMenu(this.getVisibleItemName());
            serializable = new Vector();
            for (final Tabbable tabbable : workbench.getTabs()) {
                if (tabbable == null || !tabbable.isHideable() || tabbable.isDetached()) continue;
                jCheckBoxMenuItem = new JCheckBoxMenuItem(tabbable.getName(), !tabbable.isHidden());
                jCheckBoxMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jCheckBoxMenuItem.isSelected()) {
                            workbench.enqueAction(Workbench.WorkbenchAction.UNHIDETAB, tabbable);
                            workbench.enqueAction(Workbench.WorkbenchAction.SETSELECTEDTAB, tabbable);
                        } else {
                            workbench.enqueAction(Workbench.WorkbenchAction.HIDETAB, tabbable);
                        }
                    }
                });
                serializable.add(jCheckBoxMenuItem);
            }
            if (serializable.size() > 0) {
                this.add(jMenu);
                iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    JMenuItem jMenuItem = (JMenuItem)iterator.next();
                    jMenu.add(jMenuItem);
                }
            }
        }
    }

    protected String getVisibleItemName() {
        return "Visible Items";
    }

    protected boolean allowVisibleMenu() {
        return true;
    }

    protected boolean allowTabRotate() {
        return true;
    }

    private class TabPolicy
    implements ActionListener {
        int policy;

        public TabPolicy(int n) {
            this.policy = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDetachMenu.this.workbench.setTabLayoutPolicy(this.policy);
        }
    }

    private class RotatePlacement
    implements ActionListener {
        int placement;

        public RotatePlacement(int n) {
            this.placement = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDetachMenu.this.workbench.setTabPlacement(this.placement);
        }
    }
}

