/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DnDTabbedPane
extends JTabbedPane {
    private static final int LINEWIDTH = 3;
    private static final String NAME = "DnDTabbedPane_Tab";
    private final GhostGlassPane glassPane = new GhostGlassPane();
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = new Color(0, 100, 255);
    private int dragTabIndex = -1;
    private static Rectangle rBackward = new Rectangle();
    private static Rectangle rForward = new Rectangle();
    private static int rwh = 20;
    private static int buttonsize = 30;
    private boolean hasGhost = true;

    private void clickArrowButton(String string) {
        Action action;
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null && (action = actionMap.get(string)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    private void autoScrollTest(Point point) {
        Rectangle rectangle = this.getTabAreaBounds();
        int n = this.getTabPlacement();
        if (n == 1 || n == 3) {
            rBackward.setBounds(rectangle.x, rectangle.y, rwh, rectangle.height);
            rForward.setBounds(rectangle.x + rectangle.width - rwh - buttonsize, rectangle.y, rwh + buttonsize, rectangle.height);
        } else if (n == 2 || n == 4) {
            rBackward.setBounds(rectangle.x, rectangle.y, rectangle.width, rwh);
            rForward.setBounds(rectangle.x, rectangle.y + rectangle.height - rwh - buttonsize, rectangle.width, rwh + buttonsize);
        }
        if (rBackward.contains(point)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(point)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    public DnDTabbedPane() {
        try {
            this.init();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public DnDTabbedPane(int n) {
        super(n);
        try {
            this.init();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public DnDTabbedPane(int n, int n2) {
        super(n, n2);
        try {
            this.init();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private void init() throws ClassNotFoundException {
        final DragSourceListener dragSourceListener = new DragSourceListener(){

            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            public void dragExit(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                DnDTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.glassPane.setPoint(new Point(-1000, -1000));
                DnDTabbedPane.this.glassPane.repaint();
            }

            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
                Point point = dragSourceDragEvent.getLocation();
                SwingUtilities.convertPointFromScreen(point, DnDTabbedPane.this.glassPane);
                int n = DnDTabbedPane.this.getTargetTabIndex(point);
                if (DnDTabbedPane.this.getTabAreaBounds().contains(point) && n >= 0 && n != DnDTabbedPane.this.dragTabIndex && n != DnDTabbedPane.this.dragTabIndex + 1) {
                    dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                } else {
                    dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                DnDTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.dragTabIndex = -1;
                DnDTabbedPane.this.glassPane.setVisible(false);
                if (DnDTabbedPane.this.hasGhost()) {
                    DnDTabbedPane.this.glassPane.setVisible(false);
                    DnDTabbedPane.this.glassPane.setImage(null);
                }
            }

            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }
        };
        final Transferable transferable = new Transferable(){
            private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "DnDTabbedPane_Tab");

            public Object getTransferData(DataFlavor dataFlavor) {
                return DnDTabbedPane.this;
            }

            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{this.FLAVOR};
                return dataFlavorArray;
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.getHumanPresentableName().equals(DnDTabbedPane.NAME);
            }
        };
        DragGestureListener dragGestureListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (DnDTabbedPane.this.getTabCount() <= 1) {
                    return;
                }
                Point point = dragGestureEvent.getDragOrigin();
                DnDTabbedPane.this.dragTabIndex = DnDTabbedPane.this.indexAtLocation(point.x, point.y);
                if (DnDTabbedPane.this.dragTabIndex < 0 || !DnDTabbedPane.this.isEnabledAt(DnDTabbedPane.this.dragTabIndex)) {
                    return;
                }
                DnDTabbedPane.this.initGlassPane(dragGestureEvent.getComponent(), dragGestureEvent.getDragOrigin());
                try {
                    dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, dragSourceListener);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    invalidDnDOperationException.printStackTrace();
                }
            }
        };
        new DropTarget(this.glassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dragGestureListener);
    }

    public void setPaintGhost(boolean bl) {
        this.hasGhost = bl;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    private int getTargetTabIndex(Point point) {
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, this);
        boolean bl = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle rectangle = this.getBoundsAt(i);
            if (bl) {
                rectangle.setRect(rectangle.x - rectangle.width / 2, rectangle.y, rectangle.width, rectangle.height);
            } else {
                rectangle.setRect(rectangle.x, rectangle.y - rectangle.height / 2, rectangle.width, rectangle.height);
            }
            if (!rectangle.contains(point2)) continue;
            return i;
        }
        Rectangle rectangle = this.getBoundsAt(this.getTabCount() - 1);
        if (bl) {
            rectangle.setRect(rectangle.x + rectangle.width / 2, rectangle.y, rectangle.width, rectangle.height);
        } else {
            rectangle.setRect(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height);
        }
        return rectangle.contains(point2) ? this.getTabCount() : -1;
    }

    protected void convertTab(int n, int n2) {
        if (n2 < 0 || n == n2) {
            return;
        }
        Component component = this.getComponentAt(n);
        Component component2 = this.getTabComponentAt(n);
        String string = this.getTitleAt(n);
        Icon icon = this.getIconAt(n);
        String string2 = this.getToolTipTextAt(n);
        boolean bl = this.isEnabledAt(n);
        int n3 = n > n2 ? n2 : n2 - 1;
        this.remove(n);
        this.insertTab(string, icon, component, string2, n3);
        this.setEnabledAt(n3, bl);
        if (bl) {
            this.setSelectedIndex(n3);
        }
        this.setTabComponentAt(n3, component2);
    }

    private void initTargetLeftRightLine(int n) {
        if (n < 0 || this.dragTabIndex == n || n - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (n == 0) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(rectangle.x - 1, rectangle.y, 3.0, rectangle.height);
        } else {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(n - 1), this.glassPane);
            this.lineRect.setRect(rectangle.x + rectangle.width - 1, rectangle.y, 3.0, rectangle.height);
        }
    }

    private void initTargetTopBottomLine(int n) {
        if (n < 0 || this.dragTabIndex == n || n - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (n == 0) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(rectangle.x, rectangle.y - 1, rectangle.width, 3.0);
        } else {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(n - 1), this.glassPane);
            this.lineRect.setRect(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.width, 3.0);
        }
    }

    private void initGlassPane(Component component, Point point) {
        Cloneable cloneable;
        this.getRootPane().setGlassPane(this.glassPane);
        if (this.hasGhost()) {
            cloneable = this.getBoundsAt(this.dragTabIndex);
            BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics graphics = bufferedImage.getGraphics();
            component.paint(graphics);
            cloneable.x = cloneable.x < 0 ? 0 : cloneable.x;
            cloneable.y = cloneable.y < 0 ? 0 : cloneable.y;
            bufferedImage = bufferedImage.getSubimage(cloneable.x, cloneable.y, cloneable.width, cloneable.height);
            this.glassPane.setImage(bufferedImage);
        }
        cloneable = SwingUtilities.convertPoint(component, point, this.glassPane);
        this.glassPane.setPoint((Point)cloneable);
        this.glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBounds() {
        Rectangle rectangle = this.getBounds();
        Component component = this.getSelectedComponent();
        int n = 0;
        while (component == null && n < this.getTabCount()) {
            component = this.getComponentAt(n++);
        }
        Rectangle rectangle2 = component == null ? new Rectangle() : component.getBounds();
        switch (this.getTabPlacement()) {
            case 1: {
                rectangle.height -= rectangle2.height;
                break;
            }
            case 3: {
                rectangle.y = rectangle.y + rectangle2.y + rectangle2.height;
                rectangle.height -= rectangle2.height;
                break;
            }
            case 2: {
                rectangle.width -= rectangle2.width;
                break;
            }
            case 4: {
                rectangle.x = rectangle.x + rectangle2.x + rectangle2.width;
                rectangle.width -= rectangle2.width;
            }
        }
        rectangle.grow(2, 2);
        return rectangle;
    }

    class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage draggingGhost = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
            this.setCursor(null);
        }

        public void setImage(BufferedImage bufferedImage) {
            this.draggingGhost = bufferedImage;
        }

        public void setPoint(Point point) {
            this.location = point;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(this.composite);
            if (this.draggingGhost != null) {
                double d = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
                double d2 = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
                graphics2D.drawImage((Image)this.draggingGhost, (int)d, (int)d2, null);
            }
            if (DnDTabbedPane.this.dragTabIndex >= 0) {
                graphics2D.setPaint(DnDTabbedPane.this.lineColor);
                graphics2D.fill(DnDTabbedPane.this.lineRect);
            }
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        private Point pt_ = new Point();

        CDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            if (DnDTabbedPane.this.getTabPlacement() == 1 || DnDTabbedPane.this.getTabPlacement() == 3) {
                DnDTabbedPane.this.initTargetLeftRightLine(DnDTabbedPane.this.getTargetTabIndex(point));
            } else {
                DnDTabbedPane.this.initTargetTopBottomLine(DnDTabbedPane.this.getTargetTabIndex(point));
            }
            if (DnDTabbedPane.this.hasGhost()) {
                DnDTabbedPane.this.glassPane.setPoint(point);
            }
            if (!this.pt_.equals(point)) {
                DnDTabbedPane.this.glassPane.repaint();
            }
            this.pt_ = point;
            DnDTabbedPane.this.autoScrollTest(point);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (this.isDropAcceptable(dropTargetDropEvent)) {
                DnDTabbedPane.this.convertTab(DnDTabbedPane.this.dragTabIndex, DnDTabbedPane.this.getTargetTabIndex(dropTargetDropEvent.getLocation()));
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
            DnDTabbedPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            if (transferable == null) {
                return false;
            }
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            return transferable.isDataFlavorSupported(dataFlavorArray[0]) && DnDTabbedPane.this.dragTabIndex >= 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable == null) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            return transferable.isDataFlavorSupported(dataFlavorArray[0]) && DnDTabbedPane.this.dragTabIndex >= 0;
        }
    }
}

