/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.actions.tabnav.NavigationDirection;
import ddb.actions.tabnav.NavigationListener;
import ddb.detach.TabbableFrame;
import ddb.detach.Workbench;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class TabNavigationListener
implements NavigationListener {
    public void navigationActionPerformed(NavigationDirection navigationDirection, ActionEvent actionEvent) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.navigateRecursive(navigationDirection, component);
    }

    private boolean navigateRecursive(NavigationDirection navigationDirection, Component component) {
        if (component == null) {
            return false;
        }
        if (this.adjust(navigationDirection, component, false)) {
            return true;
        }
        if (component instanceof TabbableFrame ? this.navigateRecursive(navigationDirection, ((TabbableFrame)TabbableFrame.class.cast(component)).getWorkbench()) : this.navigateRecursive(navigationDirection, component.getParent())) {
            return true;
        }
        return this.adjust(navigationDirection, component, true);
    }

    private boolean adjust(NavigationDirection navigationDirection, Component component, boolean bl) {
        if (component instanceof JTextField) {
            switch (navigationDirection) {
                case NEXT: {
                    return TabNavigationListener.jumpRight((JComponent)JTextField.class.cast(component));
                }
                case PREVIOUS: {
                    return TabNavigationListener.jumpLeft((JComponent)JTextField.class.cast(component));
                }
            }
        } else {
            if (component instanceof Workbench) {
                Workbench workbench = (Workbench)component;
                return workbench.navigate(navigationDirection, bl, false);
            }
            if (component instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                int n = jTabbedPane.getSelectedIndex();
                switch (navigationDirection) {
                    case NEXT: {
                        if (n + 1 < jTabbedPane.getTabCount()) {
                            jTabbedPane.setSelectedIndex(n + 1);
                            return true;
                        }
                        if (!bl) break;
                        jTabbedPane.setSelectedIndex(0);
                        break;
                    }
                    case PREVIOUS: {
                        if (n > 0) {
                            jTabbedPane.setSelectedIndex(n - 1);
                            return true;
                        }
                        if (!bl) break;
                        jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
                    }
                }
            }
        }
        return false;
    }

    public static boolean jumpRight(JComponent jComponent) {
        if (!(jComponent instanceof JTextField)) {
            return false;
        }
        JTextField jTextField = (JTextField)jComponent;
        String string = jTextField.getText();
        int n = jTextField.getSelectionEnd();
        if (n >= string.length()) {
            return false;
        }
        boolean bl = false;
        while (n < string.length()) {
            boolean bl2 = false;
            switch (string.charAt(n)) {
                case '\t': 
                case ' ': {
                    bl = true;
                    break;
                }
                default: {
                    bl2 = bl;
                }
            }
            if (bl2) break;
            ++n;
        }
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(n);
        return true;
    }

    public static boolean jumpLeft(JComponent jComponent) {
        if (!(jComponent instanceof JTextField)) {
            return false;
        }
        JTextField jTextField = (JTextField)jComponent;
        String string = jTextField.getText();
        int n = jTextField.getSelectionStart() - 1;
        if (n < 0) {
            return false;
        }
        boolean bl = false;
        while (n > 0) {
            boolean bl2 = false;
            switch (string.charAt(n)) {
                case '\t': 
                case ' ': {
                    if (!bl) break;
                    ++n;
                    bl2 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (bl2) break;
            --n;
        }
        jTextField.setSelectionStart(n);
        jTextField.setSelectionEnd(n);
        return true;
    }
}

