/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.detach.Tabbable;
import ddb.detach.TabbablePopupMenu;
import ddb.detach.Workbench;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class TabbablePopupListener
extends MouseAdapter {
    protected Workbench workbench;

    public TabbablePopupListener(Workbench workbench) {
        this.workbench = workbench;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            int n = this.workbench.getUI().tabForCoordinate(this.workbench, mouseEvent.getX(), mouseEvent.getY());
            if (n == -1) {
                JPopupMenu jPopupMenu = this.workbench.getMenu();
                if (jPopupMenu != null) {
                    SwingUtilities.updateComponentTreeUI(jPopupMenu);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            Component component = this.workbench.getComponentAt(n);
            Tabbable tabbable = this.workbench.getTabbableForDisplay(component);
            TabbablePopupMenu tabbablePopupMenu = this.getPopupMenu(tabbable);
            SwingUtilities.updateComponentTreeUI(tabbablePopupMenu);
            tabbablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected TabbablePopupMenu getPopupMenu(Tabbable tabbable) {
        return new TabbablePopupMenu(tabbable, this.workbench);
    }
}

