/*
 * Decompiled with CFR 0.152.
 */
package ddb.detach;

import ddb.actions.tabnav.NavigationDirection;
import ddb.detach.AbstractTabbable;
import ddb.detach.DnDTabbedPane;
import ddb.detach.StatusAlmalgum;
import ddb.detach.Tabbable;
import ddb.detach.TabbableFrame;
import ddb.detach.TabbablePopupListener;
import ddb.detach.TabbableStatus;
import ddb.imagemanager.ImageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Workbench
extends DnDTabbedPane
implements Observer {
    public static final String WORKBENCH_CONTENTS_CHANGED = "WORKBENCH_CONTENTS_CHANGED";
    public static final String WORKBENCH_CONTENTS_CHANGED_REQUEST_FOCUS = "WORKBENCH_CONTENTS_CHANGED_REQUEST_FOCUS";
    public static final PropertyChangeListener UpdatedTab = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof AbstractTabbable) {
                AbstractTabbable abstractTabbable = (AbstractTabbable)propertyChangeEvent.getSource();
                Workbench workbench = abstractTabbable.getWorkbench();
                if (abstractTabbable != null && workbench != null) {
                    if (workbench.getSelectedComponent() == abstractTabbable.getDisplay()) {
                        abstractTabbable.setDisplayColor(Color.BLACK);
                    } else {
                        abstractTabbable.colorCycle = (abstractTabbable.colorCycle + 1) % colors.size();
                        abstractTabbable.setDisplayColor(colors.get(abstractTabbable.colorCycle));
                    }
                    if (abstractTabbable.isHidden() && abstractTabbable.wasTabbed()) {
                        workbench.enqueAction(WorkbenchAction.UNHIDETAB, abstractTabbable);
                    }
                    workbench.firePropertyChange(Workbench.WORKBENCH_CONTENTS_CHANGED, false, true);
                }
            }
        }
    };
    public static final PropertyChangeListener UpdatedTabRequestFocus = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof AbstractTabbable) {
                UpdatedTab.propertyChange(propertyChangeEvent);
                AbstractTabbable abstractTabbable = (AbstractTabbable)propertyChangeEvent.getSource();
                Workbench workbench = abstractTabbable.getWorkbench();
                if (abstractTabbable != null && workbench != null) {
                    workbench.enqueAction(WorkbenchAction.SETSELECTEDTAB, abstractTabbable);
                    workbench.firePropertyChange(Workbench.WORKBENCH_CONTENTS_CHANGED_REQUEST_FOCUS, false, true);
                }
            }
        }
    };
    public static final List<Color> colors = new Vector<Color>();
    private final Hashtable<JComponent, Tabbable> componentToPlugin = new Hashtable();
    protected Logger logger;
    public static final Runnable NULL;
    private StatusAlmalgum status = new StatusAlmalgum(null, null);
    protected boolean selected;
    protected boolean allowWrap = false;
    protected Predicate isSelectedPred = new Predicate(){

        public boolean evaluate(Object object) {
            return Workbench.this.isSelected();
        }
    };
    protected Map<Enum<?>, Class<? extends TabTask>> actionHandler = new HashMap();
    protected final List<Tabbable> pluginsInOrder = new Vector<Tabbable>();
    Tabbable currentTab = null;
    private static final Dimension DEFAULT_DIMENSION;

    public void invokeAction(Enum<?> enum_, Object ... objectArray) {
        this.create(enum_, objectArray).run();
    }

    public void enqueAction(Enum<?> enum_, Object ... objectArray) {
        EventQueue.invokeLater(this.create(enum_, objectArray));
    }

    protected final Runnable create(Enum<?> enum_, Object ... objectArray) {
        Class<? extends TabTask> clazz = this.actionHandler.get(enum_);
        if (clazz == null) {
            return NULL;
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = this;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i + 1] = objectArray[i];
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != objectArray2.length) continue;
            try {
                return (Runnable)constructor.newInstance(objectArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NULL;
    }

    public Workbench(Logger logger) {
        this.logger = logger;
        this.initialize();
    }

    public Workbench(Logger logger, int n) {
        super(n);
        this.logger = logger;
        this.initialize();
    }

    public Workbench(Logger logger, int n, int n2) {
        super(n, n2);
        this.logger = logger;
        this.initialize();
    }

    public Workbench() {
        this.logger = Logger.getLogger("dsz.core");
        this.initialize();
    }

    public Workbench(int n) {
        super(n);
        this.logger = Logger.getLogger("dsz.core");
        this.initialize();
    }

    public Workbench(int n, int n2) {
        super(n, n2);
        this.logger = Logger.getLogger("dsz.core");
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(this.getTabPopupListener());
        this.actionHandler.put(WorkbenchAction.DETACHTAB, DetachTab.class);
        this.actionHandler.put(WorkbenchAction.PREDETACHTAB, PredetachTab.class);
        this.actionHandler.put(WorkbenchAction.TABBIFYTAB, TabbifyTab.class);
        this.actionHandler.put(WorkbenchAction.HIDETAB, HideTab.class);
        this.actionHandler.put(WorkbenchAction.UNHIDETAB, UnhideTab.class);
        this.actionHandler.put(WorkbenchAction.RENAMETAB, RenameTab.class);
        this.actionHandler.put(WorkbenchAction.SETSELECTEDTAB, SetSelectedTab.class);
        this.actionHandler.put(WorkbenchAction.SETSELECTEDINDEX, SetSelectedIndex.class);
        this.actionHandler.put(WorkbenchAction.ADDNEWTAB, AddNewTab.class);
        this.actionHandler.put(WorkbenchAction.REMOVETAB, RemoveTab.class);
        this.actionHandler.put(WorkbenchAction.ADDTABTOWORKBENCH, AddTabToWorkbench.class);
        this.actionHandler.put(WorkbenchAction.STEALFOCUS, StealFocus.class);
        this.actionHandler.put(WorkbenchAction.SETSTATE, SetState.class);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabbableStatus tabbableStatus = null;
                Tabbable tabbable = Workbench.this.getTabbableForDisplay(Workbench.this.getSelectedComponent());
                if (tabbable != null) {
                    tabbableStatus = tabbable.getStatus();
                    JComponent jComponent = tabbable.getDefaultElement();
                    if (jComponent != null) {
                        jComponent.requestFocusInWindow();
                    }
                    tabbable.setDisplayColor(Color.BLACK);
                }
                Workbench.this.status.setDelegate(tabbableStatus, tabbable);
            }
        });
    }

    protected Tabbable.TabState getState(Tabbable tabbable) {
        if (tabbable == null) {
            return Tabbable.TabState.UNKNOWN;
        }
        return tabbable.getCurrentState();
    }

    protected TabbableFrame getTabFrame(Tabbable tabbable, Dimension dimension, Point point) {
        TabbableFrame tabbableFrame;
        if (tabbable == null) {
            return null;
        }
        if (dimension == null) {
            dimension = tabbable.getFrameSize();
        }
        if (dimension == null) {
            dimension = this.getDefaultSize();
        }
        if (point == null) {
            point = tabbable.getFrameLocation();
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((tabbableFrame = tabbable.getFrame()) == null) {
            tabbableFrame = this.generateTabFrame(tabbable, dimension, point);
            tabbable.setFrame(tabbableFrame);
        } else {
            tabbableFrame.setSize(dimension);
            tabbableFrame.setLocation(point);
        }
        tabbableFrame.setVisible(true);
        tabbableFrame.requestFocus();
        return tabbableFrame;
    }

    protected Dimension getDefaultSize() {
        return DEFAULT_DIMENSION;
    }

    protected TabbableFrame generateTabFrame(Tabbable tabbable, Dimension dimension, Point point) {
        return new TabbableFrame(tabbable, this, dimension, point);
    }

    protected Tabbable.TabState getPrevState(Tabbable tabbable) {
        return tabbable.getPreviousState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tabbable> getTabs() {
        Vector<Tabbable> vector = new Vector<Tabbable>();
        Hashtable<JComponent, Tabbable> hashtable = this.componentToPlugin;
        synchronized (hashtable) {
            vector.addAll(this.componentToPlugin.values());
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tabbable getTabbableForDisplay(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JComponent) {
            Object object = this.pluginsInOrder;
            synchronized (object) {
                for (Tabbable tabbable : this.pluginsInOrder) {
                    if (!tabbable.getDisplay().equals(component)) continue;
                    return tabbable;
                }
            }
            object = this.componentToPlugin;
            synchronized (object) {
                return this.componentToPlugin.get(JComponent.class.cast(component));
            }
        }
        return null;
    }

    public TabbableStatus getStatus() {
        return this.status;
    }

    public JPopupMenu getMenu() {
        return null;
    }

    public TabbablePopupListener getTabPopupListener() {
        return new TabbablePopupListener(this);
    }

    public Dimension getTabImageSize() {
        return ImageManager.SIZE32;
    }

    public Dimension getLabelImageSize() {
        return ImageManager.SIZE16;
    }

    protected int compareTabs(Tabbable tabbable, Tabbable tabbable2) {
        return tabbable.getName().compareToIgnoreCase(tabbable2.getName());
    }

    public void contentsChanged() {
        this.firePropertyChange(WORKBENCH_CONTENTS_CHANGED, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tabbable getTabbableByClass(Class<? extends Tabbable> clazz) {
        Hashtable<JComponent, Tabbable> hashtable = this.componentToPlugin;
        synchronized (hashtable) {
            for (Tabbable tabbable : this.componentToPlugin.values()) {
                if (!this.compareForClass(tabbable, clazz)) continue;
                return tabbable;
            }
        }
        return null;
    }

    protected boolean compareForClass(Tabbable tabbable, Class<? extends Tabbable> clazz) {
        return tabbable.getClass().equals(clazz);
    }

    public boolean pluginIsDetached(Tabbable tabbable) {
        return tabbable.isDetached() || tabbable.isHidden() && tabbable.wasDetached();
    }

    public boolean pluginIsVisible(Tabbable tabbable) {
        return !tabbable.isHidden();
    }

    public boolean pluginIsHidden(Tabbable tabbable) {
        return tabbable.isHidden();
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(String.format("<html><center>%s</center></html>", string), icon, component, string2, n);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelectedComponent(Component component) {
        Tabbable tabbable = this.getTabbableForDisplay(this.getSelectedComponent());
        if (tabbable != null) {
            tabbable.setSelected(false);
        }
        super.setSelectedComponent(component);
        tabbable = this.getTabbableForDisplay(this.getSelectedComponent());
        if (tabbable != null) {
            tabbable.setSelected(true);
            this.currentTab = tabbable;
            if (component != null) {
                component.requestFocus();
            }
            tabbable.getDisplay().putClientProperty("windowModified", Boolean.FALSE);
        }
    }

    @Override
    public String getTitleAt(int n) {
        Tabbable tabbable;
        Component component = this.getComponentAt(n);
        if (component != null && (tabbable = this.getTabbableForDisplay(component)) != null) {
            return tabbable.getDockedTitle();
        }
        return super.getTitleAt(n);
    }

    @Override
    public void setSelectedIndex(int n) {
        Tabbable tabbable = this.getTabbableForDisplay(this.getSelectedComponent());
        if (tabbable != null) {
            tabbable.setSelected(false);
        }
        super.setSelectedIndex(n);
        tabbable = this.getTabbableForDisplay(this.getSelectedComponent());
        if (tabbable != null) {
            tabbable.setSelected(true);
            this.currentTab = tabbable;
            JComponent jComponent = tabbable.getDefaultElement();
            if (jComponent != null) {
                ((Component)jComponent).requestFocus();
            }
            tabbable.getDisplay().putClientProperty("windowModified", Boolean.FALSE);
        }
    }

    protected boolean doesAllowWrap() {
        return this.allowWrap;
    }

    public void setAllowWrap(boolean bl) {
        this.allowWrap = bl;
    }

    public boolean navigate(NavigationDirection navigationDirection, boolean bl, boolean bl2) {
        Tabbable tabbable = null;
        int n = super.getSelectedIndex();
        switch (navigationDirection) {
            case NEXT: {
                ++n;
                break;
            }
            case PREVIOUS: {
                --n;
            }
        }
        if (n >= this.getTabCount() && bl) {
            n %= this.getTabCount();
        }
        if (n < 0 && bl) {
            n = this.getTabCount() - 1;
        }
        if (n >= 0 && n < this.getTabCount()) {
            Component component = super.getComponentAt(n);
            tabbable = this.getTabbableForDisplay(component);
        }
        if (tabbable == null) {
            if (bl2) {
                return this.punt(navigationDirection, bl);
            }
            return false;
        }
        if (tabbable.isTabbed()) {
            this.setSelectedComponent(tabbable.getDisplay());
            this.currentTab = tabbable;
            JComponent jComponent = this.currentTab.getDefaultElement();
            if (jComponent == null) {
                jComponent = this.currentTab.getDisplay();
            }
            this.ascend(jComponent);
            if (jComponent != null) {
                ((Component)jComponent).requestFocus();
            }
        } else if (tabbable.isDetached()) {
            Container container;
            this.ascend(tabbable.getDefaultElement());
            JComponent jComponent = tabbable.getDefaultElement();
            if (jComponent == null) {
                jComponent = tabbable.getFrame().getRootPane();
            }
            for (container = jComponent; container != null && !(container instanceof JFrame); container = container.getParent()) {
            }
            if (container instanceof JFrame) {
                ((JFrame)JFrame.class.cast(container)).requestFocus();
            }
            if (jComponent != null) {
                ((Component)jComponent).requestFocusInWindow();
            }
        }
        return true;
    }

    protected boolean punt(NavigationDirection navigationDirection, boolean bl) {
        Container container = null;
        for (Container container2 = this.getParent(); container2 != null && !(container2 instanceof JFrame); container2 = container2.getParent()) {
            if (container2 instanceof Workbench) {
                container = container2;
                if (!((Workbench)Workbench.class.cast(container2)).navigate(navigationDirection, bl, false)) continue;
                return true;
            }
            if (!(container2 instanceof JTabbedPane)) continue;
        }
        return container != null && container instanceof Workbench && ((Workbench)Workbench.class.cast(container)).navigate(navigationDirection, true, false);
    }

    private void ascend(Component component) {
        this.ascend(component, new Stack<Component>());
    }

    private void ascend(Component component, Stack<Component> stack) {
        if (component == null) {
            return;
        }
        if (component instanceof JFrame) {
            return;
        }
        stack.push(component);
        Container container = component.getParent();
        if (container instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)JTabbedPane.class.cast(container);
            while (!stack.isEmpty()) {
                Component component2 = stack.pop();
                try {
                    jTabbedPane.setSelectedComponent(component2);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        } else if (container instanceof JFrame) {
            ((JFrame)JFrame.class.cast(container)).requestFocus();
        }
        this.ascend(container, stack);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof StatusAlmalgum) {
            return;
        }
        if (observable instanceof Tabbable) {
            object = observable;
        }
        if (object instanceof Tabbable) {
            Tabbable tabbable = (Tabbable)object;
        }
    }

    public void titleChanged() {
    }

    void setCurrentTab(Tabbable tabbable) {
        this.currentTab = tabbable;
    }

    public Tabbable getCurrentTab() {
        return this.currentTab;
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertTab(int n, int n2) {
        Component component = super.getComponentAt(n);
        if (component != null) {
            Tabbable tabbable = this.getTabbableForDisplay(component);
            List<Tabbable> list = this.pluginsInOrder;
            synchronized (list) {
                if (tabbable != null) {
                    this.pluginsInOrder.remove(tabbable);
                    if (n2 > this.getTabCount()) {
                        this.pluginsInOrder.add(tabbable);
                    } else if (n2 == 0) {
                        this.pluginsInOrder.add(n2, tabbable);
                    } else {
                        int n3;
                        int n4 = n3 = n2 - 1 != n ? n2 - 1 : n2 - 2;
                        if (n3 < 0) {
                            this.pluginsInOrder.add(0, tabbable);
                        } else {
                            Tabbable tabbable2;
                            Component component2 = super.getComponentAt(n3);
                            if (component2 != null && (tabbable2 = this.getTabbableForDisplay(component2)) != null) {
                                n3 = this.pluginsInOrder.indexOf(tabbable2);
                                if (n3 < this.pluginsInOrder.size()) {
                                    this.pluginsInOrder.add(n3 + 1, tabbable);
                                } else {
                                    this.pluginsInOrder.add(tabbable);
                                }
                            }
                        }
                    }
                    if (!this.pluginsInOrder.contains(tabbable)) {
                        this.pluginsInOrder.add(tabbable);
                    }
                }
            }
        }
        super.convertTab(n, n2);
    }

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    static {
        for (String string : new String[]{"0xff0000", "0x800000", "0x808000", "0x008000", "0x00ff00", "0x008000", "0x008080", "0x000080", "0x0000ff", "0x000080", "0x800080", "0x800000"}) {
            colors.add(Color.decode(string));
        }
        colors.remove(Color.WHITE);
        colors.remove(Color.BLACK);
        NULL = new Runnable(){

            public void run() {
            }
        };
        DEFAULT_DIMENSION = new Dimension(640, 480);
    }

    protected class SetState
    extends DirectTabTask {
        Tabbable.TabState newState;

        public SetState(Tabbable tabbable, Tabbable.TabState tabState) {
            super(tabbable);
            this.newState = tabState;
        }

        public void runTask() {
            if (this.tab == null) {
                return;
            }
            if (this.newState == Tabbable.TabState.TABBED) {
                this.tab.generateDockedTitle();
            } else if (this.newState == Tabbable.TabState.DETACHED) {
                this.tab.generateFloatingTitle();
            }
            this.tab.setState(this.newState);
        }
    }

    protected class StealFocus
    extends DirectTabTask {
        int iterations;

        public StealFocus(Tabbable tabbable) {
            super(tabbable);
            this.iterations = 10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask() {
            List<Tabbable> list = Workbench.this.pluginsInOrder;
            synchronized (list) {
                if (Workbench.this.pluginsInOrder.contains(this.tab)) {
                    if (this.tab.isTabbed()) {
                        Workbench.this.invokeAction(WorkbenchAction.SETSELECTEDTAB, this.tab);
                    }
                } else if (this.iterations-- > 0) {
                    EventQueue.invokeLater(this);
                }
            }
        }
    }

    protected abstract class CloseTab
    extends DirectTabTask {
        public CloseTab(Tabbable tabbable) {
            super(tabbable);
        }
    }

    protected class AddTabToWorkbench
    extends DirectTabTask {
        public AddTabToWorkbench(Tabbable tabbable) {
            super(tabbable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask() {
            Object object;
            int n = -1;
            this.tab.addPropertyChangeListener("TABBABLE_CONTENT_CHANGED", UpdatedTab);
            this.tab.addPropertyChangeListener("TABBABLE_CONTENT_CHANGED_REQUEST_FOCUS", UpdatedTabRequestFocus);
            List<Tabbable> list = Workbench.this.pluginsInOrder;
            synchronized (list) {
                int n2;
                if (!Workbench.this.pluginsInOrder.contains(this.tab)) {
                    for (n2 = 0; n2 < Workbench.this.pluginsInOrder.size(); ++n2) {
                        object = Workbench.this.pluginsInOrder.get(n2);
                        if (object.compareTo(this.tab) <= 0) continue;
                        n = n2;
                        Workbench.this.pluginsInOrder.add(n, this.tab);
                        break;
                    }
                    if (n == -1) {
                        n = Workbench.this.pluginsInOrder.size();
                        Workbench.this.pluginsInOrder.add(this.tab);
                    }
                } else {
                    for (n2 = 0; n2 < Workbench.this.getTabCount(); ++n2) {
                        if (Workbench.this.getTabComponentAt(n2) != this.tab.getDisplay()) continue;
                        return;
                    }
                }
            }
            if (this.tab.isDetached()) {
                return;
            }
            int n3 = 0;
            Object object2 = Workbench.this.pluginsInOrder;
            synchronized (object2) {
                Tabbable tabbable;
                object = Workbench.this.pluginsInOrder.iterator();
                while (object.hasNext() && (tabbable = (Tabbable)object.next()) != this.tab) {
                    if (!tabbable.isTabbed() || tabbable.isHidden()) continue;
                    ++n3;
                }
            }
            object2 = null;
            if (this.tab.getLogo() != null) {
                object2 = ImageManager.getIcon(this.tab.getLogo(), Workbench.this.getTabImageSize());
            }
            if (n3 >= Workbench.this.getTabCount()) {
                n3 = Workbench.this.getTabCount();
            }
            Workbench.this.insertTab(this.tab.getName(), (Icon)object2, this.tab.getDisplay(), this.tab.getShortDescription(), n3);
            Workbench.this.setTabComponentAt(n3, this.tab.getTabComponent());
            this.tab.setTabbed();
        }

        public boolean isRequiresDispatch() {
            return true;
        }
    }

    protected class RemoveTab
    extends DirectTabTask {
        public RemoveTab(Tabbable tabbable) {
            super(tabbable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask() {
            this.tab.removePropertyChangeListener("TABBABLE_CONTENT_CHANGED", UpdatedTab);
            this.tab.removePropertyChangeListener("TABBABLE_CONTENT_CHANGED_REQUEST_FOCUS", UpdatedTabRequestFocus);
            List<Tabbable> list = Workbench.this.pluginsInOrder;
            synchronized (list) {
                Workbench.this.pluginsInOrder.remove(this.tab);
            }
            int n = Workbench.this.indexOfComponent(this.tab.getDisplay());
            if (n > -1) {
                Workbench.this.removeTabAt(n);
            }
            Hashtable hashtable = Workbench.this.componentToPlugin;
            synchronized (hashtable) {
                Workbench.this.componentToPlugin.remove(this.tab.getDisplay());
            }
            this.tab.getStatus().deleteObserver(Workbench.this);
            if (Workbench.this.currentTab == this.tab) {
                Workbench.this.currentTab = null;
            }
        }
    }

    protected class AddNewTab
    extends DirectTabTask {
        public AddNewTab(Tabbable tabbable) {
            super(tabbable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runTask() {
            this.tab.setWorkbench(Workbench.this);
            Object object = Workbench.this.componentToPlugin;
            synchronized (object) {
                if (this.tab.getDisplay() != null) {
                    Workbench.this.componentToPlugin.put(this.tab.getDisplay(), this.tab);
                }
            }
            Workbench.this.invokeAction(WorkbenchAction.ADDTABTOWORKBENCH, this.tab);
            this.tab.generateDockedTitle();
            object = this.tab.getStatus();
            object.addObserver(Workbench.this);
        }
    }

    protected class SetSelectedIndex
    extends IndirectTabTask {
        Integer index;

        public SetSelectedIndex(Integer n) {
            this.index = n;
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            if (Workbench.this.getTabCount() == 0) {
                return;
            }
            this.index = this.index < 0 ? Integer.valueOf(this.index + Workbench.this.getTabCount()) : Integer.valueOf(this.index % Workbench.this.getTabCount());
            Workbench.this.setSelectedIndex(this.index);
        }
    }

    protected class SetSelectedTab
    extends DirectTabTask {
        public SetSelectedTab(Tabbable tabbable) {
            super(tabbable);
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            switch (this.tab.getCurrentState()) {
                case TABBED: {
                    Workbench.this.setSelectedIndex(Workbench.this.indexOfComponent(this.tab.getDisplay()));
                    Workbench.this.requestFocusInWindow();
                    break;
                }
                case DETACHED: {
                    Workbench.this.getTabFrame(this.tab, null, null).toFront();
                    break;
                }
                case HIDDEN: {
                    Workbench.this.invokeAction(WorkbenchAction.UNHIDETAB, this.tab);
                    this.run();
                    break;
                }
            }
        }
    }

    protected class RenameTab
    extends DirectTabTask {
        protected String name;

        public RenameTab(Tabbable tabbable) {
            super(tabbable);
        }

        public RenameTab(Tabbable tabbable, String string) {
            super(tabbable);
            this.name = string;
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            if (this.tab == null) {
                return;
            }
            if (this.name == null) {
                this.name = this.tab.getName();
            }
            switch (this.tab.getCurrentState()) {
                case TABBED: {
                    this.tab.setName(this.name);
                    int n = Workbench.this.indexOfComponent(this.tab.getDisplay());
                    if (n == -1) {
                        System.err.println("out of order");
                        return;
                    }
                    Workbench.this.setTitleAt(n, this.tab.getDockedTitle());
                    break;
                }
                case DETACHED: {
                    this.tab.setName(this.name);
                    Workbench.this.getTabFrame(this.tab, null, null).setTitle(this.tab.getDetachedTitle());
                    return;
                }
                case HIDDEN: {
                    this.tab.setName(this.name);
                    break;
                }
            }
        }
    }

    protected class UnhideTab
    extends DirectTabTask {
        public UnhideTab(Tabbable tabbable) {
            super(tabbable);
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            try {
                if (this.tab.getCurrentState() != Tabbable.TabState.HIDDEN) {
                    return;
                }
                switch (this.tab.getPreviousState()) {
                    case TABBED: 
                    case UNKNOWN: {
                        Workbench.this.invokeAction(WorkbenchAction.ADDTABTOWORKBENCH, this.tab);
                        break;
                    }
                    case DETACHED: {
                        Workbench.this.invokeAction(WorkbenchAction.DETACHTAB, this.tab, null, null);
                        return;
                    }
                    case HIDDEN: {
                        Workbench.this.invokeAction(WorkbenchAction.ADDTABTOWORKBENCH, this.tab);
                    }
                }
            }
            catch (Exception exception) {
                Workbench.this.logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    protected class HideTab
    extends DirectTabTask {
        public HideTab(Tabbable tabbable) {
            super(tabbable);
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            switch (this.tab.getCurrentState()) {
                case TABBED: {
                    int n = Workbench.this.indexOfComponent(this.tab.getDisplay());
                    if (n > -1) {
                        Workbench.this.remove(n);
                    }
                    this.tab.setHidden();
                    break;
                }
                case DETACHED: {
                    Workbench.this.getTabFrame(this.tab, null, null).setVisible(false);
                    this.tab.setHidden();
                    break;
                }
                case HIDDEN: {
                    return;
                }
                case UNKNOWN: {
                    this.tab.setHidden();
                }
            }
        }
    }

    protected class TabbifyTab
    extends DirectTabTask {
        public TabbifyTab(Tabbable tabbable) {
            super(tabbable);
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            switch (this.tab.getCurrentState()) {
                case TABBED: {
                    return;
                }
                case DETACHED: {
                    this.tab.hideFrame();
                    this.tab.setTabbed();
                    break;
                }
                case UNKNOWN: 
                case HIDDEN: {
                    this.tab.setTabbed();
                }
            }
            Workbench.this.invokeAction(WorkbenchAction.ADDTABTOWORKBENCH, this.tab);
            Workbench.this.invokeAction(WorkbenchAction.SETSELECTEDTAB, this.tab);
        }
    }

    protected class PredetachTab
    extends DirectTabTask {
        protected Dimension size;
        protected Point position;

        public PredetachTab(Tabbable tabbable, Dimension dimension, Point point) {
            super(tabbable);
            this.size = dimension;
            this.position = point;
        }

        public void runTask() {
            Workbench.this.getTabFrame(this.tab, this.size, this.position);
        }
    }

    protected class DetachTab
    extends DirectTabTask {
        protected Dimension size;
        protected Point position;

        public DetachTab(Tabbable tabbable, Dimension dimension, Point point) {
            super(tabbable);
            this.size = dimension;
            this.position = point;
        }

        protected boolean isRequiresDispatch() {
            return true;
        }

        public void runTask() {
            switch (this.tab.getCurrentState()) {
                case TABBED: {
                    int n = Workbench.this.indexOfComponent(this.tab.getDisplay());
                    this.tab.setDetached();
                    if (n == -1) break;
                    Workbench.this.removeTabAt(n);
                    break;
                }
                case DETACHED: {
                    return;
                }
                case UNKNOWN: 
                case HIDDEN: {
                    this.tab.setDetached();
                }
            }
            TabbableFrame tabbableFrame = Workbench.this.getTabFrame(this.tab, this.size, this.position);
            tabbableFrame.setDisplay(this.tab.getDisplay());
            tabbableFrame.setVisible(true);
            tabbableFrame.repaint();
        }
    }

    protected abstract class DirectTabTask
    extends TabTask {
        protected Tabbable tab;

        protected DirectTabTask(Tabbable tabbable) {
            this.tab = tabbable;
        }
    }

    protected abstract class IndirectTabTask
    extends TabTask {
        protected IndirectTabTask() {
        }
    }

    protected abstract class TabTask
    implements Runnable {
        protected TabTask() {
        }

        public final void run() {
            if (EventQueue.isDispatchThread()) {
                try {
                    this.runTask();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (this.isRequiresDispatch()) {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    Logger.getLogger("dsz").log(Level.SEVERE, null, invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                this.runTask();
            }
        }

        public abstract void runTask();

        protected boolean isRequiresDispatch() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WorkbenchAction {
        DETACHTAB,
        PREDETACHTAB,
        TABBIFYTAB,
        HIDETAB,
        UNHIDETAB,
        RENAMETAB,
        SETSELECTEDTAB,
        SETSELECTEDINDEX,
        ADDNEWTAB,
        REMOVETAB,
        ADDTABTOWORKBENCH,
        CLOSETAB,
        STEALFOCUS,
        SETSTATE;

    }
}

