/*
 * Decompiled with CFR 0.152.
 */
package ddb.imagemanager;

import ddb.imagemanager.CreateSizeMapOnDemand;
import ddb.imagemanager.LoadImageOnDemand;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.collections.map.ReferenceMap;

public class ImageManager {
    Map<String, ImageIcon> nameToIcon = LazyMap.decorate((Map)new ReferenceMap(), (Transformer)new LoadImageOnDemand(this));
    Map<Dimension, Map<String, ImageIcon>> sizeToImageMap = LazyMap.decorate((Map)new ReferenceMap(), (Transformer)new CreateSizeMapOnDemand(this));
    public static final Dimension SIZE128 = new Dimension(128, 128);
    public static final Dimension SIZE256 = new Dimension(256, 256);
    public static final Dimension SIZE64 = new Dimension(64, 64);
    public static final Dimension SIZE48 = new Dimension(48, 48);
    public static final Dimension SIZE32 = new Dimension(32, 32);
    public static final Dimension SIZE22 = new Dimension(22, 22);
    public static final Dimension SIZE16 = new Dimension(16, 16);
    public static final Dimension BANNER_SIZE = SIZE64;
    public static final Dimension NOTICE_SIZE = SIZE128;
    private static final String BROKEN_FILE = "images/file_broken.png";
    private static ImageManager manager;

    private static synchronized ImageManager getManager() {
        if (manager == null) {
            manager = new ImageManager();
        }
        return manager;
    }

    private ImageManager() {
    }

    public static ImageIcon getIcon(String string, Dimension dimension) {
        try {
            if (dimension == null) {
                return null;
            }
            if (string == null) {
                return ImageManager.getIcon(BROKEN_FILE, dimension);
            }
            return ImageManager.getManager().sizeToImageMap.get(dimension).get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    ImageIcon getBrokenFile(String string, Dimension dimension) {
        if (!string.equals(BROKEN_FILE)) {
            return ImageManager.getIcon(BROKEN_FILE, dimension);
        }
        return null;
    }

    ImageIcon getFullIcon(String string) {
        ImageIcon imageIcon = this.nameToIcon.get(string);
        if (imageIcon == null) {
            System.out.println("Unable to get icon for '" + string + "'.");
        }
        return imageIcon;
    }
}

