/*
 * Decompiled with CFR 0.152.
 */
package ddb.splash;

import ddb.GuiConstants;
import ddb.imagemanager.ImageManager;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class SplashScreen3
extends JFrame {
    private JLabel bannerImage;
    private JProgressBar majorProgress;
    private JProgressBar minorProgress;
    private JButton skip;
    private JLabel stageIcon;
    private JLabel state;

    public SplashScreen3(String string) {
        this.initComponents();
        GuiConstants.locate(this, 0.5, 0.25);
        this.setTitle(string);
        this.skip.setVisible(false);
    }

    public void setStageIcon(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.stageIcon.setIcon(ImageManager.getIcon(string, ImageManager.SIZE64));
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen3.this.setStageIcon(string);
                }
            });
        }
    }

    public void setDisplayedText(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.state.setText(string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen3.this.setDisplayedText(string);
                }
            });
        }
    }

    public void showSkip(final ActionListener actionListener) {
        if (EventQueue.isDispatchThread()) {
            if (actionListener != null) {
                this.skip.addActionListener(actionListener);
            }
            this.skip.setVisible(true);
            super.validate();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen3.this.showSkip(actionListener);
                }
            });
        }
    }

    public void setMinorProgress(int n, int n2, int n3) {
        this.setProgress(this.minorProgress, n, n2, n3);
    }

    public void setMajorProgress(int n, int n2, int n3) {
        this.setProgress(this.majorProgress, n, n2, n3);
    }

    public void setMinorIndeterminate(boolean bl) {
        this.setIndeterminate(this.minorProgress, bl);
    }

    public void setMajorIndeterminate(boolean bl) {
        this.setIndeterminate(this.majorProgress, bl);
    }

    private void setIndeterminate(final JProgressBar jProgressBar, final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            jProgressBar.setIndeterminate(bl);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen3.this.setIndeterminate(jProgressBar, bl);
                }
            });
        }
    }

    private void setProgress(final JProgressBar jProgressBar, final int n, final int n2, final int n3) {
        if (EventQueue.isDispatchThread()) {
            try {
                jProgressBar.setMinimum(n);
                jProgressBar.setMaximum(n2);
                jProgressBar.setValue(n3);
                jProgressBar.setIndeterminate(false);
            }
            catch (Exception exception) {
                System.out.printf("Bar: %s, min = %d, max = %d, value = %d\n", jProgressBar == this.majorProgress ? "Major" : "Minor", n, n2, n3);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SplashScreen3.this.setProgress(jProgressBar, n, n2, n3);
                }
            });
        }
    }

    private void initComponents() {
        this.bannerImage = new JLabel();
        this.minorProgress = new JProgressBar();
        this.state = new JLabel();
        this.majorProgress = new JProgressBar();
        this.stageIcon = new JLabel();
        this.skip = new JButton();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setUndecorated(true);
        this.bannerImage.setIcon(new ImageIcon(this.getClass().getResource("/images/earth.png")));
        this.stageIcon.setIcon(new ImageIcon(this.getClass().getResource("/images/blockdevice.png")));
        this.skip.setText("Skip");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bannerImage).addGroup(groupLayout.createSequentialGroup().addComponent(this.stageIcon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.state, -1, 326, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.minorProgress, GroupLayout.Alignment.LEADING, -1, 267, Short.MAX_VALUE).addComponent(this.majorProgress, -1, 267, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skip))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.bannerImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.state, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.majorProgress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.minorProgress, -2, -1, -2)).addComponent(this.skip, -1, 45, Short.MAX_VALUE))).addComponent(this.stageIcon)).addContainerGap()));
        this.pack();
    }
}

