/*
 * Decompiled with CFR 0.152.
 */
package ddb.writequeue;

import ddb.writequeue.Writable;
import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteQueue<E extends Writable>
implements Runnable {
    static ThreadFactory factory = new ThreadFactory(){
        int count = 0;

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "WriteQueue thread: " + ++this.count);
            thread.setPriority(1);
            thread.setDaemon(true);
            return thread;
        }
    };
    final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(factory);
    final LinkedList<E> list = new LinkedList();
    Closure onWrite;
    boolean onEventQueue = false;
    boolean paused = false;

    public WriteQueue(TimeUnit timeUnit, long l, Closure closure, boolean bl) {
        this.onWrite = closure;
        this.onEventQueue = bl;
        this.executor.scheduleWithFixedDelay(this, 0L, l, timeUnit);
    }

    public WriteQueue(Closure closure, boolean bl) {
        this(TimeUnit.MILLISECONDS, 150L, closure, bl);
    }

    public void setOnEventQueue(boolean bl) {
        this.onEventQueue = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.paused) {
            return;
        }
        Vector<E> vector = new Vector<E>();
        Object object = this.list;
        synchronized (object) {
            vector.addAll(this.list);
            this.list.clear();
        }
        if (vector.isEmpty()) {
            return;
        }
        object = new WriteExec(vector);
        if (this.onEventQueue) {
            EventQueue.invokeLater((Runnable)object);
        } else {
            ((WriteExec)object).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(E object) {
        LinkedList<E> linkedList = this.list;
        synchronized (linkedList) {
            while (this.list.size() != 0) {
                if (object.resets()) {
                    this.list.clear();
                    break;
                }
                Writable writable = (Writable)this.list.removeLast();
                if (writable.combine((Writable)object)) {
                    object = writable;
                    continue;
                }
                this.list.offer(writable);
                break;
            }
            this.list.offer(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reque(E e) {
        LinkedList<E> linkedList = this.list;
        synchronized (linkedList) {
            this.list.offerFirst(e);
        }
    }

    public void stop() {
        this.executor.shutdown();
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WriteExec
    implements Runnable {
        List<E> items;

        public WriteExec(List<E> list) {
            this.items = list;
        }

        @Override
        public void run() {
            for (Writable writable : this.items) {
                WriteQueue.this.onWrite.execute((Object)writable);
            }
        }
    }
}

