/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ImageCache {
    private final LinkedHashMap<Integer, PixelCountSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private final int maxSingleImagePixelSize;
    private int currentPixelCount = 0;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private static final ImageCache instance = new ImageCache();

    static ImageCache getInstance() {
        return instance;
    }

    public ImageCache() {
        this.maxPixelCount = 0x200000;
        this.maxSingleImagePixelSize = 90000;
    }

    public ImageCache(int n, int n2) {
        this.maxPixelCount = n;
        this.maxSingleImagePixelSize = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.lock.readLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isImageCachable(int n, int n2) {
        return n * n2 < this.maxSingleImagePixelSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object ... objectArray) {
        this.lock.readLock().lock();
        try {
            PixelCountSoftReference pixelCountSoftReference = this.map.get(this.hash(graphicsConfiguration, n, n2, objectArray));
            if (pixelCountSoftReference != null && pixelCountSoftReference.equals(graphicsConfiguration, n, n2, objectArray)) {
                Image image = (Image)pixelCountSoftReference.get();
                return image;
            }
            Image image = null;
            return image;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setImage(Image image, GraphicsConfiguration graphicsConfiguration, int n, int n2, Object ... objectArray) {
        if (!this.isImageCachable(n, n2)) {
            return false;
        }
        int n3 = this.hash(graphicsConfiguration, n, n2, objectArray);
        this.lock.writeLock().lock();
        try {
            PixelCountSoftReference pixelCountSoftReference = this.map.get(n3);
            if (pixelCountSoftReference != null && pixelCountSoftReference.get() == image) {
                boolean bl = true;
                return bl;
            }
            if (pixelCountSoftReference != null) {
                this.currentPixelCount -= pixelCountSoftReference.pixelCount;
                this.map.remove(n3);
            }
            int n4 = image.getWidth(null) * image.getHeight(null);
            this.currentPixelCount += n4;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((pixelCountSoftReference = (PixelCountSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(pixelCountSoftReference.hash);
                    this.currentPixelCount -= pixelCountSoftReference.pixelCount;
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator<Map.Entry<Integer, PixelCountSoftReference>> iterator = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && iterator.hasNext()) {
                    Map.Entry<Integer, PixelCountSoftReference> entry = iterator.next();
                    iterator.remove();
                    Image image2 = (Image)entry.getValue().get();
                    if (image2 != null) {
                        image2.flush();
                    }
                    this.currentPixelCount -= entry.getValue().pixelCount;
                }
            }
            this.map.put(n3, new PixelCountSoftReference(image, this.referenceQueue, n4, n3, graphicsConfiguration, n, n2, objectArray));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private int hash(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object ... objectArray) {
        int n3 = graphicsConfiguration != null ? graphicsConfiguration.hashCode() : 0;
        n3 = 31 * n3 + n;
        n3 = 31 * n3 + n2;
        n3 = 31 * n3 + Arrays.deepHashCode(objectArray);
        return n3;
    }

    private static class PixelCountSoftReference
    extends SoftReference<Image> {
        private final int pixelCount;
        private final int hash;
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Object[] args;

        public PixelCountSoftReference(Image image, ReferenceQueue<? super Image> referenceQueue, int n, int n2, GraphicsConfiguration graphicsConfiguration, int n3, int n4, Object[] objectArray) {
            super(image, referenceQueue);
            this.pixelCount = n;
            this.hash = n2;
            this.config = graphicsConfiguration;
            this.w = n3;
            this.h = n4;
            this.args = objectArray;
        }

        public boolean equals(GraphicsConfiguration graphicsConfiguration, int n, int n2, Object[] objectArray) {
            return graphicsConfiguration == this.config && n == this.w && n2 == this.h && Arrays.equals(objectArray, this.args);
        }
    }
}

