/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.commandviewer;

import ddb.dsz.core.command.CommandEvent;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.controller.DispatcherException;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.task.Task;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.multitarget.SingleTargetImpl;
import ddb.imagemanager.ImageManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandViewerHost
extends SingleTargetImpl {
    public static final String COMMAND_VIEWER = "images/konsole.png";
    public static final String PAUSED = "images/player_pause.png";
    public static final String TASKED = "images/player_end.png";
    public static final String RUNNING = "images/player_play.png";
    public static final String BANNER = "images/flag.png";
    JTree commandTree;
    DefaultTreeModel commandModel;
    DefaultMutableTreeNode commandRoot;
    Map<Task, DefaultMutableTreeNode> taskToNode;
    Icon running;
    Icon paused;
    Icon tasked;
    Icon banner;

    public CommandViewerHost(HostInfo hostInfo, CoreController coreController) {
        super(hostInfo, coreController);
        this.tasked = ImageManager.getIcon((String)TASKED, (Dimension)coreController.getLabelImageSize());
        this.paused = ImageManager.getIcon((String)PAUSED, (Dimension)coreController.getLabelImageSize());
        this.running = ImageManager.getIcon((String)RUNNING, (Dimension)coreController.getLabelImageSize());
        this.banner = ImageManager.getIcon((String)BANNER, (Dimension)coreController.getLabelImageSize());
        this.commandRoot = new DefaultMutableTreeNode("Currently running commands:");
        this.commandModel = new DefaultTreeModel(this.commandRoot);
        this.commandTree = new JTree(this.commandModel);
        this.taskToNode = new Hashtable<Task, DefaultMutableTreeNode>();
        JScrollPane jScrollPane = new JScrollPane(this.commandTree);
        super.setDisplay((JComponent)jScrollPane);
        coreController.setupKeyBindings((JComponent)this.commandTree);
        coreController.setupKeyBindings((JComponent)jScrollPane);
        this.setupStandardActionMaps(this.commandTree);
        this.setupStandardActionMaps(jScrollPane);
        this.commandTree.addTreeWillExpandListener(new CollapseRootVeto());
        this.commandTree.setCellRenderer(new TaskRenderer());
    }

    private void evaluateTask(final Task task) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    CommandViewerHost.this.evaluateTask(task);
                }
            });
            return;
        }
        if (task == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.taskToNode.get(task);
        if (defaultMutableTreeNode != null) {
            this.commandModel.nodeChanged(defaultMutableTreeNode);
        }
        switch (task.getState()) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: {
                if (defaultMutableTreeNode != null) {
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        int n = -1;
                        if (defaultMutableTreeNode2 != null) {
                            n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                        }
                        int n2 = defaultMutableTreeNode.getChildCount() - 1;
                        while (n != -1 && defaultMutableTreeNode.getChildCount() > 0) {
                            MutableTreeNode mutableTreeNode = (MutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                            this.commandModel.removeNodeFromParent(mutableTreeNode);
                            this.commandModel.insertNodeInto(mutableTreeNode, defaultMutableTreeNode2, n++);
                            --n2;
                        }
                    }
                    this.commandModel.removeNodeFromParent(defaultMutableTreeNode);
                    this.taskToNode.remove(task);
                }
                return;
            }
        }
        if (defaultMutableTreeNode == null) {
            DefaultMutableTreeNode defaultMutableTreeNode3;
            defaultMutableTreeNode = new DefaultMutableTreeNode(task);
            this.taskToNode.put(task, defaultMutableTreeNode);
            if (task.getParentTask() == null) {
                defaultMutableTreeNode3 = this.commandRoot;
            } else {
                defaultMutableTreeNode3 = this.taskToNode.get(task.getParentTask());
                if (defaultMutableTreeNode3 == null) {
                    defaultMutableTreeNode3 = this.commandRoot;
                }
            }
            this.commandModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
            Object[] objectArray = this.commandModel.getPathToRoot(defaultMutableTreeNode.getParent());
            this.commandTree.expandPath(new TreePath(objectArray));
        } else {
            this.commandModel.nodeChanged(defaultMutableTreeNode);
        }
    }

    public void commandEventReceived(CommandEvent commandEvent) {
        if (commandEvent == null) {
            return;
        }
        if (commandEvent.getId().equals((Object)TaskId.UNINITIALIZED_ID)) {
            return;
        }
        this.evaluateTask(this.core.getTaskById(commandEvent.getId()));
    }

    public void addTasks(Collection<Task> collection) {
        for (Task task : collection) {
            this.evaluateTask(task);
        }
    }

    private void killSelected() {
        for (TreePath treePath : this.commandTree.getSelectionPaths()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (!(treePath.getLastPathComponent() instanceof DefaultMutableTreeNode) || !((defaultMutableTreeNode = (DefaultMutableTreeNode)DefaultMutableTreeNode.class.cast(treePath.getLastPathComponent())).getUserObject() instanceof Task)) continue;
            Task task = (Task)Task.class.cast(defaultMutableTreeNode.getUserObject());
            try {
                this.core.killCommand(task);
            }
            catch (DispatcherException dispatcherException) {
                this.core.logEvent(Level.SEVERE, CommandViewerHost.class.getSimpleName(), dispatcherException.getMessage(), (Throwable)dispatcherException);
            }
        }
    }

    private void setupStandardActionMaps(JComponent jComponent) {
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put("kill command", new AbstractAction("kill command"){

            public void actionPerformed(ActionEvent actionEvent) {
                CommandViewerHost.this.killSelected();
            }
        });
    }

    private final class TaskRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer def = new DefaultTreeCellRenderer();

        private TaskRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.def.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel && object instanceof DefaultMutableTreeNode) {
                JLabel jLabel = (JLabel)component;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof Task) {
                    Task task = (Task)defaultMutableTreeNode.getUserObject();
                    jLabel.setText(task.getId() + ": " + task.getTypedCommand());
                    switch (task.getState()) {
                        case PAUSED: {
                            jLabel.setIcon(CommandViewerHost.this.paused);
                            break;
                        }
                        case RUNNING: {
                            jLabel.setIcon(CommandViewerHost.this.running);
                            break;
                        }
                        case TASKED: {
                            jLabel.setIcon(CommandViewerHost.this.tasked);
                            break;
                        }
                        default: {
                            jLabel.setIcon(null);
                            break;
                        }
                    }
                } else {
                    jLabel.setIcon(CommandViewerHost.this.banner);
                }
            }
            return component;
        }
    }

    private final class CollapseRootVeto
    implements TreeWillExpandListener {
        private CollapseRootVeto() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            if (treeExpansionEvent.getPath().getLastPathComponent().equals(CommandViewerHost.this.commandRoot)) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }
    }
}

