/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.displays;

import javax.swing.table.AbstractTableModel;

public class HexTableModel
extends AbstractTableModel {
    int columns = 0;
    byte[] data = null;
    byte[] empty = "File Loading...".getBytes();

    public HexTableModel(int n) {
        this.setColumns(n);
    }

    public int getColumnCount() {
        return this.columns * 2 + 1;
    }

    public int getRowCount() {
        if (this.data == null) {
            return this.empty.length / this.columns + 1;
        }
        return this.data.length / this.columns + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        HexTableModel hexTableModel = this;
        synchronized (hexTableModel) {
            if (n2 == 0) {
                if (this.data != null) {
                    return this.Hexify(Integer.toHexString(n * this.columns), Integer.toHexString(this.data.length).length());
                }
                return this.Hexify(Integer.toHexString(n * this.columns), Integer.toHexString(this.empty.length).length());
            }
            int n3 = n2 - 1;
            int n4 = n3 + n * this.columns;
            if (n2 <= this.columns) {
                if (this.data != null) {
                    if (n4 < this.data.length) {
                        return this.Hexify(Integer.toHexString(this.data[n4]), 2);
                    }
                } else if (n4 < this.empty.length) {
                    return this.Hexify(Integer.toHexString(this.empty[n4]), 2);
                }
                return "";
            }
            n4 = (n3 -= this.columns) + n * this.columns;
            if (n2 < this.columns * 2 + 1) {
                if (this.data != null) {
                    if (n4 < this.data.length) {
                        if (this.data[n4] > 32 && this.data[n4] < 127) {
                            return Character.toString((char)this.data[n4]);
                        }
                        return ".";
                    }
                } else if (n4 < this.empty.length) {
                    if (this.empty[n4] > 32 && this.empty[n4] < 127) {
                        return Character.toString((char)this.empty[n4]);
                    }
                    return ".";
                }
            }
            return "";
        }
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
        this.fireTableDataChanged();
    }

    private String Hexify(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n > string.length()) {
            --n;
            stringBuffer.append('0');
        }
        return stringBuffer.toString() + string.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(int n) {
        HexTableModel hexTableModel = this;
        synchronized (hexTableModel) {
            if (n < 1) {
                this.columns = 1;
                return;
            }
            this.columns = n;
        }
        this.fireTableStructureChanged();
    }

    public int getColumns() {
        return this.columns;
    }

    public int getDataLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }
}

