/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.displays;

import ddb.dsz.plugin.transfermonitor.TransferTabbable;
import ddb.util.FileManips;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class TextDisplay
extends TransferTabbable {
    public TextDisplay(final File file) throws IOException {
        super("Text");
        final JTextArea jTextArea = new JTextArea(20, 60);
        jTextArea.setText("File Loading...");
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        this.display.add(new JScrollPane(jTextArea));
        SwingWorker<String, String> swingWorker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                if (file.length() == 0L) {
                    return "* Empty File *";
                }
                InputStreamReader inputStreamReader = FileManips.createFileReader((File)file);
                int n = 0;
                char[] cArray = new char[128];
                StringBuffer stringBuffer = new StringBuffer();
                while (-1 != (n = inputStreamReader.read(cArray))) {
                    stringBuffer.append(cArray, 0, n);
                }
                return stringBuffer.toString();
            }

            @Override
            protected void done() {
                try {
                    jTextArea.setText((String)this.get());
                }
                catch (Exception exception) {
                    jTextArea.setText("Unable to retrieve file data: " + exception.getMessage());
                }
                jTextArea.setEnabled(true);
                jTextArea.setCaretPosition(0);
            }
        };
        swingWorker.execute();
    }

    public boolean isClosable() {
        return false;
    }
}

