/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.transfermonitor.model;

import ddb.dsz.plugin.transfermonitor.TransferMonitorColumns;
import ddb.dsz.plugin.transfermonitor.model.TransferMonitorModel;
import ddb.dsz.plugin.transfermonitor.model.TransferRecord;
import ddb.dsz.plugin.transfermonitor.model.TransferState;
import ddb.util.TableSorter;
import java.util.Calendar;
import java.util.Comparator;
import javax.swing.table.TableModel;

public class TransferMonitorTableSorter
extends TableSorter {
    private static final Comparator<Calendar> compareCalendars = new Comparator<Calendar>(){

        @Override
        public int compare(Calendar calendar, Calendar calendar2) {
            if (calendar == calendar2) {
                return 0;
            }
            if (calendar == null) {
                return 1;
            }
            if (calendar2 == null) {
                return -1;
            }
            return calendar.compareTo(calendar2);
        }
    };

    public TransferMonitorTableSorter(TableModel tableModel) {
        super(tableModel);
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        if (!(this.model instanceof TransferMonitorModel)) {
            return 0;
        }
        if (n3 == -1) {
            return 0;
        }
        TransferMonitorModel transferMonitorModel = (TransferMonitorModel)this.model;
        TransferRecord transferRecord = transferMonitorModel.getRecord(n);
        TransferRecord transferRecord2 = transferMonitorModel.getRecord(n2);
        if (transferRecord == null && transferRecord2 == null) {
            return 0;
        }
        if (transferRecord == null) {
            return -1;
        }
        if (transferRecord2 == null) {
            return 1;
        }
        switch (TransferMonitorColumns.values()[n3]) {
            case ID: {
                if (transferRecord.getId() == transferRecord2.getId()) {
                    return 0;
                }
                if (transferRecord.getId() < transferRecord2.getId()) {
                    return -1;
                }
                return 1;
            }
            case LOCAL: {
                return transferRecord.getLocal().compareTo(transferRecord2.getLocal());
            }
            case REMOTE: {
                return transferRecord.getRemote().compareTo(transferRecord2.getRemote());
            }
            case SIZE: {
                int n4 = TransferState.COMPARATOR.compare(transferRecord.getState(), transferRecord2.getState());
                if (n4 != 0) {
                    return n4;
                }
                if (transferRecord.getSize().compareTo(0L) == 0 || transferRecord2.getSize().compareTo(0L) == 0) {
                    if (transferRecord.getTransfered() == transferRecord2.getTransfered()) {
                        return 0;
                    }
                    if (transferRecord.getTransfered().compareTo(transferRecord2.getTransfered()) < 0) {
                        return -1;
                    }
                    return 1;
                }
                if (transferRecord.getSize().compareTo(transferRecord.getTransfered()) > 0 || transferRecord2.getSize().compareTo(transferRecord2.getTransfered()) > 0) {
                    if (transferRecord.getSize().compareTo(transferRecord.getTransfered()) <= 0) {
                        return 1;
                    }
                    if (transferRecord2.getSize().compareTo(transferRecord2.getTransfered()) <= 0) {
                        return -1;
                    }
                    if (transferRecord.getTransfered().compareTo(transferRecord2.getTransfered()) > 0) {
                        return 1;
                    }
                    if (transferRecord.getTransfered().compareTo(transferRecord2.getTransfered()) < 0) {
                        return -1;
                    }
                    return 0;
                }
                if (transferRecord.getSize().compareTo(transferRecord2.getSize()) == 0) {
                    return 0;
                }
                if (transferRecord.getSize().compareTo(transferRecord2.getSize()) < 0) {
                    return -1;
                }
                return 1;
            }
            case STATE: {
                return TransferState.COMPARATOR.compare(transferRecord.getState(), transferRecord2.getState());
            }
            case TIME_ACCESSED: {
                return compareCalendars.compare(transferRecord.getAccessed(), transferRecord2.getAccessed());
            }
            case TIME_CREATED: {
                return compareCalendars.compare(transferRecord.getCreated(), transferRecord2.getCreated());
            }
            case TIME_MODIFIED: {
                return compareCalendars.compare(transferRecord.getModified(), transferRecord2.getModified());
            }
        }
        return 0;
    }
}

