/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler;

import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.host.HostInfo;
import ddb.dsz.core.internalcommand.InternalCommandHandler;
import ddb.dsz.core.operation.Operation;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.NoHostAbstractPlugin;
import ddb.dsz.plugin.peer.PeerReceiver;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.requesthandler.RequestInformation;
import ddb.dsz.plugin.requesthandler.closures.ClosureData;
import ddb.dsz.plugin.requesthandler.closures.RequestHandlerClosure;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ExecutionMethodType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.ObjectFactory;
import ddb.dsz.plugin.requesthandler.model.RequestStatus;
import ddb.dsz.plugin.requesthandler.model.RequestTableColumns;
import ddb.dsz.plugin.requesthandler.model.RequestTableModel;
import ddb.dsz.plugin.requesthandler.renderers.DescriptionRenderer;
import ddb.dsz.plugin.requesthandler.renderers.StatusRenderer;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.InternalTranslator;
import ddb.imagemanager.ImageManager;
import ddb.util.Guid;
import ddb.util.JaxbCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestHandler
extends NoHostAbstractPlugin
implements InternalCommandHandler,
PeerReceiver {
    public static final String REQUEST_XML = "Requests/config.xml";
    public static final String EXECMETHODS = "/RequestHandler/execution.xml";
    protected static ObjectFactory objFact = new ObjectFactory();
    private JTable requestTable;
    protected RequestTableModel requests;
    protected ExecutionMethodType execMethod = null;
    protected Closure messageHandler = RequestHandlerClosure.getInstance(this);
    Marshaller marsh;
    Unmarshaller unmarsh;
    protected JPanel mainPanel = new JPanel(new BorderLayout());
    InternalTranslator translator = InternalTranslator.getInstance();
    protected int focusedRow = -1;

    protected final int init2() {
        Object object;
        this.core.addPeerReceiver((PeerReceiver)this);
        try {
            object = JaxbCache.getContext(ObjectFactory.class);
            this.marsh = object.createMarshaller();
            this.unmarsh = object.createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.SEVERE, jAXBException.getMessage(), (Throwable)jAXBException);
            return -1;
        }
        this.requests = new RequestTableModel(this, this.getExecutor(this.core));
        this.requestTable = new JTable((TableModel)((Object)this.requests));
        object = new JScrollPane(this.requestTable);
        this.setWidth(RequestTableColumns.STATUS, true);
        this.requestTable.getTableHeader().setReorderingAllowed(false);
        this.requestTable.setDefaultRenderer(RequestStatus.class, (TableCellRenderer)((Object)new StatusRenderer(this.core)));
        this.requestTable.setDefaultRenderer(RequestedOperation.class, (TableCellRenderer)((Object)new DescriptionRenderer()));
        this.requestTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    int n = RequestHandler.this.requestTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= RequestHandler.this.requests.getRowCount()) {
                        return;
                    }
                    Object object = RequestHandler.this.requests.getValueAt(n, RequestTableColumns.DESCRIPTION);
                    Object object2 = RequestHandler.this.requests.getValueAt(n, RequestTableColumns.STATUS);
                    if (object instanceof RequestedOperation && object2 instanceof RequestStatus) {
                        RequestInformation requestInformation = new RequestInformation((RequestedOperation)RequestedOperation.class.cast(object), RequestHandler.this, RequestHandler.this.core.isLiveOperation(), (RequestStatus)((Object)RequestStatus.class.cast(object2)));
                        requestInformation.setVisible(true);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeDoPopup(mouseEvent);
            }

            private void maybeDoPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    int n = RequestHandler.this.requestTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= RequestHandler.this.requests.getRowCount()) {
                        return;
                    }
                    RequestHandler.this.focusedRow = n;
                    RequestHandler.this.buildMenu().show(RequestHandler.this.requestTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.mainPanel.add((Component)object, "Center");
        super.setDisplay((JComponent)this.mainPanel);
        this.setCanClose(false);
        return this.init3();
    }

    protected int init3() {
        return 0;
    }

    protected final void fini2() {
        this.core.removePeerReceiver((PeerReceiver)this);
        this.fini3();
    }

    protected void fini3() {
    }

    public final CoreController getCoreController() {
        return this.core;
    }

    private void setWidth(RequestTableColumns requestTableColumns, boolean bl) {
        TableColumn tableColumn;
        JLabel jLabel = new JLabel(requestTableColumns.getName() + "   ");
        if (bl) {
            jLabel.setIcon(ImageManager.getIcon((String)super.getLogo(), (Dimension)this.core.getLabelImageSize()));
        }
        if ((tableColumn = this.requestTable.getColumnModel().getColumn(requestTableColumns.ordinal())) != null) {
            tableColumn.setMaxWidth(jLabel.getPreferredSize().width);
            tableColumn.setMinWidth(jLabel.getPreferredSize().width);
        }
    }

    public void cancelledRequest(BigInteger bigInteger, Object object) {
        this.requests.cancelledRequest(bigInteger, object);
    }

    public void deniedRequest(BigInteger bigInteger, Object object) {
        this.requests.deniedRequest(bigInteger);
    }

    public void executedRequest(BigInteger bigInteger, Object object) {
        this.requests.executedRequest(bigInteger);
    }

    public void handleNewRequest(RequestedOperation requestedOperation, PeerTag peerTag) {
        this.requests.addRequest(requestedOperation);
    }

    protected boolean parseArgument2(String string, String string2) {
        if (string.equalsIgnoreCase("max")) {
            try {
                this.requests.setMaximum(Integer.valueOf(string2));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.parseArgument3(string, string2);
    }

    protected boolean parseArgument3(String string, String string2) {
        return false;
    }

    public void handleRequest(RequestedOperation requestedOperation, PeerTag peerTag) {
    }

    public void executeRequest(RequestedOperation requestedOperation) {
    }

    public void handleCancel(BigInteger bigInteger, PeerTag peerTag) {
    }

    protected abstract Closure getExecutor(CoreController var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(JAXBElement<?> jAXBElement, PeerTag peerTag) {
        if (jAXBElement == null) {
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = this.marsh;
            synchronized (marshaller) {
                this.marsh.marshal(jAXBElement, (Writer)stringWriter);
            }
            this.core.sendMessageToPeer(stringWriter.toString(), peerTag);
        }
        catch (JAXBException jAXBException) {
            this.core.logEvent(Level.WARNING, jAXBException.getMessage(), (Throwable)jAXBException);
        }
    }

    public void newConnection(PeerTag peerTag) {
    }

    public void closedConnection(PeerTag peerTag) {
    }

    public void receivedMessage(String string, PeerTag peerTag) {
        this.core.logEvent(Level.FINEST, "Received Message:\r\n" + string);
        try {
            this.messageHandler.execute((Object)new ClosureData(this.unmarsh.unmarshal((Reader)new StringReader(string)), peerTag));
        }
        catch (UnmarshalException unmarshalException) {
            unmarshalException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void sendPong(PeerTag peerTag) {
    }

    protected RequestedOperation generateOperation(List<String> list) {
        return (RequestedOperation)RequestedOperation.class.cast(this.translator.transform(list));
    }

    protected JPopupMenu buildMenu() {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        final ArrayList<RequestedOperation> arrayList = new ArrayList<RequestedOperation>();
        final ArrayList<BigInteger> arrayList2 = new ArrayList<BigInteger>();
        boolean bl = false;
        for (int n : this.requestTable.getSelectedRows()) {
            RequestedOperation requestedOperation = (RequestedOperation)RequestedOperation.class.cast(this.requests.getValueAt(n, RequestTableColumns.DESCRIPTION.ordinal()));
            arrayList.add(requestedOperation);
            arrayList2.add(requestedOperation.getId());
            if (this.requests.getValueAt(n, RequestTableColumns.STATUS.ordinal()) != RequestStatus.PENDING) continue;
            bl = true;
        }
        if (this.allowEnabled() && bl) {
            object = new JMenuItem("Approve");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (BigInteger bigInteger : arrayList2) {
                        RequestHandler.this.approve(bigInteger);
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object);
            if (arrayList.size() == 1) {
                List list;
                JMenu jMenu = new JMenu("Approve As");
                HostInfo hostInfo = this.core.getHostById(((RequestedOperation)arrayList.get(0)).getData("host"));
                if (hostInfo != null && (list = this.core.getUserAliases(hostInfo)).size() > 0) {
                    jPopupMenu.add(jMenu);
                    for (final String string : list) {
                        JMenuItem jMenuItem = new JMenuItem(string);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                for (RequestedOperation requestedOperation : arrayList) {
                                    requestedOperation.setData("useralias", string);
                                    RequestHandler.this.approve(requestedOperation.getId());
                                }
                            }
                        });
                        jMenu.add(jMenuItem);
                    }
                }
            }
        }
        if (this.forceEnabled()) {
            object = new JMenuItem("Start now");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (BigInteger bigInteger : arrayList2) {
                        RequestHandler.this.force(bigInteger);
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        object = new JMenuItem(this.getCancelName());
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (BigInteger bigInteger : arrayList2) {
                    RequestHandler.this.cancel(bigInteger);
                }
            }
        });
        jPopupMenu.add((JMenuItem)object);
        return jPopupMenu;
    }

    public boolean allowNewInstance(Class<?> clazz) {
        if (!super.allowNewInstance(clazz)) {
            return false;
        }
        return !RequestHandler.class.isAssignableFrom(clazz);
    }

    protected abstract String getCancelName();

    protected boolean allowEnabled() {
        return false;
    }

    protected boolean forceEnabled() {
        return false;
    }

    protected void approve(BigInteger bigInteger) {
    }

    protected void force(BigInteger bigInteger) {
    }

    public void sendData(PeerTag peerTag, Guid guid, BigInteger bigInteger, boolean bl) {
    }

    protected abstract void cancel(BigInteger var1);

    public void fireExecutedRequest() {
    }

    public void fireDeniedRequest() {
    }

    public void fireCancelledRequest() {
    }

    public void fireNewRequest() {
    }

    public void fireUpdatedRequest() {
    }

    public void requestData(TaskId taskId) {
    }

    public Operation getOperationById(BigInteger bigInteger) {
        return this.core.getOperationById(bigInteger);
    }

    public Operation getOperationById(Guid guid) {
        return this.core.getOperationById(guid);
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

