/*
 * Decompiled with CFR 0.152.
 */
package ddb.dsz.plugin.requesthandler;

import ddb.dsz.annotations.DszDescription;
import ddb.dsz.annotations.DszLive;
import ddb.dsz.annotations.DszLogo;
import ddb.dsz.annotations.DszName;
import ddb.dsz.core.controller.CoreController;
import ddb.dsz.core.internalcommand.InternalCommandCallback;
import ddb.dsz.core.task.TaskId;
import ddb.dsz.plugin.peer.PeerTag;
import ddb.dsz.plugin.requesthandler.RequestHandler;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.RequestType;
import ddb.dsz.plugin.requesthandler.jaxb.requesthandlercomms.TaskDataRequestType;
import ddb.dsz.plugin.requesthandler.model.RequestTableModel;
import ddb.dsz.plugin.requesthandler.requests.RequestedOperation;
import ddb.dsz.plugin.requesthandler.tranformers.CancelRequest;
import ddb.dsz.plugin.requesthandler.tranformers.RecordEntryToRequest;
import ddb.dsz.plugin.requesthandler.tranformers.RequestedOperationToRequestType;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ClosureUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DszLive(live=true, replay=true)
@DszLogo(value="images/antivirus.png")
@DszName(value="Request Sender")
@DszDescription(value="Handles all things request related")
public class RequestSender
extends RequestHandler {
    PeerTag connectedTo = null;
    private static final String NOT_CONNECTED = "Not connected:  Requests will be queued for submission";
    private static final String CONNECTED = "Connect:  Requests will be sent to peer";

    public RequestSender() {
        super.setName("Request Sender");
        this.prefferedSize = new Dimension(550, 200);
        super.setCareAboutLocalEvents(true);
    }

    @Override
    protected int init3() {
        this.setStatus(NOT_CONNECTED);
        return 0;
    }

    @Override
    protected void fini3() {
    }

    public boolean runInternalCommand(List<String> list, InternalCommandCallback internalCommandCallback) {
        RequestedOperation requestedOperation = this.generateOperation(list);
        if (requestedOperation != null) {
            if (internalCommandCallback != null) {
                internalCommandCallback.taskingRecieved(list, null);
                requestedOperation.setCallback(internalCommandCallback);
            }
            if (this.connectedTo != null) {
                super.publish(RequestedOperationToRequestType.getInstance().transform(requestedOperation), null);
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : list) {
                    stringBuilder.append(string + "\r\n");
                }
                this.core.logEvent(Level.FINEST, "Received Message:\r\n" + stringBuilder.toString());
                return true;
            }
            this.requests.addRequest(requestedOperation);
            return true;
        }
        return false;
    }

    @Override
    protected Closure getExecutor(CoreController coreController) {
        return ClosureUtils.nopClosure();
    }

    @Override
    protected String getCancelName() {
        return "Cancel";
    }

    @Override
    protected void cancel(BigInteger bigInteger) {
        super.publish(CancelRequest.getInstance().transform(bigInteger), null);
    }

    @Override
    public void fireDeniedRequest() {
        super.contentsChanged();
    }

    @Override
    public void closedConnection(PeerTag peerTag) {
        if (peerTag.equals(this.connectedTo)) {
            this.connectedTo = null;
            this.requests.purge();
        }
        this.setStatus(NOT_CONNECTED);
    }

    @Override
    public void newConnection(PeerTag peerTag) {
        this.connectedTo = peerTag;
        final List<RequestTableModel.RecordEntry> list = this.requests.getPending();
        this.core.schedule(new Runnable(){

            public void run() {
                try {
                    for (RequestTableModel.RecordEntry recordEntry : list) {
                        RequestSender.super.publish(RecordEntryToRequest.getInstance().transform(recordEntry), null);
                        RequestSender.this.requests.removeRequest(recordEntry);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }, 5L, TimeUnit.SECONDS);
        this.setStatus(CONNECTED);
    }

    @Override
    public void requestData(TaskId taskId) {
        RequestType requestType = new RequestType();
        TaskDataRequestType taskDataRequestType = new TaskDataRequestType();
        taskDataRequestType.setIncludeChildren(true);
        taskDataRequestType.setOperation(taskId.getOperation().getGuid().toString());
        taskDataRequestType.setTaskId(BigInteger.valueOf(taskId.getId()));
        requestType.setTaskDataRequest(taskDataRequestType);
        this.publish(objFact.createRequest(requestType), null);
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName("ds.plugin.live.DSClientApp");
        Class<?> clazz2 = Class.forName("ds.plugin.replay.OpReplayDriver");
        Method method = clazz2.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }
}

