/*
 * Decompiled with CFR 0.152.
 */
package pcremoteconfiguration.autocomplete;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import pcremoteconfiguration.autocomplete.CompletionService;

public class AutoCompleteDocument
extends PlainDocument {
    private CompletionService<?> completionService;
    private JTextComponent documentOwner;

    public AutoCompleteDocument(CompletionService<?> service, JTextComponent documentOwner) {
        this.completionService = service;
        this.documentOwner = documentOwner;
    }

    protected String complete(String str) {
        Object o = this.completionService.autoComplete(str);
        return o == null ? null : o.toString();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        String text = this.getText(0, offs);
        String completion = this.complete(text + str);
        int length = offs + str.length();
        if (completion != null && text.length() > 0) {
            str = completion.substring(Math.max(0, length - 1));
            super.insertString(offs, str, a);
            this.documentOwner.select(length, this.getLength());
        } else {
            super.insertString(offs, str, a);
        }
    }
}

