/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.bcb.BreadcrumbBar;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.BreadcrumbItemChoices;
import org.jvnet.flamingo.bcb.ScrollablePopup;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbParticle;
import org.jvnet.flamingo.bcb.ui.ChoicesSelector;

public class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    protected BreadcrumbBar breadcrumbBar;
    protected JLabel iconLabel;
    protected JPanel mainPanel;
    protected ScrollablePanel scrollerPanel;
    protected ComponentListener componentListener;
    protected int popupInitiatorIndex;
    private JPopupMenu popup = null;
    private Map<Object, Component> comps = new HashMap<Object, Component>();

    public static ComponentUI createUI(JComponent c) {
        return new BasicBreadcrumbBarUI();
    }

    public void installUI(JComponent c) {
        this.breadcrumbBar = (BreadcrumbBar)c;
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        c.setLayout(this.createLayoutManager());
        this.popupInitiatorIndex = -1;
    }

    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((BreadcrumbBar)c);
        this.uninstallComponents((BreadcrumbBar)c);
        this.uninstallDefaults((BreadcrumbBar)c);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(BreadcrumbBar bar) {
        bar.setFont(new Font("dialog", 0, 12));
    }

    protected void installComponents(BreadcrumbBar bar) {
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new ScrollablePanel(this.mainPanel);
        bar.add((Component)this.scrollerPanel, "Center");
        Icon barIcon = bar.getIcon();
        if (barIcon != null) {
            this.iconLabel = new JLabel(barIcon);
            this.iconLabel.setOpaque(false);
            bar.add((Component)this.iconLabel, "West");
        }
        if (bar.getOkButton() != null) {
            bar.add((Component)bar.getOkButton(), "East");
        }
    }

    protected void installListeners(BreadcrumbBar bar) {
        this.componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        bar.addComponentListener(this.componentListener);
    }

    protected void uninstallDefaults(BreadcrumbBar bar) {
    }

    protected void uninstallComponents(BreadcrumbBar bar) {
        if (this.iconLabel != null) {
            bar.remove(this.iconLabel);
            this.iconLabel = null;
        }
        this.mainPanel.removeAll();
        this.comps.clear();
        bar.remove(this.scrollerPanel);
        if (bar.getOkButton() != null) {
            bar.remove(bar.getOkButton());
        }
    }

    protected void uninstallListeners(BreadcrumbBar bar) {
        bar.removeComponentListener(this.componentListener);
        this.componentListener = null;
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    public JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new ScrollablePopup(15);
            this.popup.setFont(this.breadcrumbBar.getFont());
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    BasicBreadcrumbBarUI.this.popupInitiatorIndex = -1;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }
            });
        }
        return this.popup;
    }

    public void hidePopup() {
        this.getPopup().setVisible(false);
    }

    public int updateComponents() {
        if (this.breadcrumbBar.getStack() == null) {
            return 0;
        }
        if (!this.breadcrumbBar.isVisible()) {
            return 0;
        }
        this.mainPanel.removeAll();
        this.comps.clear();
        this.scrollerPanel.removeScrollers();
        int width = 0;
        JComponent c = null;
        for (Object element : this.breadcrumbBar.getStack()) {
            if (element instanceof BreadcrumbItemChoices) {
                BreadcrumbItemChoices bic = (BreadcrumbItemChoices)element;
                c = new ChoicesSelector(this.breadcrumbBar, bic, this.breadcrumbBar.getSeparator());
                this.comps.put(bic, c);
            } else if (element instanceof BreadcrumbItem) {
                BreadcrumbItem bi = (BreadcrumbItem)element;
                c = new BreadcrumbParticle(this.breadcrumbBar, bi, this.breadcrumbBar.getFontMetrics(this.breadcrumbBar.getFont()).stringWidth(bi.getName()));
                this.comps.put(bi, c);
            }
            width = (int)((double)width + c.getPreferredSize().getWidth());
            this.mainPanel.add(c);
        }
        this.scrollerPanel.validateScrolling(width);
        this.mainPanel.validate();
        this.mainPanel.repaint();
        if (c != null && this.breadcrumbBar.getStack().lastElement() instanceof BreadcrumbItem) {
            c.requestFocus();
        }
        return width;
    }

    public boolean popup(int componentIndex) {
        if (componentIndex < 0 || componentIndex >= this.mainPanel.getComponentCount()) {
            return false;
        }
        Component c = this.mainPanel.getComponent(componentIndex);
        if (c != null && c instanceof ChoicesSelector) {
            ChoicesSelector selector = (ChoicesSelector)c;
            return this.showPopup(selector.getIndex(), selector.getBreadcrumbChoices());
        }
        return false;
    }

    public boolean showPopup(int selectorIndex, BreadcrumbItemChoices bic) {
        BreadcrumbItem c;
        JPopupMenu popup = this.getPopup();
        this.popupInitiatorIndex = selectorIndex;
        popup.removeAll();
        JLabel toSelect = null;
        for (int i = 0; i < bic.getChoices().length; ++i) {
            BreadcrumbItem bi = bic.getChoices()[i];
            PopupAction action = new PopupAction(bi, bic.getIndex());
            JMenuItem item = popup.add(action);
            if (item == null) continue;
            item.setFont(this.breadcrumbBar.getFont());
            popup.setBackground(item.getBackground());
            item.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (this.breadcrumbBar.getItemCount() > bic.getIndex() + 1 && (c = this.breadcrumbBar.getItem(bic.getIndex() + 1)) != null && c instanceof BreadcrumbItem) {
            toSelect = new JLabel(c.getName());
        }
        if (bic.getChoices().length > 0) {
            popup.show(this.comps.get(bic), 0, this.comps.get(bic).getHeight());
            if (toSelect != null) {
                popup.setSelected(toSelect);
            }
            return true;
        }
        this.popupInitiatorIndex = -1;
        return false;
    }

    public BreadcrumbParticle getParticle(int selectorIndex) {
        if (selectorIndex == 0 || selectorIndex - 1 >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component c = this.mainPanel.getComponent(selectorIndex);
        if (c != null && c instanceof ChoicesSelector) {
            return (BreadcrumbParticle)this.mainPanel.getComponent(selectorIndex - 1);
        }
        return null;
    }

    public ChoicesSelector getSelector(int selectorIndex) {
        if (selectorIndex == 0 || selectorIndex - 1 >= this.mainPanel.getComponentCount()) {
            return null;
        }
        Component c = this.mainPanel.getComponent(selectorIndex);
        if (c != null && c instanceof ChoicesSelector) {
            return (ChoicesSelector)c;
        }
        return null;
    }

    protected JButton createScrollingButton() {
        JButton b = new JButton();
        b.setBorder(BorderFactory.createEmptyBorder());
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setPreferredSize(new Dimension(13, 14));
        b.setCursor(Cursor.getPredefinedCursor(12));
        return b;
    }

    protected JButton getLeftScroller() {
        JButton scroller = this.createScrollingButton();
        scroller.setText("<");
        return scroller;
    }

    protected JButton getRightScroller() {
        JButton scroller = this.createScrollingButton();
        scroller.setText(">");
        return scroller;
    }

    public int getPopupInitiatorIndex() {
        return this.popupInitiatorIndex;
    }

    private class PopupAction
    extends AbstractAction {
        private static final String BreadCrumbItem_Key = "BreadCrumbItem";
        private static final String ParentIndex_Key = "ParentIndex";

        public PopupAction(BreadcrumbItem bi, int parentIndex) {
            super(bi.getName(), bi.getIcon());
            this.putValue(BreadCrumbItem_Key, bi);
            this.putValue(ParentIndex_Key, new Integer(parentIndex));
        }

        public void actionPerformed(ActionEvent e) {
            BreadcrumbItem bi = (BreadcrumbItem)this.getValue(BreadCrumbItem_Key);
            if (bi == null) {
                return;
            }
            int index = (Integer)this.getValue(ParentIndex_Key);
            while (BasicBreadcrumbBarUI.this.breadcrumbBar.getItemCount() > index + 1) {
                BasicBreadcrumbBarUI.this.breadcrumbBar.pop();
            }
            BasicBreadcrumbBarUI.this.breadcrumbBar.pushChoice(bi, false);
            BreadcrumbItemChoices bic = BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getChoices(BasicBreadcrumbBarUI.this.breadcrumbBar.getPath());
            if (bic != null) {
                BasicBreadcrumbBarUI.this.breadcrumbBar.pushChoices(bic, false);
            }
            BasicBreadcrumbBarUI.this.updateComponents();
        }
    }

    protected class ScrollablePanelLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(c.getWidth(), 21);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int sph;
            int spw;
            int width = c.getWidth();
            int height = c.getHeight();
            ScrollablePanel sPanel = BasicBreadcrumbBarUI.this.scrollerPanel;
            boolean isScrollerButtonsShowing = sPanel.leftScroller.getParent() == BasicBreadcrumbBarUI.this.scrollerPanel;
            int scrollPanelWidth = isScrollerButtonsShowing ? width - ((ScrollablePanel)sPanel).leftScroller.getPreferredSize().width - ((ScrollablePanel)sPanel).rightScroller.getPreferredSize().width : width;
            int x = 0;
            if (isScrollerButtonsShowing) {
                spw = ((ScrollablePanel)sPanel).leftScroller.getPreferredSize().width;
                sph = ((ScrollablePanel)sPanel).leftScroller.getPreferredSize().height;
                sPanel.leftScroller.setBounds(0, (height - sph) / 2, spw, sph);
                x += spw;
            }
            sPanel.scrollPane.setBounds(x, 0, scrollPanelWidth, height);
            x += scrollPanelWidth;
            if (isScrollerButtonsShowing) {
                spw = ((ScrollablePanel)sPanel).rightScroller.getPreferredSize().width;
                sph = ((ScrollablePanel)sPanel).rightScroller.getPreferredSize().height;
                sPanel.rightScroller.setBounds(x, (height - sph) / 2, spw, sph);
            }
        }
    }

    public class ScrollablePanel
    extends JPanel {
        private JButton leftScroller;
        private JButton rightScroller;
        private JScrollPane scrollPane;
        private JComponent view = null;
        private MouseListener scrollMouseListener = null;
        private int widthToScrollTo = 0;

        public ScrollablePanel(JComponent c) {
            this.view = c;
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            this.scrollPane.setOpaque(false);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setAutoscrolls(false);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setViewportView(c);
            this.setOpaque(false);
            this.add(this.scrollPane);
            this.leftScroller = BasicBreadcrumbBarUI.this.getLeftScroller();
            this.leftScroller.setName("leftScroller");
            this.leftScroller.addMouseListener(this.getScrollerMouseListener());
            this.rightScroller = BasicBreadcrumbBarUI.this.getRightScroller();
            this.rightScroller.setName("rightScroller");
            this.rightScroller.addMouseListener(this.getScrollerMouseListener());
            this.setLayout(new ScrollablePanelLayout());
        }

        public void increaseWidthBy(int increaseBy) {
            this.validateScrolling(this.widthToScrollTo + increaseBy);
        }

        public void validateScrolling(int width) {
            this.widthToScrollTo = width;
            int visibleWidth = this.view.getVisibleRect().width - 4;
            if (visibleWidth > 0 && visibleWidth < this.widthToScrollTo) {
                int x;
                if (this.getComponentCount() <= 1) {
                    this.addScrollers();
                    x = this.widthToScrollTo + this.leftScroller.getWidth() + this.rightScroller.getWidth() - 4;
                } else {
                    x = this.widthToScrollTo - 4;
                }
                this.view.scrollRectToVisible(new Rectangle(x, 0, 4, 4));
            } else {
                this.removeScrollers();
            }
        }

        public void removeScrollers() {
            this.view.scrollRectToVisible(new Rectangle(0, 0, 2, 2));
            this.remove(this.leftScroller);
            this.remove(this.rightScroller);
            this.revalidate();
            this.repaint();
        }

        private void addScrollers() {
            this.add((Component)this.leftScroller, "West");
            this.add((Component)this.rightScroller, "East");
            this.revalidate();
            this.repaint();
        }

        public MouseListener getScrollerMouseListener() {
            if (this.scrollMouseListener == null) {
                this.scrollMouseListener = new MouseAdapter(){
                    private boolean isPressed = false;

                    public void mousePressed(MouseEvent e) {
                        this.isPressed = true;
                        final boolean left = ((JComponent)e.getSource()).getName().startsWith("left");
                        Thread scroller = new Thread(){

                            public void run() {
                                double x;
                                int scrollBy = 12;
                                int i = 0;
                                while (isPressed && !((x = left ? ScrollablePanel.this.view.getVisibleRect().getX() - (double)scrollBy : ScrollablePanel.this.view.getVisibleRect().getX() + ScrollablePanel.this.view.getVisibleRect().getWidth()) > (double)ScrollablePanel.this.widthToScrollTo)) {
                                    Rectangle rect = new Rectangle((int)x, 0, scrollBy, 8);
                                    ScrollablePanel.this.view.scrollRectToVisible(rect);
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                    if (i > 2) {
                                        scrollBy += 5;
                                    }
                                    ++i;
                                    Thread.yield();
                                }
                            }
                        };
                        scroller.start();
                    }

                    public void mouseReleased(MouseEvent e) {
                        this.isPressed = false;
                    }
                };
            }
            return this.scrollMouseListener;
        }
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(c.getWidth(), 21);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            BreadcrumbBar bar = BasicBreadcrumbBarUI.this.breadcrumbBar;
            int x = 0;
            if (BasicBreadcrumbBarUI.this.iconLabel != null) {
                int ipw = BasicBreadcrumbBarUI.this.iconLabel.getPreferredSize().width;
                BasicBreadcrumbBarUI.this.iconLabel.setBounds(x, 0, ipw, height);
                x += ipw;
            }
            int rx = width;
            JButton okButton = bar.getOkButton();
            if (okButton != null) {
                int opw = okButton.getPreferredSize().width;
                okButton.setBounds(width - opw, 0, opw, height);
                rx -= opw;
            }
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(x, 0, rx - x, height);
        }
    }
}

