/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jvnet.flamingo.wizard.WizardImageCreator;

public final class ProgressGlassPane
extends JPanel {
    private Color darkColor = new Color(12, 12, 96);
    private Color midColor = new Color(64, 64, 255);
    private Color lightColor = new Color(96, 128, 255);
    private GlassPaneThread animator;
    private int currHighLightRow;
    private static final int HIGHLIGHT_ROW_SPAN = 20;
    private final JRootPane owner;
    private BufferedImage oddLine;
    private BufferedImage evenLine;
    private BufferedImage oddDarkLine;
    private BufferedImage evenDarkLine;
    private String message;
    private final Font messageFont;

    public ProgressGlassPane(JRootPane owner) {
        this.owner = owner;
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.setOpaque(false);
        this.messageFont = new Font("Arial", 0, 20);
    }

    public final synchronized void setMessage(String message) {
        this.message = message;
    }

    public void paint(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setComposite(AlphaComposite.getInstance(3, 0.9f));
        int width = this.owner.getWidth();
        int height = this.owner.getHeight();
        if (this.oddLine == null) {
            this.oddLine = WizardImageCreator.createGradientLine(width, this.lightColor, this.darkColor, 0.6);
            this.evenLine = WizardImageCreator.createGradientLine(width, this.lightColor.brighter(), this.midColor, 0.6);
            this.oddDarkLine = WizardImageCreator.createGradientLine(width, this.darkColor, Color.black, 0.8);
            this.evenDarkLine = WizardImageCreator.createGradientLine(width, this.midColor, this.darkColor.darker(), 0.8);
        }
        for (int row = 0; row < height; ++row) {
            if (row % 2 == 0) {
                graphics.drawImage((Image)this.evenLine, 0, row, null);
                continue;
            }
            graphics.drawImage((Image)this.oddLine, 0, row, null);
        }
        int rowStart = Math.max(0, this.currHighLightRow - 20);
        int rowEnd = Math.min(height - 1, this.currHighLightRow + 20);
        for (int row = rowStart; row <= rowEnd; ++row) {
            if (row % 2 == 1) continue;
            float opacity = (float)(0.25 * (1.0 - (double)(Math.abs((float)(row - this.currHighLightRow)) / 20.0f)));
            opacity = Math.max(0.0f, opacity);
            opacity = Math.min(1.0f, opacity);
            AlphaComposite c = AlphaComposite.getInstance(3, opacity);
            graphics.setComposite(c);
            graphics.setColor(Color.white);
            graphics.drawLine(0, row, width, row);
        }
        if (this.message != null) {
            graphics.setFont(this.messageFont);
            FontRenderContext frc = graphics.getFontRenderContext();
            TextLayout mLayout = new TextLayout(this.message, this.messageFont, frc);
            int mWidth = (int)mLayout.getBounds().getWidth();
            int mHeight = (int)mLayout.getBounds().getHeight();
            rowStart = height - mHeight - 20;
            rowEnd = rowStart + mHeight + 5;
            int colStart = (width - mWidth) / 2 - 10;
            AlphaComposite c = AlphaComposite.getInstance(3, 1.0f);
            graphics.setComposite(c);
            for (int row = rowStart; row <= rowEnd; ++row) {
                if (row % 2 == 0) {
                    graphics.drawImage((Image)this.evenDarkLine, 0, row, null);
                    continue;
                }
                graphics.drawImage((Image)this.oddDarkLine, 0, row, null);
            }
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setColor(this.darkColor.darker());
            graphics.drawString(this.message, colStart + 11, rowEnd - 4);
            graphics.setColor(this.lightColor.brighter());
            graphics.drawString(this.message, colStart + 10, rowEnd - 5);
        }
    }

    public final void setVisible(boolean isVisible) {
        if (isVisible) {
            this.currHighLightRow = -20;
            this.animator = new GlassPaneThread(this, 20);
            this.animator.start();
        } else if (this.animator != null) {
            this.animator.markStopped();
            this.animator = null;
        }
        super.setVisible(isVisible);
    }

    public final void iteration() {
        if (this.owner == null) {
            return;
        }
        if (this.owner.getTopLevelAncestor() == null) {
            return;
        }
        if (!this.owner.getTopLevelAncestor().isVisible()) {
            return;
        }
        if (this.animator == null || this.animator.isMarkedStopped()) {
            return;
        }
        this.currHighLightRow += 5;
        if (this.currHighLightRow > this.getHeight() + 20) {
            this.currHighLightRow = -20;
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void setGlassPaneColors(Color darkColor, Color midColor, Color lightColor) {
        this.darkColor = darkColor;
        this.midColor = midColor;
        this.lightColor = lightColor;
    }

    private static final class GlassPaneThread
    extends Thread {
        private final int sleepTime;
        private boolean toStop;
        private final ProgressGlassPane glassPane;

        public GlassPaneThread(ProgressGlassPane glassPane, int sleepTime) {
            this.glassPane = glassPane;
            this.sleepTime = sleepTime;
        }

        public final synchronized void markStopped() {
            this.toStop = true;
        }

        public final synchronized boolean isMarkedStopped() {
            return this.toStop;
        }

        public final void run() {
            this.toStop = false;
            while (!this.isMarkedStopped()) {
                this.glassPane.iteration();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

