/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jvnet.flamingo.common.ResizableIcon;

public class StackIcon
implements ResizableIcon {
    protected ResizableIcon delegate;
    protected double marginThickness;
    protected int marginX;
    protected int marginY;

    public StackIcon(ResizableIcon delegate, double marginThickness) {
        this.delegate = delegate;
        this.marginThickness = marginThickness;
        this.setHeight(delegate.getIconHeight());
        this.setWidth(delegate.getIconWidth());
    }

    public int getIconHeight() {
        return (int)((1.0 + 2.0 * this.marginThickness) * (double)this.delegate.getIconHeight());
    }

    public int getIconWidth() {
        return (int)((1.0 + 2.0 * this.marginThickness) * (double)this.delegate.getIconWidth());
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rect = new Rectangle(x + this.marginX / 2, y + this.marginY / 2, this.delegate.getIconWidth() + this.marginX, this.delegate.getIconHeight() + this.marginY);
        int rx = x + this.marginX + this.delegate.getIconWidth() / 2;
        int ry = y + this.marginY + this.delegate.getIconHeight() / 2;
        this.paintFrame(graphics, this.rotateRect(rect, rx - 2, ry, -8.0));
        this.paintFrame(graphics, this.rotateRect(rect, rx, ry + 2, 5.0));
        this.paintFrame(graphics, rect);
        graphics.dispose();
        this.delegate.paintIcon(c, g, 1 + x + this.marginX, 1 + y + this.marginY);
    }

    protected Point2D rotatePoint(int x, int y, int rx, int ry, double theta) {
        double st = Math.sin(Math.PI * theta / 180.0);
        double ct = Math.cos(Math.PI * theta / 180.0);
        return new Point2D.Double((double)rx + (double)(x - rx) * ct - (double)(y - ry) * st, (double)ry + (double)(y - ry) * ct + (double)(x - rx) * st);
    }

    protected GeneralPath rotateRect(Rectangle rect, int rx, int ry, double theta) {
        GeneralPath res = new GeneralPath();
        Point2D p1 = this.rotatePoint(rect.x, rect.y, rx, ry, theta);
        Point2D p2 = this.rotatePoint(rect.x + rect.width, rect.y, rx, ry, theta);
        Point2D p3 = this.rotatePoint(rect.x + rect.width, rect.y + rect.height, rx, ry, theta);
        Point2D p4 = this.rotatePoint(rect.x, rect.y + rect.height, rx, ry, theta);
        res.moveTo((float)p1.getX(), (float)p1.getY());
        res.lineTo((float)p2.getX(), (float)p2.getY());
        res.lineTo((float)p3.getX(), (float)p3.getY());
        res.lineTo((float)p4.getX(), (float)p4.getY());
        res.lineTo((float)p1.getX(), (float)p1.getY());
        return res;
    }

    protected void paintFrame(Graphics2D graphics, Shape shape) {
        graphics.setStroke(new BasicStroke(0.8f));
        graphics.setColor(Color.white);
        graphics.fill(shape);
        graphics.setColor(Color.darkGray);
        graphics.draw(shape);
    }

    public void setDimension(Dimension newDimension) {
        this.delegate.setWidth(newDimension.width);
        this.delegate.setHeight(newDimension.height);
    }

    public void setHeight(int height) {
        int newHeight = (int)((double)height / (1.0 + 2.0 * this.marginThickness));
        if ((height - newHeight) % 2 == 1) {
            --newHeight;
        }
        this.delegate.setHeight(newHeight);
        this.marginY = (height - this.delegate.getIconHeight()) / 2;
    }

    public void setWidth(int width) {
        int newWidth = (int)((double)width / (1.0 + 2.0 * this.marginThickness));
        if ((width - newWidth) % 2 == 1) {
            --newWidth;
        }
        this.delegate.setWidth(newWidth);
        this.marginX = (width - this.delegate.getIconWidth()) / 2;
    }

    public void revertToOriginalDimension() {
        this.delegate.revertToOriginalDimension();
        this.setWidth(this.delegate.getIconWidth());
        this.setHeight(this.delegate.getIconHeight());
    }
}

