/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.gutter;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.jvnet.flamingo.ide.BaseViewerPanel;
import org.jvnet.flamingo.ide.info.FileInfo;
import org.jvnet.flamingo.ide.util.Util;

public abstract class GutterPanel
extends JComponent {
    public static final int WIDTH = 12;
    public static Color BACKGROUND_COLOR;
    protected final BaseViewerPanel viewerPanel;
    protected final Map<FileInfo.LineInfo, Rectangle> marks;

    public static void updateDefaultBackgroundColor() {
        UIDefaults uidefs = UIManager.getLookAndFeelDefaults();
        ColorUIResource backgrResource = (ColorUIResource)uidefs.get("TabbedPane.selected");
        BACKGROUND_COLOR = backgrResource != null ? backgrResource : new Color(214, 214, 214);
    }

    public GutterPanel(BaseViewerPanel viewerPanel) {
        this.viewerPanel = viewerPanel;
        this.marks = new HashMap<FileInfo.LineInfo, Rectangle>();
        this.addMouseMotionListener(new GutterMouseMotionListener(this));
    }

    protected void paintComponent(Graphics g) {
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void refreshView() {
    }

    static {
        GutterPanel.updateDefaultBackgroundColor();
    }

    private static final class GutterMouseMotionListener
    extends MouseMotionAdapter {
        private final GutterPanel gutter;

        public GutterMouseMotionListener(GutterPanel gutter) {
            this.gutter = gutter;
        }

        public final void mouseMoved(MouseEvent e) {
            Point mouseLocation = e.getPoint();
            for (Map.Entry<FileInfo.LineInfo, Rectangle> marker : this.gutter.marks.entrySet()) {
                Rectangle rect = marker.getValue();
                if (rect.contains(mouseLocation)) {
                    this.gutter.setCursor(Cursor.getPredefinedCursor(12));
                    this.gutter.setToolTipText(Util.getTooltipText(marker.getKey()));
                    break;
                }
                this.gutter.setCursor(Cursor.getPredefinedCursor(0));
                this.gutter.setToolTipText(null);
            }
        }
    }
}

