/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.info;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jvnet.flamingo.ide.info.ElementLocationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLocationInfo {
    private int minLine;
    private int maxLine;
    private List<ElementLocationInfo> allElements = new LinkedList<ElementLocationInfo>();
    private Map<Integer, List<ElementLocationInfo>> lineMapping = new HashMap<Integer, List<ElementLocationInfo>>();
    private String[] lines = null;

    public FileLocationInfo() {
        this.minLine = Integer.MAX_VALUE;
        this.maxLine = Integer.MIN_VALUE;
    }

    private void addToLine(int lineNumber, ElementLocationInfo info) {
        if (!this.lineMapping.containsKey(lineNumber)) {
            this.lineMapping.put(lineNumber, new LinkedList());
        }
        this.lineMapping.get(lineNumber).add(info);
        this.minLine = Math.min(this.minLine, lineNumber);
        this.maxLine = Math.max(this.maxLine, lineNumber);
    }

    public synchronized void addElementInfo(ElementLocationInfo info) {
        this.allElements.add(info);
        for (int line = info.getRange().getLineStart(); line <= info.getRange().getLineEnd(); ++line) {
            this.addToLine(line, info);
        }
    }

    public void addElementInfo(List<ElementLocationInfo> infoList) {
        for (ElementLocationInfo info : infoList) {
            this.addElementInfo(info);
        }
    }

    public List<ElementLocationInfo> getLineElements(int lineNumber) {
        return this.lineMapping.get(lineNumber);
    }

    public Iterable<ElementLocationInfo> getAllElements() {
        return this.allElements;
    }

    public ElementLocationInfo getElement(int lineNumber, int column) {
        List<ElementLocationInfo> lineElem = this.getLineElements(lineNumber);
        if (lineElem == null) {
            return null;
        }
        for (ElementLocationInfo elem : lineElem) {
            if (!elem.getRange().isInside(lineNumber, column)) continue;
            return elem;
        }
        return null;
    }

    public int getMinLine() {
        return this.minLine;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public String[] getLines() {
        return this.lines;
    }

    public void setLines(String[] lines) {
        this.lines = lines;
    }
}

