/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.java.jparser;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.flamingo.ide.LocationParser;
import org.jvnet.flamingo.ide.info.ElementLocationInfo;
import org.jvnet.flamingo.ide.info.ElementRange;
import org.jvnet.flamingo.ide.java.jparser.JavaElementLocationInfo;
import org.jvnet.flamingo.ide.java.jparser.JavaFileLocationInfo;
import org.jvnet.flamingo.ide.java.jparser.gen.JavaParser;
import org.jvnet.flamingo.ide.java.jparser.gen.Token;

public class JavaLocationParser
implements LocationParser {
    private JavaFileLocationInfo fileLocationInfo;

    public void dump() {
        int minLine = this.fileLocationInfo.getMinLine();
        int maxLine = this.fileLocationInfo.getMaxLine();
        for (int line = minLine; line <= maxLine; ++line) {
            List<ElementLocationInfo> jeiList = this.fileLocationInfo.getLineElements(line);
            if (jeiList == null) continue;
            System.out.println("Line " + line);
            for (ElementLocationInfo ei : jeiList) {
                JavaElementLocationInfo jei = (JavaElementLocationInfo)ei;
                System.out.println("   (" + jei.getElementKind() + ") " + jei.getRange().toString() + " '" + jei.getElementImage());
            }
        }
    }

    public JavaFileLocationInfo getFileLocationInfo(InputStream stream) {
        this.fileLocationInfo = new JavaFileLocationInfo();
        try {
            JavaParser parser = new JavaParser(stream);
            Token currToken = parser.getNextToken();
            while (currToken.kind != 0) {
                JavaElementLocationInfo jei;
                Token specToken = currToken.specialToken;
                LinkedList<JavaElementLocationInfo> specialTokens = new LinkedList<JavaElementLocationInfo>();
                while (specToken != null) {
                    jei = new JavaElementLocationInfo(specToken.kind, specToken.image, new ElementRange(specToken.beginLine - 1, specToken.beginColumn - 1, specToken.endLine - 1, specToken.endColumn - 1));
                    specialTokens.addFirst(jei);
                    specToken = specToken.specialToken;
                }
                for (JavaElementLocationInfo jei2 : specialTokens) {
                    this.fileLocationInfo.addElementInfo(jei2);
                }
                jei = new JavaElementLocationInfo(currToken.kind, currToken.image, new ElementRange(currToken.beginLine - 1, currToken.beginColumn - 1, currToken.endLine - 1, currToken.endColumn - 1));
                this.fileLocationInfo.addElementInfo(jei);
                currToken = parser.getNextToken();
            }
            return this.fileLocationInfo;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

