/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ide.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IdeImageCreator {
    public static BufferedImage getBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int col = 0; col < width; ++col) {
            for (int row = 0; row < height; ++row) {
                image.setRGB(col, row, 0);
            }
        }
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return image;
    }

    public static BufferedImage getGutterMarker(Color themeColor, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int rd = themeColor.getRed() / 2;
        int gd = themeColor.getGreen() / 2;
        int bd = themeColor.getBlue() / 2;
        Color darkColor = new Color(rd, gd, bd);
        int rl = 255 - (255 - themeColor.getRed()) / 4;
        int gl = 255 - (255 - themeColor.getGreen()) / 4;
        int bl = 255 - (255 - themeColor.getBlue()) / 4;
        Color lightColor = new Color(rl, gl, bl);
        graphics.setColor(lightColor);
        graphics.fillRect(0, 0, width - 1, height - 1);
        graphics.setColor(darkColor);
        graphics.drawRect(0, 0, width - 1, height - 1);
        return image;
    }

    public static BufferedImage getGutterStatusImage(Color themeColor, int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        int rud = themeColor.getRed() / 4;
        int gud = themeColor.getGreen() / 4;
        int bud = themeColor.getBlue() / 4;
        Color ultraDarkColor = new Color(rud, gud, bud);
        int rd = themeColor.getRed() / 2;
        int gd = themeColor.getGreen() / 2;
        int bd = themeColor.getBlue() / 2;
        Color darkColor = new Color(rd, gd, bd);
        int rl = 255 - (255 - themeColor.getRed()) / 4;
        int gl = 255 - (255 - themeColor.getGreen()) / 4;
        int bl = 255 - (255 - themeColor.getBlue()) / 4;
        Color lightColor = new Color(rl, gl, bl);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, lightColor, dimension, dimension, darkColor);
        graphics.setPaint(gradient);
        Rectangle rect = new Rectangle(dimension, dimension);
        graphics.fill(rect);
        graphics.setColor(ultraDarkColor);
        graphics.drawLine(0, 0, dimension - 1, 0);
        graphics.drawLine(0, 0, 0, dimension - 1);
        graphics.setColor(lightColor);
        graphics.drawLine(0, dimension - 1, dimension - 1, dimension - 1);
        graphics.drawLine(dimension - 1, 1, dimension - 1, dimension - 1);
        return image;
    }

    public static BufferedImage getErrorMarker(int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.red);
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(new Color(0, 0, 0, 128));
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        float ds = 0.28f * (float)(dimension - 1);
        float de = 0.72f * (float)(dimension - 1);
        GeneralPath gp1 = new GeneralPath();
        gp1.moveTo(ds, ds);
        gp1.lineTo(de, de);
        GeneralPath gp2 = new GeneralPath();
        gp2.moveTo(de, ds);
        gp2.lineTo(ds, de);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(new Color(0, 0, 0, 196));
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(Color.white);
        graphics.draw(gp1);
        graphics.draw(gp2);
        graphics.dispose();
        return image;
    }

    public static Icon getErrorMarkerIcon(int dimension) {
        return new ImageIcon(IdeImageCreator.getErrorMarker(dimension));
    }

    public static BufferedImage getSuccessMarker(int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(new Color(0, 196, 0));
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(new Color(0, 0, 0, 128));
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.25f * (float)dimension, 0.45f * (float)dimension);
        gp.lineTo(0.45f * (float)dimension, 0.65f * (float)dimension);
        gp.lineTo(0.85f * (float)dimension, 0.12f * (float)dimension);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(new Color(0, 0, 0, 196));
        graphics.draw(gp);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(Color.white);
        graphics.draw(gp);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getSuccessCurvedMarker(int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(new Color(0, 196, 0));
        graphics.fillOval(0, 0, dimension - 1, dimension - 1);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(new Ellipse2D.Double(0.0, 0.0, dimension - 1, dimension - 1));
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(new Color(0, 0, 0, 128));
        graphics.drawOval(0, 0, dimension - 1, dimension - 1);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.25f * (float)dimension, 0.45f * (float)dimension);
        gp.quadTo(0.35f * (float)dimension, 0.52f * (float)dimension, 0.45f * (float)dimension, 0.65f * (float)dimension);
        gp.quadTo(0.65f * (float)dimension, 0.3f * (float)dimension, 0.85f * (float)dimension, 0.12f * (float)dimension);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(new Color(0, 0, 0, 196));
        graphics.draw(gp);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(Color.white);
        graphics.draw(gp);
        graphics.dispose();
        return image;
    }

    public static Icon getSuccessMarkerIcon(int dimension) {
        return new ImageIcon(IdeImageCreator.getSuccessMarker(dimension));
    }

    public static Icon getSuccessCurvedMarkerIcon(int dimension) {
        return new ImageIcon(IdeImageCreator.getSuccessCurvedMarker(dimension));
    }

    public static BufferedImage getWarningMarker(int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(new Color(250, 189, 5));
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(new Color(0, 0, 0, 128));
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.6f * height);
        markerPath.moveTo(0.5f * d, 0.85f * height);
        markerPath.lineTo(0.5f * d, 0.85f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(new Color(126, 63, 0));
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(new Color(230, 200, 120));
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static BufferedImage getInfoMarker(int dimension) {
        BufferedImage image = new BufferedImage(dimension, dimension, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath iconOutlinePath = new GeneralPath();
        float d = dimension - 1;
        float d32 = (float)(0.1 * (double)d * Math.sqrt(3.0) / 2.0);
        float height = (float)(1.1 * (double)d * Math.sqrt(3.0) / 2.0);
        iconOutlinePath.moveTo(0.45f * d, d32);
        iconOutlinePath.quadTo(0.5f * d, 0.0f, 0.55f * d, d32);
        iconOutlinePath.lineTo(0.95f * d, height - d32);
        iconOutlinePath.quadTo(d, height, 0.9f * d, height);
        iconOutlinePath.lineTo(0.1f * d, height);
        iconOutlinePath.quadTo(0.0f, height, 0.05f * d, height - d32);
        iconOutlinePath.lineTo(0.45f * d, d32);
        graphics.setColor(new Color(0, 50, 255));
        graphics.fill(iconOutlinePath);
        GradientPaint spot = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 200), dimension, dimension, new Color(255, 255, 255, 0));
        Graphics2D tempGraphics = (Graphics2D)graphics.create();
        tempGraphics.setPaint(spot);
        tempGraphics.setClip(iconOutlinePath);
        tempGraphics.fillRect(0, 0, dimension, dimension);
        tempGraphics.dispose();
        graphics.setColor(new Color(0, 0, 0, 128));
        graphics.draw(iconOutlinePath);
        float dimOuter = (float)(0.5 * Math.pow(dimension, 0.75));
        float dimInner = (float)((double)0.28f * Math.pow(dimension, 0.75));
        GeneralPath markerPath = new GeneralPath();
        markerPath.moveTo(0.5f * d, 0.3f * height);
        markerPath.lineTo(0.5f * d, 0.6f * height);
        markerPath.moveTo(0.5f * d, 0.85f * height);
        markerPath.lineTo(0.5f * d, 0.85f * height);
        graphics.setStroke(new BasicStroke(dimOuter, 1, 1));
        graphics.setColor(Color.black);
        graphics.draw(markerPath);
        graphics.setStroke(new BasicStroke(dimInner, 1, 1));
        graphics.setColor(Color.white);
        graphics.draw(markerPath);
        graphics.dispose();
        return image;
    }

    public static Icon getInfoMarkerIcon(int dimension) {
        return new ImageIcon(IdeImageCreator.getInfoMarker(dimension));
    }

    public static Icon getWarningMarkerIcon(int dimension) {
        return new ImageIcon(IdeImageCreator.getWarningMarker(dimension));
    }

    public static Polygon getRoundedRectangle(Rectangle rect) {
        Polygon border = new Polygon();
        int offsetX = (int)rect.getX();
        int offsetY = (int)rect.getY();
        border.addPoint(offsetX, offsetY + 1);
        border.addPoint(offsetX + 1, offsetY);
        border.addPoint(offsetX + (int)rect.getWidth() - 1, offsetY);
        border.addPoint(offsetX + (int)rect.getWidth(), offsetY + 1);
        border.addPoint(offsetX + (int)rect.getWidth(), offsetY + (int)rect.getHeight() - 1);
        border.addPoint(offsetX + (int)rect.getWidth() - 1, offsetY + (int)rect.getHeight());
        border.addPoint(offsetX + 1, offsetY + (int)rect.getHeight());
        border.addPoint(offsetX, offsetY + (int)rect.getHeight() - 1);
        return border;
    }
}

