/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.license;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LicenseDialog
extends JDialog {
    public static final int ICON_DIMENSION = 16;
    public static final Font TAHOMA = new Font("Tahoma", 0, 11);
    private DefaultTreeModel licenseTreeModel;
    private Map<String, LicenseTreeNode> libraryMapping = new HashMap<String, LicenseTreeNode>();
    private JTree libraryTree;
    private JTextPane licenseTextArea;
    private JSplitPane split;

    public LicenseDialog(Frame owner, String rootLibraryName, LibraryDetails rootLibraryDetails) {
        super(owner, rootLibraryName + " license viewer", true);
        this.licenseTreeModel = new DefaultTreeModel(new LicenseTreeNode(rootLibraryName, rootLibraryDetails));
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.libraryTree = new JTree(this.licenseTreeModel);
        JScrollPane libraryScroll = new JScrollPane(this.libraryTree, 20, 30);
        this.libraryTree.setCellRenderer(new LicenseTreeCellRenderer());
        this.licenseTextArea = new JTextPane();
        this.licenseTextArea.setBorder(new EmptyBorder(2, 2, 2, 2));
        JScrollPane textScroll = new JScrollPane(this.licenseTextArea, 22, 30);
        this.licenseTextArea.setEditable(false);
        this.licenseTextArea.setFont(TAHOMA);
        this.split = new JSplitPane(1, libraryScroll, textScroll);
        this.addComponentListener(new ComponentAdapter(){
            boolean isFirstTime = true;

            public void componentResized(ComponentEvent e) {
                LicenseDialog.this.setVisible(false);
                super.componentResized(e);
                if (this.isFirstTime && LicenseDialog.this.getHeight() > 0) {
                    LicenseDialog.this.split.setDividerLocation((int)(0.4 * (double)LicenseDialog.this.getHeight()));
                    this.isFirstTime = false;
                    LicenseDialog.this.validate();
                } else {
                    LicenseDialog.this.split.setResizeWeight(0.5);
                }
                LicenseDialog.this.setVisible(true);
            }
        });
        this.add((Component)this.split, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LicenseDialog.this.dispose();
            }
        });
        buttonsPanel.add(closeButton);
        this.add((Component)buttonsPanel, "South");
        this.libraryTree.addTreeSelectionListener(new TreeSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(TreeSelectionEvent e) {
                block23: {
                    TreePath selectedPath = e.getNewLeadSelectionPath();
                    Object clickedNode = selectedPath.getLastPathComponent();
                    LicenseDialog.this.licenseTextArea.setEditable(true);
                    LicenseDialog.this.licenseTextArea.setText("");
                    try {
                        if (!(clickedNode instanceof LicenseTreeNode)) break block23;
                        LibraryDetails libraryDetails = ((LicenseTreeNode)clickedNode).getLibraryDetails();
                        if (libraryDetails == null) {
                            return;
                        }
                        String licenseResourceName = libraryDetails.getLicenseResourceName();
                        if (licenseResourceName == null) {
                            return;
                        }
                        LicenseDialog.this.appendColorLine(Color.BLACK, true, "Library name : ");
                        LicenseDialog.this.appendRegularLine(((LicenseTreeNode)clickedNode).getLibraryName());
                        LicenseDialog.this.appendRegularLine(System.getProperty("line.separator"));
                        LicenseDialog.this.appendColorLine(Color.BLACK, true, "Library URL  : ");
                        LicenseDialog.this.appendColorLine(Color.BLUE, false, libraryDetails.getLibraryURL());
                        LicenseDialog.this.appendRegularLine(System.getProperty("line.separator"));
                        LicenseDialog.this.appendColorLine(Color.BLACK, true, "License name : ");
                        LicenseDialog.this.appendRegularLine(libraryDetails.getLicenseFullName());
                        LicenseDialog.this.appendRegularLine(System.getProperty("line.separator"));
                        LicenseDialog.this.appendRegularLine(System.getProperty("line.separator"));
                        InputStream licenseStream = LicenseDialog.class.getClassLoader().getResourceAsStream(licenseResourceName);
                        if (licenseStream != null) {
                            BufferedReader reader = null;
                            try {
                                reader = new BufferedReader(new InputStreamReader(licenseStream));
                                while (true) {
                                    String licenseLine;
                                    if ((licenseLine = reader.readLine()) == null) {
                                    }
                                    LicenseDialog.this.appendRegularLine(licenseLine);
                                    LicenseDialog.this.appendRegularLine(System.getProperty("line.separator"));
                                }
                            }
                            catch (Exception exc) {
                                System.err.println("Failed to retrieve info from '" + licenseResourceName + "'");
                                exc.printStackTrace();
                            }
                            finally {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Exception exc) {}
                                }
                            }
                        } else {
                            System.err.println("Failed to retrieve stream for '" + licenseResourceName + "'");
                        }
                        LicenseDialog.this.licenseTextArea.setCaretPosition(0);
                    }
                    finally {
                        LicenseDialog.this.licenseTextArea.setEditable(false);
                    }
                }
            }
        });
    }

    private void appendRegularLine(String s) {
        this.appendColorLine(Color.BLACK, false, s);
    }

    private void appendColorLine(Color c, boolean isBold, String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        aset = sc.addAttribute(aset, StyleConstants.Bold, isBold);
        this.licenseTextArea.setCharacterAttributes(aset, false);
        this.licenseTextArea.replaceSelection(s);
    }

    public void addNewRootLibrary(String libraryName, LibraryDetails libraryDetails) {
        LicenseTreeNode newNode = new LicenseTreeNode(libraryName, libraryDetails);
        this.libraryMapping.put(libraryName, newNode);
        ((DefaultMutableTreeNode)this.licenseTreeModel.getRoot()).add(newNode);
    }

    public void addNewChildLibrary(String parentLibraryName, String libraryName, LibraryDetails libraryDetails) {
        LicenseTreeNode newNode = new LicenseTreeNode(libraryName, libraryDetails);
        this.libraryMapping.put(libraryName, newNode);
        ((DefaultMutableTreeNode)this.libraryMapping.get(parentLibraryName)).add(newNode);
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.licenseTreeModel.getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    private void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.libraryTree.expandPath(parent);
        } else {
            this.libraryTree.collapsePath(parent);
        }
    }

    public void setLicenseTextAreaFont(Font font) {
        if (font != null) {
            this.licenseTextArea.setFont(font);
            this.repaint();
        }
    }

    private static class LicenseTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JLabel lLicenseIcon = new JLabel();
        private JLabel lLibraryName = new JLabel();
        private JLabel lLicenseName = new JLabel();
        private boolean isSelected;
        public static final Color selectedBackground = new Color(255, 244, 232);
        public static final Color selectedForeground = new Color(64, 32, 0);

        public LicenseTreeCellRenderer() {
            this.lLicenseName.setForeground(Color.GRAY);
            this.lLicenseIcon.setOpaque(false);
            this.lLibraryName.setOpaque(false);
            this.lLicenseName.setOpaque(false);
            this.setOpaque(false);
            this.lLibraryName.setFont(TAHOMA);
            this.lLicenseName.setFont(TAHOMA);
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.isSelected = false;
            this.add(this.lLicenseIcon);
            this.add(this.lLibraryName);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.lLicenseName);
        }

        public final void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isSelected) {
                g.setColor(selectedBackground);
                g.fillRect(0, 0, width - 1, height - 1);
                g.setColor(selectedForeground);
                g.drawRect(0, 0, width - 1, height - 1);
            }
            super.paintComponent(g);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof LicenseTreeNode) {
                LicenseTreeNode ltn = (LicenseTreeNode)value;
                this.lLicenseIcon.setIcon(ltn.getLibraryDetails().getLicenseIcon());
                this.lLibraryName.setText(ltn.getLibraryName());
                if (ltn.getLibraryDetails().getLicenseAbbr() != null) {
                    this.lLicenseName.setText("[" + ltn.getLibraryDetails().getLicenseAbbr() + "]");
                } else {
                    this.lLicenseName.setText("");
                }
            }
            this.isSelected = selected;
            return this;
        }
    }

    private static class LicenseTreeNode
    extends DefaultMutableTreeNode {
        private String libraryName;
        private LibraryDetails libraryDetails;

        public LicenseTreeNode(String libraryName, LibraryDetails libraryDetails) {
            this.libraryName = libraryName;
            this.libraryDetails = libraryDetails;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public LibraryDetails getLibraryDetails() {
            return this.libraryDetails;
        }
    }

    public static class LibraryDetails {
        private String libraryURL;
        private LicenseType licenseType;
        private String licenseAbbr;
        private String licenseFullName;
        private Icon licenseIcon;
        private String licenseResourceName;

        public LibraryDetails(String libraryURL, LicenseType licenseType, String licenseResourceName) {
            this.libraryURL = libraryURL;
            this.licenseType = licenseType;
            this.licenseAbbr = this.licenseType.getAbbr();
            this.licenseFullName = this.licenseType.getFullName();
            this.licenseIcon = this.licenseType.getIcon();
            this.licenseResourceName = licenseResourceName;
        }

        public LibraryDetails(String libraryURL, String licenseAbbr, String licenseFullName, Icon licenseIcon, String licenseResourceName) {
            this.libraryURL = libraryURL;
            this.licenseType = null;
            this.licenseAbbr = licenseAbbr;
            this.licenseFullName = licenseFullName;
            this.licenseIcon = licenseIcon;
            this.licenseResourceName = licenseResourceName;
        }

        public String getLibraryURL() {
            return this.libraryURL;
        }

        public String getLicenseAbbr() {
            return this.licenseAbbr;
        }

        public String getLicenseFullName() {
            return this.licenseFullName;
        }

        public Icon getLicenseIcon() {
            return this.licenseIcon;
        }

        public String getLicenseResourceName() {
            return this.licenseResourceName;
        }

        public LicenseType getLicenseType() {
            return this.licenseType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LicenseType {
        APACHE2("Apache 2.0", "Apache License, Version 2.0", LicenseType.getLicenseIcon("A2")),
        APACHE("ASL", "Apache Software License", LicenseType.getLicenseIcon("Ap")),
        BSD("BSD", "Berkeley Software Distribution License", LicenseType.getLicenseIcon("Bk")),
        CDDL("CDDL", "Common Development and Distribution License", LicenseType.getLicenseIcon("Cd")),
        CPL("CPL", "Common Public License", LicenseType.getLicenseIcon("Cm")),
        EPL("EPL", "Eclipse Public License", LicenseType.getLicenseIcon("Ec")),
        GPL("GPL", "GNU General Public License", LicenseType.getLicenseIcon("Gn")),
        JIUL("JIUL", "Java Internal Users License", LicenseType.getLicenseIcon("Ji")),
        JRL("JRL", "Java Research License", LicenseType.getLicenseIcon("Jr")),
        LGPL("LGPL", "Lesser General Public License", LicenseType.getLicenseIcon("Lg")),
        MPL("MPL", "Mozilla Public License", LicenseType.getLicenseIcon("M")),
        SCSL("SCSL", "Sun Community Source License", LicenseType.getLicenseIcon("Sc")),
        SISSL("SISSL", "Sun Industry Standards Source License", LicenseType.getLicenseIcon("Si")),
        SPL("SPL", "Sun Public License", LicenseType.getLicenseIcon("Sp"));

        private String abbr;
        private String fullName;
        private Icon icon;

        private LicenseType(String abbr, String fullName, Icon icon) {
            this.abbr = abbr;
            this.fullName = fullName;
            this.icon = icon;
        }

        public String getAbbr() {
            return this.abbr;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public static Icon getLicenseIcon(String str) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setFont(new Font("Arial", 1, 9));
            float xLetter = 0.0f;
            float yLetter = 15.0f;
            int rectWidth = 10;
            int rectHeight = 12;
            graphics.setColor(new Color(0, 128, 128, 32));
            graphics.fillRect(2, 0, rectWidth, rectHeight);
            graphics.setColor(new Color(0, 128, 128, 128));
            graphics.drawRect(2, 0, rectWidth, rectHeight);
            for (int i = 2; i < rectHeight - 1; i += 2) {
                int len = (int)(1.0 + (double)(rectWidth - 5) * Math.random());
                graphics.drawLine(4, i, 4 + len, i);
            }
            graphics.setColor(new Color(0, 0, 128));
            graphics.drawString(str, xLetter, yLetter);
            return new ImageIcon(image);
        }
    }
}

