/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonGalleryUI;
import org.jvnet.flamingo.ribbon.ui.RibbonGalleryUI;

public class JRibbonGallery
extends JComponent {
    protected List<JRibbonButton> buttons = new ArrayList<JRibbonButton>();
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected GalleryElementState state;
    protected Map<GalleryElementState, Integer> preferredWidths = new HashMap<GalleryElementState, Integer>();
    protected JRibbonButton selectedButton;
    protected JPopupGallery popupGallery;
    protected JToggleButton invisible;
    private static final String uiClassID = "RibbonGalleryUI";

    public JRibbonGallery() {
        for (GalleryElementState state : GalleryElementState.values()) {
            this.preferredWidths.put(state, 100);
        }
        this.invisible = new JToggleButton();
        this.invisible.setVisible(false);
        this.buttonGroup.add(this.invisible);
        this.updateUI();
    }

    public void setUI(RibbonGalleryUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonGalleryUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonGalleryUI());
        }
        if (this.popupGallery != null) {
            SwingUtilities.updateComponentTreeUI(this.popupGallery);
        }
    }

    public RibbonGalleryUI getUI() {
        return (RibbonGalleryUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void addGalleryButton(JRibbonButton button) {
        this.buttons.add(button);
        button.setToggle(true);
        this.buttonGroup.add(button);
        button.setState(GalleryElementState.BIG, true);
        super.add(button);
    }

    public Component add(Component comp, int index) {
        if (comp instanceof UIResource) {
            return super.add(comp, index);
        }
        throw new UnsupportedOperationException("Use addGalleryButton()");
    }

    public void add(Component comp, Object constraints, int index) {
        if (comp instanceof UIResource) {
            super.add(comp, constraints, index);
            return;
        }
        throw new UnsupportedOperationException("Use addGalleryButton()");
    }

    public void add(Component comp, Object constraints) {
        if (comp instanceof UIResource) {
            super.add(comp, constraints);
            return;
        }
        throw new UnsupportedOperationException("Use addGalleryButton()");
    }

    public Component add(Component comp) {
        if (comp instanceof UIResource) {
            return super.add(comp);
        }
        throw new UnsupportedOperationException("Use addGalleryButton()");
    }

    public Component add(String name, Component comp) {
        if (comp instanceof UIResource) {
            return super.add(name, comp);
        }
        throw new UnsupportedOperationException("Use addGalleryButton()");
    }

    public void remove(Component comp) {
        if (comp instanceof UIResource) {
            super.remove(comp);
            return;
        }
        throw new UnsupportedOperationException("Remove not supported");
    }

    public void setPreferredWidth(GalleryElementState state, int width) {
        this.preferredWidths.put(state, width);
    }

    public int getPreferredWidth(GalleryElementState state) {
        return this.preferredWidths.get((Object)state);
    }

    public void setState(GalleryElementState state) {
        this.state = state;
    }

    public GalleryElementState getState() {
        return this.state;
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public JRibbonButton getButtonAt(int index) {
        return this.buttons.get(index);
    }

    public JRibbonButton getSelectedButton() {
        return this.selectedButton;
    }

    public void setSelectedButton(JRibbonButton selectedButton) {
        if (selectedButton != null) {
            selectedButton.setSelected(true);
        } else {
            this.invisible.setSelected(true);
        }
        this.selectedButton = selectedButton;
        this.repaint();
    }

    public JPopupGallery getPopupGallery() {
        return this.popupGallery;
    }

    public void setPopupGallery(JPopupGallery popupGallery) {
        this.popupGallery = popupGallery;
    }
}

