/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.gallery;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.ResizableIcon;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.gallery.IconPopupGalleryTitlePane;
import org.jvnet.flamingo.ribbon.gallery.JPopupGallery;

public class IconPopupGallery
extends JPopupGallery {
    protected ArrayList<IconGroup> iconGroups;
    protected int maxWidth;
    protected int maxHeight;
    protected int rowHeightInPixels;
    protected JPanel iconPanel;
    protected JScrollPane scroll;
    protected JToggleButton invisible;
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected JRibbonButton selectedButton;

    public IconPopupGallery(int maxWidth, int maxHeight, int rowHeightInPixels) {
        this.iconGroups = new ArrayList();
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.rowHeightInPixels = rowHeightInPixels;
        this.setBorder(UIManager.getBorder("PopupGallery.border"));
        this.iconPanel = new JPanel();
        this.iconPanel.setOpaque(false);
        this.iconPanel.setLayout(new IconGalleryLayout());
        this.scroll = new JScrollPane(this.iconPanel, 20, 31);
        this.scroll.setBorder(null);
        this.scroll.setOpaque(false);
        this.scroll.getViewport().setOpaque(false);
        this.setLayout(new IconPopupLayout());
        this.setMaximumSize(new Dimension(this.maxWidth, this.maxHeight));
        this.add(this.scroll);
        this.invisible = new JToggleButton();
        this.invisible.setVisible(false);
        this.buttonGroup.add(this.invisible);
    }

    public IconGroup createNewGroup(String groupTitle, int index) {
        IconGroup group = new IconGroup(this, groupTitle);
        this.iconGroups.add(index, group);
        this.iconPanel.add(group.titlePanel);
        return group;
    }

    public void removeIconGroup(int index) {
        IconGroup group = this.iconGroups.remove(index);
        this.remove(group.titlePanel);
        for (JRibbonButton gb : group.iconButtons) {
            this.remove(gb);
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public void setSelectedButton(JRibbonButton selectedButton) {
        if (selectedButton != null) {
            selectedButton.setSelected(true);
        } else {
            this.invisible.setSelected(true);
        }
        this.selectedButton = selectedButton;
        this.repaint();
    }

    protected class IconGalleryLayout
    implements LayoutManager {
        public static final int STRUT = 2;

        protected IconGalleryLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            int top;
            Insets bInsets = IconPopupGallery.this.getBorder().getBorderInsets(IconPopupGallery.this);
            int left = bInsets.left + 2;
            int right = bInsets.right + 2;
            int y = top = bInsets.top + 2;
            int maxButtonWidth = 0;
            for (IconGroup iconGroup : IconPopupGallery.this.iconGroups) {
                for (JRibbonButton gb : iconGroup.iconButtons) {
                    maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                }
            }
            for (IconGroup iconGroup : IconPopupGallery.this.iconGroups) {
                int labelH = ((IconGroup)iconGroup).titlePanel.getPreferredSize().height;
                iconGroup.titlePanel.setBounds(left, y, IconPopupGallery.this.maxWidth - left - right, labelH);
                y += labelH;
                int currX = left;
                for (JRibbonButton gb : iconGroup.iconButtons) {
                    int endX = currX + maxButtonWidth;
                    if (endX > IconPopupGallery.this.maxWidth - right) {
                        currX = left;
                        y += IconPopupGallery.this.rowHeightInPixels;
                    }
                    gb.setBounds(currX, y, maxButtonWidth, IconPopupGallery.this.rowHeightInPixels);
                    currX += maxButtonWidth;
                }
                y += IconPopupGallery.this.rowHeightInPixels;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets bInsets = IconPopupGallery.this.getBorder().getBorderInsets(IconPopupGallery.this);
            int top = bInsets.top + 2;
            int bottom = bInsets.bottom + 2;
            int height = top + bottom;
            int maxButtonWidth = 0;
            for (IconGroup iconGroup : IconPopupGallery.this.iconGroups) {
                for (JRibbonButton gb : iconGroup.iconButtons) {
                    maxButtonWidth = Math.max(maxButtonWidth, gb.getPreferredSize().width);
                }
            }
            int buttonsInRow = IconPopupGallery.this.maxWidth / maxButtonWidth;
            for (IconGroup iconGroup : IconPopupGallery.this.iconGroups) {
                height += ((IconGroup)iconGroup).titlePanel.getPreferredSize().height;
                int iconRows = (int)Math.ceil((double)iconGroup.iconButtons.size() / (double)buttonsInRow);
                height += iconRows * IconPopupGallery.this.rowHeightInPixels;
            }
            return new Dimension(IconPopupGallery.this.maxWidth, height);
        }
    }

    protected class IconPopupLayout
    implements LayoutManager {
        protected IconPopupLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets insets = IconPopupGallery.this.getBorder().getBorderInsets(IconPopupGallery.this);
            int left = insets.left;
            int right = insets.right;
            int top = insets.top;
            int bottom = insets.bottom;
            IconPopupGallery.this.scroll.setBounds(left, top, parent.getWidth() - left - right, parent.getHeight() - top - bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = IconPopupGallery.this.getBorder().getBorderInsets(IconPopupGallery.this);
            int left = insets.left;
            int right = insets.right;
            int top = insets.top;
            int bottom = insets.bottom;
            Dimension controlPanelDim = IconPopupGallery.this.iconPanel.getPreferredSize();
            int w = Math.min(controlPanelDim.width, IconPopupGallery.this.maxWidth) + left + right;
            int h = Math.min(controlPanelDim.height, IconPopupGallery.this.maxHeight) + top + bottom;
            if (h == IconPopupGallery.this.maxHeight + top + bottom) {
                w += UIManager.getInt("ScrollBar.width");
            }
            return new Dimension(w, h);
        }
    }

    public static class IconGroup {
        private IconPopupGallery gallery;
        private String groupTitle;
        private ArrayList<JRibbonButton> iconButtons;
        private IconPopupGalleryTitlePane titlePanel;

        private IconGroup(IconPopupGallery gallery, String title) {
            this.gallery = gallery;
            this.groupTitle = title;
            this.iconButtons = new ArrayList();
            this.titlePanel = new IconPopupGalleryTitlePane(this.groupTitle);
            this.gallery = gallery;
        }

        public String getTitle() {
            return this.groupTitle;
        }

        public JRibbonButton addIcon(ResizableIcon icon, String iconTitle, ActionListener actionListener) {
            return this.addIcon(icon, iconTitle, actionListener, this.iconButtons.size());
        }

        public JRibbonButton addIcon(ResizableIcon icon, String iconTitle, final ActionListener actionListener, int index) {
            final JRibbonButton iconRibbonButton = new JRibbonButton(null, iconTitle, icon, icon);
            iconRibbonButton.setToggle(true);
            iconRibbonButton.setState(GalleryElementState.ORIG, true);
            if (actionListener != null) {
                iconRibbonButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        actionListener.actionPerformed(new ActionEvent(iconRibbonButton, 1001, "pressed"));
                    }
                });
            }
            this.iconButtons.add(index, iconRibbonButton);
            this.gallery.iconPanel.add(iconRibbonButton);
            this.gallery.buttonGroup.add(iconRibbonButton);
            return iconRibbonButton;
        }

        public void removeIcon(int index) {
            JRibbonButton gb = this.iconButtons.remove(index);
            this.gallery.iconPanel.remove(gb);
        }
    }
}

