/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.ribbon.GalleryElementState;
import org.jvnet.flamingo.ribbon.JBandControlPanel;
import org.jvnet.flamingo.ribbon.JRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonButton;
import org.jvnet.flamingo.ribbon.JRibbonGallery;
import org.jvnet.flamingo.ribbon.ui.BandControlPanelUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBandControlPanelUI
extends BandControlPanelUI {
    public static final int STRUT_X = 4;
    protected JBandControlPanel controlPanel;
    protected JRibbonBand.RibbonBandCollapseKind currentFitCollapse;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBandControlPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.controlPanel = (JBandControlPanel)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.controlPanel = null;
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.controlPanel, "ControlPanel.background", "ControlPanel.foreground", "ControlPanel.font");
        LookAndFeel.installBorder(this.controlPanel, "ControlPanel.border");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.controlPanel);
    }

    protected LayoutManager createLayoutManager() {
        return new ControlPanelLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintBandBackground(graphics, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        graphics.dispose();
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.controlPanel.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    public int getPreferredWidth(JRibbonBand.RibbonBandCollapseKind collapseKind) {
        int panelWidth = 0;
        List<JRibbonGallery> topGalleries = this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.TOP);
        List<JRibbonGallery> mediumGalleries = this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.MEDIUM);
        List<JRibbonGallery> lowGalleries = this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.LOW);
        LinkedList<JRibbonGallery> tempTopGalleries = new LinkedList<JRibbonGallery>();
        LinkedList<JRibbonGallery> tempMediumGalleries = new LinkedList<JRibbonGallery>();
        LinkedList<JRibbonGallery> tempLowGalleries = new LinkedList<JRibbonGallery>();
        switch (collapseKind) {
            case NONE: {
                for (JRibbonGallery top : topGalleries) {
                    tempTopGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempTopGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempTopGalleries.add(low);
                }
                break;
            }
            case LOW_TO_MID: {
                for (JRibbonGallery top : topGalleries) {
                    tempTopGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempTopGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempMediumGalleries.add(low);
                }
                break;
            }
            case MID_TO_MID: {
                for (JRibbonGallery top : topGalleries) {
                    tempTopGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempMediumGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempMediumGalleries.add(low);
                }
                break;
            }
            case LOW_TO_LOW: {
                for (JRibbonGallery top : topGalleries) {
                    tempTopGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempMediumGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempLowGalleries.add(low);
                }
                break;
            }
            case MID_TO_LOW: {
                for (JRibbonGallery top : topGalleries) {
                    tempTopGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempLowGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempLowGalleries.add(low);
                }
                break;
            }
            case HIGH_TO_MID: {
                for (JRibbonGallery top : topGalleries) {
                    tempMediumGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempLowGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempLowGalleries.add(low);
                }
                break;
            }
            case HIGH_TO_LOW: {
                for (JRibbonGallery top : topGalleries) {
                    tempLowGalleries.add(top);
                }
                for (JRibbonGallery med : mediumGalleries) {
                    tempLowGalleries.add(med);
                }
                for (JRibbonGallery low : lowGalleries) {
                    tempLowGalleries.add(low);
                }
                break;
            }
        }
        for (JRibbonGallery top : tempTopGalleries) {
            panelWidth += top.getPreferredWidth(GalleryElementState.BIG) + 4;
        }
        for (JRibbonGallery med : tempMediumGalleries) {
            panelWidth += med.getPreferredWidth(GalleryElementState.MEDIUM) + 4;
        }
        for (JRibbonGallery low : tempLowGalleries) {
            panelWidth += low.getPreferredWidth(GalleryElementState.SMALL) + 4;
        }
        for (JPanel panel : this.controlPanel.getPanels()) {
            panelWidth += panel.getPreferredSize().width;
        }
        List<JRibbonButton> topButtons = this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.TOP);
        List<JRibbonButton> mediumButtons = this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.MEDIUM);
        List<JRibbonButton> lowButtons = this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.LOW);
        LinkedList<JRibbonButton> tempTopButtons = new LinkedList<JRibbonButton>();
        LinkedList<JRibbonButton> tempMediumButtons = new LinkedList<JRibbonButton>();
        LinkedList<JRibbonButton> tempLowButtons = new LinkedList<JRibbonButton>();
        HashMap buttonStateMap = new HashMap();
        buttonStateMap.put(GalleryElementState.BIG, new LinkedList());
        buttonStateMap.put(GalleryElementState.MEDIUM, new LinkedList());
        buttonStateMap.put(GalleryElementState.SMALL, new LinkedList());
        for (JRibbonButton jRibbonButton : topButtons) {
            ((List)buttonStateMap.get((Object)jRibbonButton.getState())).add(jRibbonButton);
        }
        for (JRibbonButton jRibbonButton : mediumButtons) {
            ((List)buttonStateMap.get((Object)jRibbonButton.getState())).add(jRibbonButton);
        }
        for (JRibbonButton jRibbonButton : lowButtons) {
            ((List)buttonStateMap.get((Object)jRibbonButton.getState())).add(jRibbonButton);
        }
        switch (collapseKind) {
            case NONE: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                break;
            }
            case LOW_TO_MID: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempMediumButtons.add(jRibbonButton);
                }
                break;
            }
            case MID_TO_MID: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempMediumButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempMediumButtons.add(jRibbonButton);
                }
                break;
            }
            case LOW_TO_LOW: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempMediumButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                break;
            }
            case MID_TO_LOW: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempTopButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                break;
            }
            case HIGH_TO_MID: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempMediumButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                break;
            }
            case HIGH_TO_LOW: {
                for (JRibbonButton jRibbonButton : topButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : mediumButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                for (JRibbonButton jRibbonButton : lowButtons) {
                    tempLowButtons.add(jRibbonButton);
                }
                break;
            }
        }
        for (JRibbonButton jRibbonButton : tempTopButtons) {
            jRibbonButton.setState(GalleryElementState.BIG, false);
        }
        for (JRibbonButton jRibbonButton : tempMediumButtons) {
            jRibbonButton.setState(GalleryElementState.MEDIUM, false);
        }
        for (JRibbonButton jRibbonButton : tempLowButtons) {
            jRibbonButton.setState(GalleryElementState.SMALL, false);
        }
        panelWidth += this.getWidth(tempTopButtons, tempMediumButtons, tempLowButtons);
        for (Map.Entry entry : buttonStateMap.entrySet()) {
            for (JRibbonButton button : (List)entry.getValue()) {
                button.setState((GalleryElementState)((Object)entry.getKey()), false);
            }
        }
        return panelWidth;
    }

    protected int getWidth(List<JRibbonButton> bigButtons, List<JRibbonButton> mediumButtons, List<JRibbonButton> smallButtons) {
        int result = 4;
        for (JRibbonButton top : bigButtons) {
            result = (int)((double)result + top.getPreferredSize().getWidth());
            result += 4;
        }
        int medSize = mediumButtons.size();
        if (medSize > 0) {
            while (mediumButtons.size() % 3 != 0 && smallButtons.size() > 0) {
                JRibbonButton low = smallButtons.remove(0);
                low.setState(GalleryElementState.MEDIUM, false);
                mediumButtons.add(low);
            }
        }
        int index3 = 0;
        int maxWidth3 = 0;
        for (JRibbonButton medium : mediumButtons) {
            int medWidth = medium.getPreferredSize().width;
            maxWidth3 = Math.max(maxWidth3, medWidth);
            if (++index3 != 3) continue;
            index3 = 0;
            result += maxWidth3;
            result += 4;
            maxWidth3 = 0;
        }
        result += maxWidth3;
        if (maxWidth3 > 0) {
            result += 4;
        }
        index3 = 0;
        maxWidth3 = 0;
        for (JRibbonButton low : smallButtons) {
            int lowWidth = low.getPreferredSize().width;
            maxWidth3 = Math.max(maxWidth3, lowWidth);
            if (++index3 != 3) continue;
            index3 = 0;
            result += maxWidth3;
            result += 4;
            maxWidth3 = 0;
        }
        result += maxWidth3;
        return result += 4;
    }

    private class ControlPanelLayout
    implements LayoutManager {
        private ControlPanelLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return c.getSize();
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            block93: {
                Rectangle bounds;
                int shiftX;
                List<JRibbonButton> lowButtons;
                List<JRibbonButton> mediumButtons;
                List<JRibbonButton> topButtons;
                block92: {
                    Rectangle bounds2;
                    int pw;
                    int x = 4;
                    JRibbonBand.RibbonBandCollapseKind bestFitCollapse = JRibbonBand.RibbonBandCollapseKind.getSortedKinds().getLast();
                    for (JRibbonBand.RibbonBandCollapseKind collapseKind : JRibbonBand.RibbonBandCollapseKind.getSortedKinds()) {
                        int collapsedWidth = BasicBandControlPanelUI.this.getPreferredWidth(collapseKind);
                        if (collapsedWidth > c.getWidth()) continue;
                        bestFitCollapse = collapseKind;
                        break;
                    }
                    BasicBandControlPanelUI.this.currentFitCollapse = bestFitCollapse;
                    if (bestFitCollapse == JRibbonBand.RibbonBandCollapseKind.ICON) {
                        return;
                    }
                    List<JRibbonGallery> topGalleries = BasicBandControlPanelUI.this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.TOP);
                    List<JRibbonGallery> mediumGalleries = BasicBandControlPanelUI.this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.MEDIUM);
                    List<JRibbonGallery> lowGalleries = BasicBandControlPanelUI.this.controlPanel.getRibbonGalleries(JRibbonBand.RibbonElementPriority.LOW);
                    switch (bestFitCollapse) {
                        case NONE: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.BIG);
                            }
                            break;
                        }
                        case LOW_TO_MID: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.MEDIUM);
                            }
                            break;
                        }
                        case MID_TO_MID: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.MEDIUM);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.MEDIUM);
                            }
                            break;
                        }
                        case LOW_TO_LOW: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.MEDIUM);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.SMALL);
                            }
                            break;
                        }
                        case MID_TO_LOW: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.BIG);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.SMALL);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.SMALL);
                            }
                            break;
                        }
                        case HIGH_TO_MID: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.MEDIUM);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.SMALL);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.SMALL);
                            }
                            break;
                        }
                        case HIGH_TO_LOW: {
                            for (JRibbonGallery top : topGalleries) {
                                top.setState(GalleryElementState.SMALL);
                            }
                            for (JRibbonGallery med : mediumGalleries) {
                                med.setState(GalleryElementState.SMALL);
                            }
                            for (JRibbonGallery low : lowGalleries) {
                                low.setState(GalleryElementState.SMALL);
                            }
                            break;
                        }
                    }
                    HashMap galleryStateMap = new HashMap();
                    galleryStateMap.put(GalleryElementState.BIG, new LinkedList());
                    galleryStateMap.put(GalleryElementState.MEDIUM, new LinkedList());
                    galleryStateMap.put(GalleryElementState.SMALL, new LinkedList());
                    for (JRibbonGallery top : topGalleries) {
                        ((List)galleryStateMap.get((Object)top.getState())).add(top);
                    }
                    for (JRibbonGallery med : mediumGalleries) {
                        ((List)galleryStateMap.get((Object)med.getState())).add(med);
                    }
                    for (JRibbonGallery low : lowGalleries) {
                        ((List)galleryStateMap.get((Object)low.getState())).add(low);
                    }
                    for (JRibbonGallery big : (List)galleryStateMap.get((Object)GalleryElementState.BIG)) {
                        pw = big.getPreferredWidth(GalleryElementState.BIG);
                        big.setBounds(x, 0, pw, 68);
                        x += pw;
                        x += 4;
                    }
                    for (JRibbonGallery med : (List)galleryStateMap.get((Object)GalleryElementState.MEDIUM)) {
                        pw = med.getPreferredWidth(GalleryElementState.MEDIUM);
                        med.setBounds(x, 0, pw, 68);
                        x += pw;
                        x += 4;
                    }
                    for (JRibbonGallery small : (List)galleryStateMap.get((Object)GalleryElementState.SMALL)) {
                        pw = small.getPreferredWidth(GalleryElementState.SMALL);
                        small.setBounds(x, 0, pw, 68);
                        x += pw;
                        x += 4;
                    }
                    for (JPanel panel : BasicBandControlPanelUI.this.controlPanel.getPanels()) {
                        pw = panel.getPreferredSize().width;
                        panel.setBounds(x, 0, pw, 68);
                        x += pw;
                        x += 4;
                    }
                    topButtons = BasicBandControlPanelUI.this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.TOP);
                    mediumButtons = BasicBandControlPanelUI.this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.MEDIUM);
                    lowButtons = BasicBandControlPanelUI.this.controlPanel.getRibbonButtons(JRibbonBand.RibbonElementPriority.LOW);
                    switch (bestFitCollapse) {
                        case NONE: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.BIG, true);
                            }
                            break;
                        }
                        case LOW_TO_MID: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.MEDIUM, true);
                            }
                            break;
                        }
                        case MID_TO_MID: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.MEDIUM, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.MEDIUM, true);
                            }
                            break;
                        }
                        case LOW_TO_LOW: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.MEDIUM, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.SMALL, true);
                            }
                            break;
                        }
                        case MID_TO_LOW: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.BIG, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.SMALL, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.SMALL, true);
                            }
                            break;
                        }
                        case HIGH_TO_MID: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.MEDIUM, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.SMALL, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.SMALL, true);
                            }
                            break;
                        }
                        case HIGH_TO_LOW: {
                            for (JRibbonButton top : topButtons) {
                                top.setState(GalleryElementState.SMALL, true);
                            }
                            for (JRibbonButton med : mediumButtons) {
                                med.setState(GalleryElementState.SMALL, true);
                            }
                            for (JRibbonButton low : lowButtons) {
                                low.setState(GalleryElementState.SMALL, true);
                            }
                            break;
                        }
                    }
                    HashMap buttonStateMap = new HashMap();
                    buttonStateMap.put(GalleryElementState.BIG, new LinkedList());
                    buttonStateMap.put(GalleryElementState.MEDIUM, new LinkedList());
                    buttonStateMap.put(GalleryElementState.SMALL, new LinkedList());
                    for (JRibbonButton top : topButtons) {
                        ((List)buttonStateMap.get((Object)top.getState())).add(top);
                    }
                    for (JRibbonButton med : mediumButtons) {
                        ((List)buttonStateMap.get((Object)med.getState())).add(med);
                    }
                    for (JRibbonButton low : lowButtons) {
                        ((List)buttonStateMap.get((Object)low.getState())).add(low);
                    }
                    for (JRibbonButton big : (List)buttonStateMap.get((Object)GalleryElementState.BIG)) {
                        big.setBounds(x, 0, big.getPreferredSize().width, 68);
                        x += big.getPreferredSize().width;
                        x += 4;
                    }
                    int medSize = ((List)buttonStateMap.get((Object)GalleryElementState.MEDIUM)).size();
                    if (medSize > 0) {
                        while (((List)buttonStateMap.get((Object)GalleryElementState.MEDIUM)).size() % 3 != 0 && ((List)buttonStateMap.get((Object)GalleryElementState.SMALL)).size() > 0) {
                            JRibbonButton low;
                            low = (JRibbonButton)((List)buttonStateMap.get((Object)GalleryElementState.SMALL)).get(0);
                            ((List)buttonStateMap.get((Object)GalleryElementState.SMALL)).remove(low);
                            low.setState(GalleryElementState.MEDIUM, true);
                            ((List)buttonStateMap.get((Object)GalleryElementState.MEDIUM)).add(low);
                        }
                    }
                    int index3 = 0;
                    int maxWidth3 = 0;
                    HashSet<JRibbonButton> threesome = new HashSet<JRibbonButton>();
                    for (JRibbonButton medium : (List)buttonStateMap.get((Object)GalleryElementState.MEDIUM)) {
                        int medWidth = medium.getPreferredSize().width;
                        maxWidth3 = Math.max(maxWidth3, medWidth);
                        medium.setBounds(x, index3 * 68 / 3, medWidth, 22);
                        threesome.add(medium);
                        if (++index3 != 3) continue;
                        for (JRibbonButton button : threesome) {
                            Rectangle rectangle = button.getBounds();
                            button.setBounds(rectangle.x, rectangle.y, maxWidth3, rectangle.height);
                        }
                        index3 = 0;
                        x += maxWidth3;
                        x += 4;
                        maxWidth3 = 0;
                        threesome.clear();
                    }
                    x += maxWidth3;
                    if (maxWidth3 > 0) {
                        x += 4;
                    }
                    index3 = 0;
                    maxWidth3 = 0;
                    for (JRibbonButton small : (List)buttonStateMap.get((Object)GalleryElementState.SMALL)) {
                        int lowWidth = small.getPreferredSize().width;
                        maxWidth3 = Math.max(maxWidth3, lowWidth);
                        small.setBounds(x, index3 * 68 / 3, lowWidth, 22);
                        threesome.add(small);
                        if (++index3 != 3) continue;
                        for (JRibbonButton button : threesome) {
                            Rectangle rectangle = button.getBounds();
                            button.setBounds(rectangle.x, rectangle.y, maxWidth3, rectangle.height);
                        }
                        index3 = 0;
                        x += maxWidth3;
                        x += 4;
                        maxWidth3 = 0;
                        threesome.clear();
                    }
                    x += maxWidth3;
                    if (maxWidth3 > 0) {
                        x += 4;
                    }
                    shiftX = (c.getWidth() - x) / 2;
                    if (!BasicBandControlPanelUI.this.controlPanel.hasRibbonGalleries()) break block92;
                    int galleryCount = BasicBandControlPanelUI.this.controlPanel.getRibbonGalleriesCount();
                    int delta = 0;
                    delta = shiftX < 0 ? -2 * (int)Math.ceil((double)(-shiftX) / (double)galleryCount) : 2 * (int)Math.ceil((double)shiftX / (double)galleryCount);
                    int totalDelta = 0;
                    for (JRibbonGallery jRibbonGallery : topGalleries) {
                        Rectangle bounds22 = jRibbonGallery.getBounds();
                        jRibbonGallery.setBounds(bounds22.x + totalDelta, bounds22.y, bounds22.width + delta, bounds22.height);
                        totalDelta += delta;
                    }
                    for (JRibbonGallery jRibbonGallery : mediumGalleries) {
                        bounds2 = jRibbonGallery.getBounds();
                        jRibbonGallery.setBounds(bounds2.x + totalDelta, bounds2.y, bounds2.width + delta, bounds2.height);
                        totalDelta += delta;
                    }
                    for (JRibbonGallery jRibbonGallery : lowGalleries) {
                        bounds2 = jRibbonGallery.getBounds();
                        jRibbonGallery.setBounds(bounds2.x + totalDelta, bounds2.y, bounds2.width + delta, bounds2.height);
                        totalDelta += delta;
                    }
                    for (JPanel jPanel : BasicBandControlPanelUI.this.controlPanel.getPanels()) {
                        bounds2 = jPanel.getBounds();
                        jPanel.setBounds(bounds2.x + 2 * shiftX, bounds2.y, bounds2.width, bounds2.height);
                    }
                    for (JRibbonButton jRibbonButton : topButtons) {
                        bounds2 = jRibbonButton.getBounds();
                        jRibbonButton.setBounds(bounds2.x + 2 * shiftX, bounds2.y, bounds2.width, bounds2.height);
                    }
                    for (JRibbonButton jRibbonButton : mediumButtons) {
                        bounds2 = jRibbonButton.getBounds();
                        jRibbonButton.setBounds(bounds2.x + 2 * shiftX, bounds2.y, bounds2.width, bounds2.height);
                    }
                    for (JRibbonButton jRibbonButton : lowButtons) {
                        bounds2 = jRibbonButton.getBounds();
                        jRibbonButton.setBounds(bounds2.x + 2 * shiftX, bounds2.y, bounds2.width, bounds2.height);
                    }
                    break block93;
                }
                if (shiftX <= 0) break block93;
                for (JPanel panel : BasicBandControlPanelUI.this.controlPanel.getPanels()) {
                    bounds = panel.getBounds();
                    panel.setBounds(bounds.x + shiftX, bounds.y, bounds.width, bounds.height);
                }
                for (JRibbonButton top : topButtons) {
                    bounds = top.getBounds();
                    top.setBounds(bounds.x + shiftX, bounds.y, bounds.width, bounds.height);
                }
                for (JRibbonButton med : mediumButtons) {
                    bounds = med.getBounds();
                    med.setBounds(bounds.x + shiftX, bounds.y, bounds.width, bounds.height);
                }
                for (JRibbonButton low : lowButtons) {
                    bounds = low.getBounds();
                    low.setBounds(bounds.x + shiftX, bounds.y, bounds.width, bounds.height);
                }
            }
        }
    }
}

